
title ENABLE/DISABLE USE OF XON/XOFF
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

IMPORT_NEAR     <__tx_inton>

;****************************************************************************
; ASYNC_XONOFF -- Enables or disables use of XON/XOFF protocol.
;****************************************************************************
begseg          COMM_TEXT
publicproc      _async_xonoff
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      xon_exit        ;bad arg if ZR flag set
        cmp     Flag,OFF        ;turning protocol off?
        jne     enable_prtcl
;disable_prtcl:
        cli
        test    STAT2,B_XSENT   ;has an XOFF been sent?
        jz      finish_disable       ;if disabling and an XOFF has been sent,
        mov     TXIMMEDCHAR,XONCHAR  ;clear XOFF sent condition befr disabling
        and     TX_STAT,n B_TXEMPTY ;clear the nothing to send bit
        jnz     finish_disable
        call    __tx_inton      ;turn tx intrpts if not on alrdy & no flw halts
finish_disable:
        and     STAT2,11111000b ;clear XON/OFF related bits if arg was OFF
        sti
        jmp s   xon_ex1
enable_prtcl:
        or      STAT2,B_XUSE    ;set bit to enable if arg was ON
        and     STAT3,n B_XONANY ;and clr bit that allows any char to be an XON
xon_ex1:
        xor     ax,ax           ;return R_OK
xon_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_xonoff   endp

endseg          COMM_TEXT
        end
