
title MANUALLY CLEAR RX'D XOFF CONDITION
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

IMPORT_NEAR     <__tx_inton>

;****************************************************************************
; ASYNC_XOFFCLR -- Clears XOFF received condition manually and re-enables
;  transmitting of characters.  If the remote's rx buffer is actually getting
;  full this may result in a buffer overflow on that end or another XOFF
;  may be sent by the remote in which case transmission will stop again.
;****************************************************************************
begseg          COMM_TEXT
publicproc      _async_xoffclr
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      xoffclr_exit    ;bad arg if ZR flag set
        mov     ax,R_BADARG
        test    STAT2,B_XUSE
        jz      xoffclr_exit    ;bad arg if not using XOFF protocol
        cli
        and     TX_STAT,n B_XRXD  ;clr XOFF rcvd bit
        jnz     xoffclr_ex1     ;done if some other reason not to transmit
        call    __tx_inton      ;else restart transmitter
xoffclr_ex1:
        sti
        xor     ax,ax           ;returning R_OK
xoffclr_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_xoffclr  endp

endseg          COMM_TEXT
        end
