
title SUPPORT FUNCTIONS FOR ASYNC ROUTINES
page 75,132

;-- Mike Dumdei, 6 Holly Lane, Texarkana TX 75503

include casmhdr.h
defseg          COMM_TEXT
include async.h
IMPORT_WORD     <__port_dta_tbl>

_DATA           segment
times_ten       dw      10
_DATA           ends

begseg          COMM_TEXT

;-----------------------------------------------------------------------------
; Procedure to check validity of port argument passed by calling function and
; load pointers specific to the selected port.
;
;   Entry: stack frame is setup
;
;   Exit : CY flag = port passed by C function out of range, AX == R_NOPORT
;          If NC, then SI = pntr to port_data && BX = port * 2 (rdy for indxg)
;          ZR flag = port has not been initialized
;          If NZ, then DX = base address for port I/O, port value was good,
;           SI = pointer to port data, & BX is ready to indx tables
;-----------------------------------------------------------------------------
localproc       __ck_port_arg
public          __ck_port_arg
        mov     ax,Port         ;get function argument for comport nmbr
        cmp     ax,MAXPORT
        ja      bad_port_exit   ;err if grtr than max supported
        dec     ax
        js      bad_port_exit   ;no good if port nmbr was a 0
        shl     ax,1
        mov     bx,ax           ;get BX ready for lookup operations
        mov     si,wDG __port_dta_tbl[bx] ;pnt SI to struc for this port
        mov     dx,COM_BASE     ;get base address for this com port
        or      dx,dx           ;set NZ if port initialized, also clrs CY
        ret
bad_port_exit:
        xor     ax,ax           ;set ZR flag to indicate port not initialized
        mov     ax,R_NOPORT
        stc                     ;indicate invalid port
        ret                     ;back to caller
__ck_port_arg   endp

;--------------------------------------------------------------------------
;  Translate baud-parity-databit-stopbit string to comm chip language
;
;    Entry: 1) SI = pointer to port data structure
;           2) BX = pointer to baud-parity-data-stopbit string  (BPDS_str)
;
;    Exit : 1) Return code in AX  --  ZR = success, NZ = bad data
;           2) Sets port_dta variables BAUD_DVSR & PDSINFO only, does
;              not change actual BPDS (call set_bpds to perform act chng)
;--------------------------------------------------------------------------
localproc       __convert_bpds
public          __convert_bpds
;---- Baud rate translation
        xor     ax,ax
        mov     dx,ax
        mov     cx,ax           ;AX=DX=CX == 0
cnvrt_baud:
        mov     cl,[bx]         ;get byte from string
        sub     cl,'0'          ;adjust Ascii # to binary
        jb      baud_chk
        cmp     cl,0ah
        jae     baud_chk        ;done cnvrting baud to bin if not numeric dgt
        mul     times_ten       ;mul ongoing result by 10 since reading dec #
        add     ax,cx           ;add in this digit's value
        inc     bx
        jmp s   cnvrt_baud      ;loop till all baud characters are read
baud_chk:
        or      ax,ax
        jz      baud_err        ;error if baud rate is 0
        cmp     ax,19200        ;baud rate must be less than or equal to 19.2K
        jbe     calc_dvsr       ;jmp if valid baud rate,
baud_err:
        mov     ax,R_BAUDERR    ;else return an error
        ret
calc_dvsr:
        mov     cx,ax
        mov     dx,1
        mov     ax,0c200h       ;DX_AX = 115200 == nmbr used to calc baud divsr
        div     cx
        mov     BAUD_DVSR,ax    ;save baud divisor
;---- Parity bit translation
        mov     dl,0            ;clear reg to hold parity,data,stop bit info
        mov     al,[bx]
        inc     bx              ;get parity identifier and incrmnt str ptr
        and     al,0dfh         ;cnvrt to upper case
        cmp     al,'N'
        je      dta_bit_cnvrt   ;no action necessary if using 'NO PARITY'
        cmp     al,'E'
        jne     ck_if_odd
        or      dl,00011000b    ;bits to set even parity
        jmp s   dta_bit_cnvrt
ck_if_odd:
        cmp     al,'O'
        je      mask_odd        ;jmp if odd parity
        mov     ax,R_PARITYERR  ;no good if not even, odd, or none
        ret
mask_odd:
        or      dl,00001000b    ;bits to set odd parity
;---- Number data bits translation
dta_bit_cnvrt:
        mov     al,[bx]
        inc     bx              ;get data bit idntfr & incrmnt strng ptr
        cmp     al,'8'
        jne     ck_if_7
        or      dl,00000011b    ;bits to set up for 8 data bits
        mov     STRIP_MASK,0ffh ;set strip mask so no bit stripping occurs
        jmp s   stp_bit_cnvrt
ck_if_7:
        cmp     al,'7'
        je      mask_7          ;jmp if 7 data bits,
        mov     ax,R_DTABITERR
        ret                     ;else load err code and back to caller
mask_7:
        or      dl,00000010b    ;bits to up for 7 data bits
        mov     STRIP_MASK,7fh  ;set strip mask to remove high bits
;---- Number of stop bits translation
stp_bit_cnvrt:
        mov     al,[bx]
        inc     bx
        cmp     bptr [bx],0
        je      ckif_1stp       ;ok if string properly terminated,
        mov     ax,R_BADARG
        ret                     ;else show BADARG error and exit
ckif_1stp:
        cmp     al,'1'
        je      good_bpds       ;convrt done if using 1 stop bit
        cmp     al,'2'
        je      msk_2stps
stopbiterr:
        mov     ax,R_STPBITERR
        ret                     ;error if not either 1 or 2 stop bits
msk_2stps:
        or      dl,00000100b    ;bits to setup for 2 stop bits
good_bpds:
        mov     PDSINFO,dl      ;save parity, data, stopbit info
        xor     ax,ax           ;set flag showing successful conversion
        ret                     ;back to caller
__convert_bpds  endp

;---------------------------------------------------------------------------
; This procedure is used to perform the actual change of the line settings
; of the communications chip.
;
;  Entry: SI = pointer to com port data structure
;         COM_BASE, BAUD_DVSR, PDSINFO in struc preset to desired values
;
;  Exit : Communications chip baud rate, parity, dta bits, and stp bits set
;         Interrupts disabled
;---------------------------------------------------------------------------
localproc       __set_bpds
public          __set_bpds
        cli
        mov     dx,COM_BASE     ;(xF8) get ptr to slctd I/O port
        add     dx,3            ;(xFB) select line control register (LCR)
        mov     al,80h
        out     dx,al           ;set high bit of LCR tells chip baud is coming
        jmp s   $+2
        mov     ax,BAUD_DVSR
        sub     dx,3            ;(xF8) port for LSB of baud rate divisor
        out     dx,al           ;send LSB of divisor
        jmp s   $+2
        inc     dx              ;(xF9) port for MSB of baud rate divisor
        mov     al,ah
        out     dx,al           ;send MSB of divisor
        jmp s   $+2
        mov     al,PDSINFO      ;get parity, #dtabits, #stpbits info
        inc     dx
        inc     dx              ;(xFB) back to LCR register
        out     dx,al           ;send line infor, also clrs baud dvsr mode
        ret
__set_bpds      endp

endseg          COMM_TEXT
        end

