
title ACCEPT ANY CHAR FOR XON
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarakana TX  75503

;**************************************************************************
; ASYNC_XONANY --  Causes any character received to be treated as an XON.
;    Returns R_BADARG if not using XON/OFF, R_NOPORT if invalid port, else
;    returns R_OK.
;**************************************************************************
begseg          COMM_TEXT
publicproc      _async_xonany
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      any_exit        ;bad arg if ZR flag set
        mov     ax,R_BADARG
        test    STAT2,B_XUSE
        jz      any_exit        ;bad arg in not using XON/OFF protocol
        xor     ax,ax           ;else will return R_OK
        cmp     Flag,OFF
        je      disable_xonany
;enable_xonany:
        or      STAT3,B_XONANY  ;show any char is to be an XON
        jmp s   any_exit
disable_xonany:
        and     STAT3,n B_XONANY ;disable any char treated as XON
any_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_xonany   endp

endseg          COMM_TEXT
        end
