
title FLUSH TRANSMIT BUFFER
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

IMPORT_NEAR     <__shutoff_tx>
ifdef DBUG
IMPORT_NEAR     <dsp_TXIN, dsp_TXOUT>
endif

;***************************************************************************
; ASYNC_TXFLUSH -- Clears the transmit buffer.
;***************************************************************************
begseg          COMM_TEXT
publicproc      _async_txflush
        push    bp
        mov     bp,sp
        push    si              ;C stck frame, save regs
        call    __ck_port_arg   ;ck for valid arg and load pointers
        jz      txfl_exit       ;arg was bad if ZR set on rtrn
        cli
        mov     ax,TX_SIZE
        mov     TX_FREE,ax      ;reset free space variable
        mov     ax,TX_TOP
        mov     TX_IN,ax
        mov     TX_OUT,ax       ;reset tx buffer pointers
ifdef DBUG
        call    dsp_TXIN
        call    dsp_TXOUT
endif
        cmp     TXIMMEDCHAR,0
        jne     txfl_exit       ;jmp if still something to transmit
        and     TX_STAT,n B_TXION  ;else clear bit saying tx'r is on
        call    __shutoff_tx       ;and shut it off
txfl_exit:
        sti
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_txflush  endp

endseg          COMM_TEXT
        end

