
title TRANSMIT BLK SUPPORT FUNCTION
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

;---------------------------------------------------------------------------
; Procedure to move a block of data to the transmit buffer.
;
;  Entry: SI = pointer to com port data structure
;         ES:DI = ptr to start loc in tx_bufr where blk is to be placed
;         BX = offset of block to be moved,  CX = nbr chars to move
;
;  Exit : ES:DI and BX updated to point to next char to move in case there
;         is more to be moved
;---------------------------------------------------------------------------
begseg          COMM_TEXT
localproc       __txblk_fill
public          __txblk_fill
        push    si
        mov     dx,TX_TOP       ; regs after init:
        mov     si,TX_BTM       ;CX=bytes to move,  DX=TX_TOP,  BX=TX_BTM
        xchg    bx,si           ;ES:DI=dest in txbufr,  DS:SI=ptr to block
ifdef FARDATA
        push    ds
        mov     ds,TxImdSeg
endif
        cld
txmov_lp:
        movsb                   ;move a char from block to tx bufr
        cmp     di,bx           ;ck if past end of tx buffer
        je      txbuf_wrap      ; and set ptr to top of txbuf if necessary
        loop    txmov_lp        ;repeat till CX chars moved
        jmp s   exit_blkfill
txbuf_wrap:
        mov     di,dx
        loop    txmov_lp
exit_blkfill:
ifdef FARDATA
        pop     ds
endif
        mov     bx,si           ;BX=ptr to next char in block to move if more
        pop     si              ;restore ptr to comm structure
        ret
__txblk_fill    endp

endseg          COMM_TEXT
        end
