.xlist

;**** ASYNC.H --  Header file for all async functions.  Defines EQU's for
;                 various items & the __port_dta structure.

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

;******************************************************************************
; Data definitions and data storage area.
;******************************************************************************

;---- Lights for RX/TX
ifdef LITES                             ;Define LITES only if using color
ifdef MONO                              ;to get RX/TX indicators on bottom
Vid_RX  equ     70h                     ;area of screen. Define LITES and
Vid_TX  equ     70h                     ;MONO if using monochrome system.
video_seg       segment at 0b000h
video_seg       ends                    ;Use of onscreen indicators requires
else                                    ;bottom 3 or 4 lines of screen to not
Vid_RX  equ     40h                     ;be scrolled.
Vid_TX  equ     50h
video_seg       segment at 0b800h
video_seg       ends
endif
endif

;---- Location of com port base addresses in BIOS data area
bios_dta        segment at 40h
                dw      2 dup(?)        ;base addr of comports accrdng to BIOS
bios_dta        ends

;---- Defininition of argument list for ASYNC functions
Port            equ     wbp [BOFST]

BPDS_ptr        equ     wbp [BOFST+2]
Tx_len          equ     wbp [BOFST+4]
Rx_len          equ     wbp [BOFST+6]

TxChar          equ     bbp [BOFST+2]

Flag            equ     wbp [BOFST+2]

StatMask        equ     wbp [BOFST+2]

TxImdOfst       equ     wbp [BOFST+2]
ifdef FARDATA
TxImdSeg        equ     wbp [BOFST+4]
TxImdCnt        equ     wbp [BOFST+6]
else
TxImdCnt        equ     wbp [BOFST+4]
endif

MSRMntrFlg      equ     bbp [BOFST+2]

StripMask       equ     bbp [BOFST+2]

;---- Return code equates
R_OK              equ      0
R_NOPORT          equ     -1
R_PORTINUSE       equ     -2
R_BAUDERR         equ     -3
R_PARITYERR       equ     -4
R_DTABITERR       equ     -5
R_STPBITERR       equ     -6
R_BADARG          equ     -7
R_NOMEM           equ     -8
R_TXERR           equ     -9

;---- Miscellaneous equates
OFF             equ     0               ;flag value when disabling a function
MAXBUFSIZE      equ     32000           ;max rx/tx buf size
MINTXBUFSIZ     equ     100             ;min tx buf size
MINRXBUFSIZ     equ     750             ;min rx bufr size
MAXPORT         equ     2               ;only supports COM1 or COM2
XOFFCOUNT       equ     400             ;XOFF snt when ths much spc lft in rxbf
XONCOUNT        equ     450             ;min free spc in rx buf befr XON sent
REPTXOFFVAL     equ     160             ;# chars to rx aftr XOFF bfr resnd XOFF
XONCHAR         equ     11h
XOFFCHAR        equ     13h             ;XON/XOFF char values
IMR_8259        equ     21h
ICR_8259        equ     20h             ;addr of int cntrlr ports
FLOW_MASK       equ     10110010b       ;used to ck for flow halts
B_CD            equ     10000000b       ;carrier detect bit
B_CTS           equ     00010000b       ;clear to send bit
B_RTS           equ     00000010b       ;request to send bit
B_DSR           equ     00100000b       ;data set ready bit
B_DTR           equ     00000001b       ;data terminal ready bit
B_TXEMPTY       equ     00001000b       ;nothing to transmit bit
B_TXION         equ     00000001b       ;transmitter running bit
B_XUSE          equ     00000001b       ;using XON/XOFF protocol bit
B_XSENT         equ     00000100b       ;XOFF sent bit
B_XRXD          equ     00000010b       ;XOFF received bit
B_RXEMPTY       equ     01000000b       ;rx buffer empty bit
B_RXOVF         equ     00000001b       ;rx buffer overflow indic bit
B_FLOWHALT      equ     01000000b       ;flow halt indicator bit
B_XONANY        equ     00000001b       ;any char can be XON bit

;---- Definition of port data (SI must hold pointer to 'port_dta')
COM_BASE        equ     wsi[0]   ;1)base port address of for comm port
TX_TOP          equ     wsi[2]   ;2)ptr to beginning of tx buffer
TX_BTM          equ     wsi[4]   ;3)ptr to end of tx buffer (end + 1)
RX_TOP          equ     wsi[4]   ;3)ptr to begin of rx bufr
RX_BTM          equ     wsi[6]   ;4)ptr to end of rx bufr (end + 1)
TX_IN           equ     wsi[8]   ;5)ptr to where next 'put' goes
TX_OUT          equ     wsi[10]  ;6)ptr to where next tx'd comes from
TX_FREE         equ     wsi[12]  ;7)remaining tx bufr space
TX_SIZE         equ     wsi[14]  ;8)total size of tx bufr
RX_IN           equ     wsi[16]  ;9)ptr to where next rx'd goes
RX_OUT          equ     wsi[18]  ;10)ptr to where next 'get' comes from
RX_FREE         equ     wsi[20]  ;11)remaining bytes in rx bufr space
RX_SIZE         equ     wsi[22]  ;12)total size of rx bufr
RXTX_SEG        equ     wsi[24]  ;13)segment of rx/tx bufrs if FAR ptrs
BAUD_DVSR       equ     wsi[26]  ;14)baud rate divisor
OLDVCTR_SEG     equ     wsi[28]  ;15)segment addr of old int vector
OLDVCTR_OFST    equ     wsi[30]  ;16)offset addr of old int vector
NEWVCTR_SEG     equ     wsi[32]  ;17)segment of new int vector
NEWVCTR_OFST    equ     wsi[34]  ;18)offset addr of new int vector
VECTOR_NBR      equ     bsi[36]  ;19)vctr nmbr assoc with slctd com port
MSK_8259        equ     bsi[37]  ;20)Mask to enable 8259 interrupt
STATWRD1        equ     wsi[38]  ;21)stat bytes 1 and 2 (bit maps below)
STAT2           equ     bsi[38]  ;21a)secondary status byte
STAT1           equ     bsi[39]  ;21b)primary status byte
STATWRD2        equ     wsi[40]  ;22)tx_stat & msr flow control mask bytes
TX_STAT         equ     bsi[40]  ;22a)determines when tx_intrpts need turned on
MSR_MASK        equ     bsi[41]  ;22b)slcts bits in MSR montrd for flow cntrl
PDSINFO         equ     bsi[42]  ;23)parity, # dta bits, # stop bits
XTXRPT          equ     bsi[43]  ;24)countdown val befr repeat tx of XOFF
TXIMMEDCHAR     equ     bsi[44]  ;25)char to be tx'd 1st opportunity
OLD_8259_MSK    equ     bsi[45]  ;26)original 8259 interrupt mask
OLD_LCR         equ     bsi[46]  ;27)original Line Control Reg value
OLD_MCR         equ     bsi[47]  ;28)original Modem Cntrl Reg value
OLD_IER         equ     bsi[48]  ;29)original Interrupt Enable Reg value
STRIP_MASK      equ     bsi[49]  ;30)mask for high bit stripping
MSR_VAL         equ     bsi[50]  ;31)present value of modem status register
STAT3           equ     bsi[51]  ;32)another flag -- mapped below

;---- Bit maps of status bytes:
;-- Values returned by async_stat (1 & 2) and async_rx high byte (1 only)
;   STAT1: 0=rx bufr ovrfl   1=char overrun     2=parity err    3=framing err
;          4=break intrpt    5=invalid port     6=rx bufr empty 7=no carrier
;   STAT2: 0=XON/OFF in use  1=XOFF received    2=XOFF sent     3=tx buf empty
;          4=montr'g CTS     5=montr'g DSR      6=flw hlt actv  7=montr'g CD
;-- Flow bits in tx stat not being monitored are set to 0.  Whenever this byte
;   equals 0 a call is made to turn the transmitter on.
; TX_STAT: 0=tx intrpts on   1=XOFF rx'd        2=not used (0)  3=nothing to tx
;          4=not CTS         5=not DSR          6=not used (0)  7=not CD
;-- MSR_MASK bits set low to indic that signal is being monitored else are 1
;MSR_MASK: 0= 1              1= 1               2= 1            3= 1
;          4=CTS flow ckg    5=DSR flow ckg     6= 1            7= CD flow ckg
;-- Catch-all flag for anything left
;   STAT3: 0=any char XON    1=not used         2=not used      3=not used
;          4=not used        5=not used         6=not used      7=not used


     ;Variables in structure separated to allow initialization for each port
     ;Above equates show layout of data within the structure
port_dta        struc
                dw      16 dup(0)
                dw      0               ;new vector segment location in struc
                dw      0               ;new vector offset location
                db      0               ;loc of vector number in struc
                db      0               ;Mask for IRQ number (8259)
                db      14 dup(0)
port_dta        ends
.list
