
; A simple program that loads a file, dumps it to screen, and lets you move
; around in it using the arrow keys. ESC quits. It loads the file into
; extended memory, if for no other reason that to demonstrate its use.
; This program makes use of a switch with a numeric string associated.
;
; Link this with FILE32, KB32, and ARGC32, and enable OPENFILE, READFILE,
; FILESIZE, CCHEKSTR, and CCHEKSWITCH in their respective libs.

        .386p
        jumps
code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include start32.inc
include file32.inc
include argc32.inc
include kb32.inc

public  _main

;
; DATA
;
errmsg0         db      'SYNTAX: EXAMPLE4 [-a#] <filename>',0dh,0ah,0dh,0ah
                db      '  The -a switch changes the screen attributes for '
                db      'displaying the file.',0dh,0ah,'$'
errmsg1         db      'Error opening input file!!!$'
errmsg2         db      'Not enough extended memory to load file!!!$'

fnm             db      64 dup(?)

keytbl          db      7,  23,24,25,26, 19,20, 14
functbl         dd      func0,func1,func2,func3,func4,func5,_exit

dataptr         dd      ?               ; ptr to beginning of data
datalen         dd      ?               ; length of file
dataloc         dd      0               ; location in data to display
dispattr        db      7               ; display attribute

;
; CODE
;

include strltu.rt
include strhtn.rt
include indxbyte.rt

;-----------------------------------------------------------------------------
exiterr2:
        mov edx,offset errmsg2
        jmp short exiterr
;-----------------------------------------------------------------------------
exiterr1:
        mov edx,offset errmsg1
        jmp short exiterr
;-----------------------------------------------------------------------------
exiterr0:
        mov edx,offset errmsg0
exiterr:
        call _putdosmsg
        jmp _exit

;
_main:
        mov al,'a'                      ; chek for attribute switch
        call _cchekswitch
        jc short mf0

        mov edx,_lomembase              ; misc data ptr
        call _ccheksstr
        call _strltu                    ; convert string to number
        call _strhtn
        mov dispattr,al

mf0:
        xor al,al                       ; chek for filename on commandline
        mov edx,offset fnm
        call _cchekstr
        jc exiterr0

        call _openfile                  ; attempt to open file
        jc exiterr1

        mov eax,4000h                   ; setup file buffer
        call _getlomem
        mov _filebufloc,eax

        call _filesize                  ; get size and make it a min of 80*25
        push eax                        ; store for later use
        cmp eax,80*25
        jae short mf1
        mov eax,80*25
mf1:
        mov datalen,eax

        call _gethimem                  ; chek for, and get enough himem
        jc exiterr2
        mov dataptr,eax
        mov edi,eax                     ; fill 80*25 bytes with blanks
        mov ecx,(80*25)/4
        mov eax,20202020h
        rep stosd

        mov edx,dataptr                 ; load file into himem
        pop ecx                         ; restore actual filesize for load
        call _readfile
        call _closefile

        call _init_kb                   ; initialize keyboard

;
mainloop:
        mov esi,dataptr                 ; put this page of data
        add esi,dataloc
        call disppage

mlf0:
        call _getch                     ; get key

        mov edx,offset keytbl           ; index key in table
        call _indexbyte
        jc mlf0

        call functbl[eax*4]             ; call function for key
        jmp mainloop

;
func0:                                  ; left arrow key
        sub dataloc,1
        adc dataloc,0
        ret
;
func1:                                  ; right arrow key
        mov eax,dataloc
        inc eax
        lea ebx,[eax+80*25]
        cmp ebx,datalen
        ja _ret
        mov dataloc,eax
        ret
;
func2:                                  ; up arrow key
        mov eax,dataloc
        sub eax,80
        jc _ret
        mov dataloc,eax
        ret
;
func3:                                  ; down arrow key
        mov eax,dataloc
        add eax,80
        lea ebx,[eax+80*25]
        cmp ebx,datalen
        ja _ret
        mov dataloc,eax
        ret
;
func4:                                  ; home key
        mov dataloc,0
        ret
;
func5:                                  ; end key
        mov eax,datalen
        sub eax,80*25
        mov dataloc,eax
        ret

;
; Display one screen of the file
; In:
;   ESI -> memory area to display from
; Out:
;   None
;
disppage:
        push ax ecx esi edi

        @rlp edi,0b8000h
        mov ecx,80*25
        mov al,dispattr
disppageml:
        movsb
        stosb
        loop disppageml

        pop edi esi ecx ax
        ret


code32  ends
        end

