; NOBOOT is a TSR that stops the <Ctrl><Alt><Del> keyboard reset.
; There ares no unloading provisions.
; This TSR should be loaded before others.

; ASM source from Debug script in PC Mag. and Sourcer
;-- Program begins: ---------------------------------------------------------
;
; Equates:
;
kb_data         equ     60h             ;keyboard data port
kb_ctrl         equ     61h             ;keyboard control port
del_key         equ     53h             ;scan code for 'DEL' key
alt_key         EQU     8               ;shift code for Alt key
ctrl_key        EQU     4               ;shift code for Ctrl key
status_byte     equ     417h            ;shift status byte
  
seg_a		segment	byte public
		assume	cs:seg_a, ds:seg_a
  
  
		org	100h
  
noboot		proc	far
  
start:
                jmp     short   initialize

old_vec         label   dword
old_vec1        dw      0       ; put old 9h vector here
old_vec2        dw      0

noboot          endp
  
;==========================================================================
;
;               Int 9H
;
;==========================================================================
  
int_9h          proc    far
		sti				; Enable interrupts
		push	ax
		push	ds
                in      al,kb_data              ; read keyboard
                cmp     al,del_key              ; was Del key ?
                jnz     old_int9h               ; no, continue old 9h
                mov     ax,0                    ;setup for shift keys
		mov	ds,ax
                mov     al,ds:[status_byte]     ; get shift status
                test    al,alt_key              ; Alt key  down ?
                jz      old_int9h               ; no, continue old 9h
                test    al,ctrl_key             ; Ctrl key down ?
                jz      old_int9h               ; no, continue old 9h
                in      al,kb_ctrl              ; ackknowledge keystroke
                mov     ah,al                   ;  so key won't be around
                or      al,80h                  ;  later
                out     kb_ctrl,al
		mov	al,ah
                out     kb_ctrl,al

                mov     al,20h                  ; end
                out     20h,al                  ;  of interrupt

                pop     ds                      ;restore regs
		pop	ax
		iret				; Interrupt return
  
old_int9h:
		pop	ds
		pop	ax
                jmp     cs:old_vec              ; do normal 9h int

int_9h          endp

initialize:
		mov	ax,3509h
                int     21h                     ; get orignal 9h int vector
                mov     old_vec1,bx             ; save old vec for later
                mov     old_vec2,es
                mov     dx,offset int_9h
		mov	ax,2509h
                int     21h                     ; set new 9h vec to this code
                mov     dx,offset initialize
		int	27h			; Terminate & stay resident
copyright	db	'(c) 1988 Ziff Communications Co.'
		db	0
  
seg_a		ends
  
  
  
		end	start
