.286C
.SALL
.XLIST

;This file provides macros to simulate PM286 instructions not
;supported by MASM V2.0.  Some macros do simple operand checking, but
;it is possible to generate illegal instructions if you aren't
;careful.  The opcodes simulated are:
;       ARPL   CLTS   LAR
;       LGDT   LIDT   LLDT
;       LMSW   LSL    LTR
;       SGDT   SIDT   SLDT
;       SMSW   STR    VERR
;       VERW
;
arpl    MACRO     ew, rw      ;; ADJUST RPL
        LOCAL     start, end
        start = $
        IFDEF     ew          ;; is ew defined symbol?
        add       WORD PTR ew, rw
        ELSE                  ;; assume ew is register
        add       ew, rw
        ENDIF
        end = $
        ORG       start
        DB        63h
        ORG       end
        ENDM

clts    MACRO                 ;; CLEAR TS BIT
        DB        0Fh, 06h
        ENDM

lar     MACRO     rw, ew      ;; LOAD ACCESS RIGHTS
        LOCAL     start, end
        DB        0Fh
        start = $
        add       rw, ew
        end = $
        ORG       start
        DB        02h
        ORG       end
        ENDM

lgdt    MACRO     mem         ;; LOAD GDT REGISTER
        DB        0Fh
        add       WORD PTR mem, dx
        ENDM

lidt    MACRO     mem         ;; LOAD IDT REGISTER
        DB        0Fh
        add       WORD PTR mem, bx
        ENDM

lldt    MACRO     ew          ;; LOAD LDT REGISTER
        LOCAL     start, end
        DB        0Fh
        start = $
        rcl       ew, 1
        end = $
        ORG       start
        DB        0
        ORG       end
        ENDM

lmsw    MACRO     ew          ;; LOAD MACHINE STATUS WORD
        LOCAL     start, end
        DB        0Fh
        start = $
        div       ew
        end = $
        ORG       start
        DB        1
        ORG       end
        ENDM

lsl     MACRO     rw, ew      ;; LOAD SEGMENT LIMIT
        LOCAL     start, end
        DB        0Fh
        start = $
        add       rw, ew
        end = $
        ORG       start
        DB        03h
        ORG       end
        ENDM

ltr     MACRO     ew          ;; LOAD TASK REGISTER
        LOCAL     start, end
        DB        0Fh
        start = $
        rcr       ew, 1
        end = $
        ORG       start
        DB        0
        ORG       end
        ENDM

sgdt    MACRO     mem         ;; STORE GDT REGISTER
        DB        0Fh
        add       WORD PTR mem, ax
        ENDM

sidt    MACRO     mem         ;; STORE IDT REGISTER
        DB        0Fh
        add       WORD PTR mem, cx
        ENDM

sldt    MACRO     ew          ;; STORE LDT REGISTER
        LOCAL     start, end
        DB        0Fh
        start = $
        rol       ew, 1
        end = $
        ORG       start
        DB        0
        ORG       end
        ENDM

smsw    MACRO     ew          ;; STORE MACHINE STATUS WORD
        LOCAL     start, end
        DB        0Fh
        start = $
        shl       ew, 1
        end = $
        ORG       start
        DB        1
        ORG       end
        ENDM

str     MACRO     ew          ;; STORE TASK REGISTER
        LOCAL     start, end
        DB        0Fh
        start = $
        ror       ew, 1
        end = $
        ORG       start
        DB        0
        ORG       end
        ENDM

verr    MACRO     ew          ;; VERIFY READ ACCESS
        LOCAL     start, end
        DB        0Fh
        start = $
        shl       ew, 1
        end = $
        ORG       start
        DB        0
        ORG       end
        ENDM

verw    MACRO     ew          ;; VERIFY WRITE ACCESS
        LOCAL     start, end
        DB        0Fh
        start = $
        shr       ew, 1
        end = $
        ORG       start
        DB        0
        ORG       end
        ENDM

;
;This macro must be used in place of the standard segment override
;in conjuction with the above macros.  The standard segment override
;will be attached to the wrong portion of the instruction, e.g., after
;the 0Fh in an LGDT instruction.
;
;DO NOT USE:
;       LGDT      ES:[my_gdt]
;
;CODE THIS INSTEAD:
;       SEGOV     ES
;       LGDT      [my_gdt]
;
segov   MACRO     s           ;; seg override for 286 macros
        IFIDN     <s>,<ES>
        DB        26h
        ENDIF
        IFIDN     <s>,<CS>
        DB        2Eh
        ENDIF
        IFIDN     <s>,<SS>
        DB        36h
        ENDIF
        IFIDN     <s>,<DS>
        DB        3Eh
        ENDIF
        ENDM

        .LIST










