;PUT_DEC.ASM       10-10-83 
;
;ROUTINE TO PUT A DECIMAL POINT 'X' CHARACTERS FROM RIGHT END
;OF A ASCII STRING
;
;CALLED WITH                                                   
;            BX = OFFSET OF ASCII STRING
;            CX = NUMBER OF CHARACTERS IN STRING           
;            DX = NUMBER OF CHARACTERS TO RIGHT OF DECIMAL
;RETURN WITH DECIMAL IN STRING AND NUMBER AT RIGHT SIDE OF STRING
;--------------------------------------------
DATA SEGMENT PARA 'DATA'
TEMP_STRING  DB  10 DUP (?)    ;PLACE TO PUT ASCII STRING 
                               ;WHILL WORKING WITH IT
TEMP_NUM     DW  ?
PUT_DEC_SIGN DB  ?             ;PLACE TO PUT SIGN
DATA ENDS
;--------------------------------------------
CODE SEGMENT PARA 'CODE'
      PUBLIC PUT_DEC 
      ASSUME CS:CODE,DS:DATA,ES:DATA
PUT_DEC PROC FAR

;MOVE ASCII STRING TO TEMPORARY LOCATION AND PUT
;DECIMAL INTO PROPER LOCATION AS STRING IS MOVED
;BACK


       PUSH DX        ;NUMBERS OF CHARACTERS TO RIGHT OF DEC
       PUSH BX        ;OFFSET OF START OF STRING
       PUSH CX        ;NUMBER OF CHARACTERS IN STRING

       CMP  DX,0         ;IF NO CHARACTERS TO RIGHT OF DECIMAL THEN
       JZ  PUT_DEC_EXIT1 ;   DON'T NEED A DECIMAL POINT

;CLEAR TEMP STRING AREA
       LEA  AX,TEMP_STRING
       MOV  SI,AX
       MOV  CX,10            ;SIZE OF TEMP_STRING
LOOP_CLEAR:
       MOV  BYTE PTR [SI],' '  ;GOING TO PUT BLANKS IN STRING
       INC  SI                 
       LOOP LOOP_CLEAR

       POP  CX       ;NUMBER OF CHARACTERS IN ORIGINAL STRING
       POP  BX       ;POINTS TO START OF ORIGINAL STRING
       PUSH CX       ;SAVE FOR LATER USE

       XOR  DX,DX
       LEA  AX,TEMP_STRING
       MOV  SI,AX     ;PUT ADDRESS OF TEMP STRING IN DESTINATION INDEX
      
       MOV  AL,BYTE PTR [BX]
       CMP  AL,'-'
       JNE  TEST_FOR_PLUS
       MOV  PUT_DEC_SIGN,AL    ;FIRST CHAR WAS A '-'
       INC  BX
       DEC  CX
       JMP  MOVE_CHAR

TEST_FOR_PLUS:
       CMP  AL,'+'
       JNE  MOVE_CHAR           ;FIRST CHAR WAS NOT - OR +
       MOV  PUT_DEC_SIGN,AL
       INC  BX
       DEC  CX

;NOTE HAVE NOT MOVED THE SIGN TO THE TEMPARY STRING

MOVE_CHAR:
       MOV  AL,BYTE PTR [BX]   ;PUT STRING CHAR IN AX
       MOV  BYTE PTR [SI],AL   ;  AND THEN INTO TEMP STRING
       INC  BX
       INC  SI
       LOOP MOVE_CHAR

       POP  CX        ;NUMBER OF CHARACTERS IN STRING
       DEC  BX        ;BX POINTS TO POSITION OF LAST CHARACTER IN STRING
       DEC  SI        ;SI POINTS TO END OF STRING IN TEMP STRING SPACE
       POP  DX

MOVE_CHAR_BACK:
       CMP  DX,0      ;PUT DECIMAL IN STRING WHEN DX CHARS HAVE BEEN PUT
       JE PUT_IN_DEC
       MOV  AL,BYTE PTR [SI]   ;PUT CHAR FROM TEMP STRING IN AX
       MOV  BYTE PTR [BX],AL   ;  AND THEN BACK TO ORIGINAL STRING
       DEC  BX
       DEC  SI
       DEC  DX
       LOOP MOVE_CHAR_BACK

       CMP  DX,0                ;IF DX IS NEG THEN DEC IN PLACE
       JL   PUT_DEC_EXIT

PUT_LEADING_ZEROS:
       CMP  DX,0
       JZ PUT_IN_DEC_1
       MOV  BYTE PTR [BX],'0'   ;ZERO
       DEC  BX
       DEC  DX
       JMP PUT_LEADING_ZEROS

PUT_IN_DEC_1:
       MOV  BYTE PTR [BX],'.'    ;DECIMAL
       DEC  BX
       MOV  BYTE PTR [BX],'0'    ;ZERO BEFORE THE DECIMAL
       DEC  BX
       MOV  AL,PUT_DEC_SIGN
       MOV  [BX],AL              ;PUT SIGB ON STRING
       JMP  PUT_DEC_EXIT

PUT_IN_DEC:           ;PUT THE DECIMAL POINT IN THE STRING
       MOV  BYTE PTR [BX],'.'  
       DEC  BX
       DEC  DX                ;SO DX NOT ZERO
       JMP MOVE_CHAR_BACK

PUT_DEC_EXIT1:
        POP  CX       ;FIX STACK FOR EXIT
        POP  BX
        POP  DX

PUT_DEC_EXIT:
       RET            ;RETURN TO CALLER

PUT_DEC  ENDP
CODE     ENDS
         END
