;--------------------------------------
; PROGRAM CLS
;
; Provides an external DOS command to clear
; the CRT screen.  Example source file for CHASM.
;
; Uses BIOS routine VIDEO_IO to scroll up
; the screen and position the cursor.  For
; documentation of VIDEO_IO see page A-43
; of Technical Reference.
;---------------------------------------
    MOV AH,6     ;this specifys we want a scroll
                 ;CH/CL specifies row & column
                 ;scroll region's upper left corner
    MOV CH,0     ;row = 0
    MOV CL,0     ;column = 0
                 ;DH/DL does the same for lower
                 ;right corner.
    MOV DH,24    ;row = 24
    MOV DL,79    ;column = 79
                 ;BH specifies color to fill with
    MOV BH,7     ;we'll use black
                 ;AL specifies how far to scroll
    MOV AL,0     ;0 means blank out entire region
    INT 16       ;call video_io

    MOV AH,2     ;position cursor function
                 ;DH/DL specifies row and column
    MOV DH,0     ;row = 0
    MOV DL,0     ;column = 0
                 ;BH specifies which display page
    MOV BH,0     ;page 0
    INT 16       ;call video_io

    INT 32       ;return to DOS
