
	 TITLE	 'SPEED - Adjust Diskette Parameters'

; Adapted from SPEED411 and from "Inside the IBM PC",
; by Peter Norton, pages 138-139.
;
; At location x'78' is a pointer to the diskette
; parameter table. This program changes the first
; value, the Step Rate Time, which results in a
; quieter and somewhat faster running drive.
;
; The third byte of the table specifies the motor
; turn off delay time. It is changed from 37 msec
; to 200 msec, which results in fewer start-up
; operations.
;
; To install:
;     MASM SPEED;
;     LINK SPEED;
;     EXE2BIN SPEED.EXE SPEED.COM
;     DEL SPEED.EXE
;     SPEED
; The program can be run again without harm.
;
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME  CS:CSEG,DS:CSEG,ES:CSEG
	 ORG	 100H
SPEED	 PROC	 FAR
	 PUSH	 DS			 ;save for linkage
	 XOR	 AX,AX			 ;clear for return
	 PUSH	 AX			 ;put in stack
;
	 PUSH	 DS			 ;Modify diskette parameters
	 MOV	 DS,AX			 ;Offset into disk table
	 LDS	 DI,DWORD PTR DS:78H	 ;Addr of disk table
	 MOV	 BYTE PTR [DI],239	 ;Modify step rate
	 MOV	 BYTE PTR [DI+2],200	 ;And motor stop delay
	 INT	 13H			 ;Reset diskette system
	 POP	 DS
;
	 INT	 20H
;
SPEED	 ENDP
CSEG	 ENDS
	 END	 SPEED
