; from gaithersburg md ibm pc bulletin board 19mar83
;
;
		SUBTTL ROM BIOS DATA AREAS AND EQUATES
;--------------------------------
;   EQUATES
;--------------------------------
PORT_A		EQU	60H		 ; 8255 PORT A ADDR
PORT_B		EQU	61H		 ; 8255 PORT B ADDR
PORT_C		EQU	62H		 ; 8255 PORT C ADDR
CMD_PORT	EQU	63H
INTA00		EQU	20H		 ; 8259 PORT
INTA01		EQU	21H		 ; 8259 PORT
EOI		EQU	20H
TIMER		EQU	40H
TIM_CTL 	EQU	43H		 ; 8253 TIMER CONTROL PORT ADDR
TIMER0		EQU	40H		 ; 8253 TIMER/CNTER 0 PORT ADDR
TMINT		EQU	01		 ; TIMER 0 INTR RECVD MASK
DMA08		EQU	08		 ; DMA STATUS REG PORT ADDR
DMA		EQU	00		 ; DMA CHANNEL 0 ADDRESS REG PORT ADDR
MAX_PERIOD	EQU	540H
MIN_PERIOD	EQU	410H
KBD_IN		EQU	60H		 ; KEYBOARD DATA IN ADDR PORT
KBDINT		EQU	02		 ; KEYBOARD INTR MASK
KB_DATA 	EQU	60H		 ; KEYBOARD SCAN CODE PORT
KB_CTL		EQU	61H		 ; CONTROL BITS FOR KEYBOARD SENSE DATA
;--------------------------------
;  8088 INTERRUPT LOCATIONS
;--------------------------------
ABS0		SEGMENT AT 0
STG_LOC0	LABEL	BYTE
		ORG	2*4
NMI_PTR 	LABEL	WORD
		ORG	5*4
INTS_PTR	LABEL	WORD
		ORG	8*4
INT_ADDR	LABEL	WORD
INT_PTR 	LABEL	DWORD
		ORG	10H*4
VIDEO_INT	LABEL	WORD
		ORG	1DH*4
PARM_PTR	LABEL	DWORD		 ; POINTER TO VIDEO PARMS
		ORG	01EH*4		 ; INTERRUPT 1EH
DISK_PTR	LABEL	DWORD
		ORG	01FH*4		 ; LOCATION OF POINTER
EXT_PTR 	LABEL	DWORD		 ; POINTER TO EXTENSION
		ORG	7C00H
BOOT_LOCN	LABEL	FAR
ABS0		ENDS
		PAGE
;--------------------------------
;  STACK -- USED DURING INITIALIZATION ONLY
;--------------------------------
STACK		SEGMENT AT 30H
		DW	128 DUP(?)
TOS		LABEL	WORD
STACK		ENDS
;--------------------------------
;  ROM BIOS DATA AREAS
;--------------------------------
DATA		SEGMENT AT 40H
RS232_BASE	DW	4 DUP(?)	 ; ADDRESSES OF RS232 ADAPTERS
PRINTER_BASE	DW	4 DUP(?)	 ; ADDRESSES OF PRINTERS
EQUIP_FLAG	DW	?		 ; INSTALLED HARDWARE
MFG_TST 	DB	?		 ; INITIALIZATION FLAG
MEMORY_SIZE	DW	?		 ; MEMORY SIZE IN K BYTES
IO_RAM_SIZE	DW	?		 ; MEMORY IN I/O CHANNEL
		PAGE
;-------------------------------
;  KEYBOARD DATA AREAS
;-------------------------------
KB_FLAG 	DB	?
;------ SHIFT FLAG EQUATES WITHIN KB_FLAG
INS_STATE	EQU	80H		 ; INSERT STATE IS ACTIVE
CAPS_STATE	EQU	40H		 ; CAPS LOCK STATE HAS BEEN TOGGLED
NUM_STATE	EQU	20H		 ; NUM LOCK STATE HAS BEEN TOGGLED
SCROLL_STATE	EQU	10H		 ; SCROLL LOCK STATE HAS BEEN TOGGLED
ALT_STATE	EQU	08H		 ; ALTERNATE SHIFT KEY DEPRESSED
CTL_SHIFT	EQU	04H		 ; CONTROL SHIFT KEY DEPRESSED
LEFT_SHIFT	EQU	02H		 ; LEFT SHIFT KEY DEPRESSED
RIGHT_SHIFT	EQU	01H		 ; RIGHT SHIFT KEY DEPRESSED
;-------------------------------
KB_FLAG_1	DB	?		 ; SECOND BYTE OF KEYBOARD STATUS
INS_SHIFT	EQU	80H		 ; INSERT KEY IS DEPRESSED
CAPS_SHIFT	EQU	40H		 ; CAPS LOCK KEY IS DEPRESSED
NUM_SHIFT	EQU	20H		 ; NUM LOCK KEY IS DEPRESSED
SCROLL_SHIFT	EQU	10H		 ; SCROLL LOCK KEY IS DEPRESSED
HOLD_STATE	EQU	08H		 ; SUSPEND KEY HAS BEEN TOGGLED
;-------------------------------
ALT_INPUT	DB	?		 ; STORAGE FOR ALTERNATE KEYPAD ENTRY
BUFFER_HEAD	DW	?		 ; POINTER TO HEAD OF KEYBOARD BUFFER
BUFFER_TAIL	DW	?		 ; POINTER TO TAIL OF KEYBOARD BUFFER
KB_BUFFER	DW	16 DUP(?)	 ; ROOM FOR 15 ENTRIES
KB_BUFFER_END	LABEL	WORD
;------ HEAD = TAIL INDICATES THAT THE BUFFER IS EMPTY
NUM_KEY 	EQU	69		 ; SCAN CODE FOR NUMBER LOCK
SCROLL_KEY	EQU	70		 ; SCROLL LOCK KEY
ALT_KEY 	EQU	56		 ; ALTERNATE SHIFT KEY SCAN CODE
CTL_KEY 	EQU	29		 ; SCAN CODE FOR CONTROL KEY
CAPS_KEY	EQU	58		 ; SCAN CODE FOR SHIFT LOCK
LEFT_KEY	EQU	42		 ; SCAN CODE FOR LEFT SHIFT
RIGHT_KEY	EQU	54		 ; SCAN CODE FOR RIGHT SHIFT
INS_KEY 	EQU	82		 ; SCAN CODE FOR INSERT KEY
DEL_KEY 	EQU	83		 ; SCAN CODE FOR DELETE KEY
		PAGE
;-------------------------------
;   DISKETTE DATA AREAS
;-------------------------------
SEEK_STATUS	DB	?		 ; DRIVE RECALIBRATION STATUS
;					 BIT 3-0 = DRIVE 3-0 NEEDS RECAL BEFORE
;					 NEXT SEEK IF BIT IS = 0
INT_FLAG	EQU	080H		 ; INTERRUPT OCCURRENCE FLAG
MOTOR_STATUS	DB	?		 ; MOTOR STATUS
;			 BIT 3-0 = DRIVE 3-0 IS CURRENTLY RUNNING
;			 BIT 7	 = CURRENT OPERATION IS A WRITE, REQUIRES DELAY
MOTOR_COUNT	DB	?		 ; TIME OUT COUNTER FOR DRIVE TURN OFF
MOTOR_WAIT	EQU	37	   ; TWO SECONDS OF COUNTS FOR MOTOR TURN OFF
;
DISKETTE_STATUS DB	?	   ; SINGLE BYTE OF RETURN CODE INFO FOR STATUS
TIME_OUT	EQU	80H	   ; ATTACHMENT FAILED TO RESPOND
BAD_SEEK	EQU	40H	   ; SEEK OPERATION FAILED
BAD_NEC 	EQU	20H	   ; NEC CONTROLLER HAS FAILED
BAD_CRC 	EQU	10H	   ; BAD CRC ON DISKETTE READ
DMA_BOUNDARY	EQU	09H	   ; ATTEMPT TO DMA ACROSS 64K BOUNDARY
BAD_DMA 	EQU	08H	   ; DMA OVERRUN ON OPERATION
RECORD_NOT_FND	EQU	04H	   ; REQUESTED SECTOR NOT FOUND
WRITE_PROTECT	EQU	03H	   ; WRITE ATTEMPTED ON WRITE PROT DISK
BAD_ADDR_MARK	EQU	02H	   ; ADDRESS MARK NOT FOUND
BAD_CMD 	EQU	01H	   ; BAD COMMAND PASSED TO DISKETTE I/O
;
NEC_STATUS	DB	7 DUP(?)   ; STATUS BYTES FROM NEC
;--------------------------------
;   VIDEO DISPLAY DATA AREA
;--------------------------------
CRT_MODE	DB	?	   ; CURRENT CRT MODE
CRT_COLS	DW	?	   ; NUMBER OF COLUMNS ON SCREEN
CRT_LEN 	DW	?	   ; LENGTH OF REGEN IN BYTES
CRT_START	DW	?	   ; STARTING ADDRESS IN REGEN BUFFER
CURSOR_POSN	DW	8 DUP(?)   ; CURSOR FOR EACH OF UP TO 8 PAGES
CURSOR_MODE	DW	?	   ; CURRENT CURSOR MODE SETTING
ACTIVE_PAGE	DB	?	   ; CURRENT PAGE BEING DISPLAYED
ADDR_6845	DW	?	   ; BASE ADDRESS FOR ACTIVE DISPLAY CARD
CRT_MODE_SET	DB	?	   ; CURRENT SETTING OF THE 3X8 REGISTER
CRT_PALLETTE	DB	?	   ; CURRENT PALLETTE SETTING COLOR CARD
		PAGE
;--------------------------------
;   CASSETTE DATA AREA
;--------------------------------
EDGE_CNT	DW	?	   ; TIME COUNT AT DATA EDGE
CRC_REG 	DW	?	   ; CRC REGISTER
LAST_VAL	DB	?	   ; LAST INPUT VALUE
;--------------------------------
;   TIMER DATA AREA
;--------------------------------
TIMER_LOW	DW	?	   ; LOW WORD OF TIMER COUNT
TIMER_HIGH	DW	?	   ; HIGH WORD OF TIMER COUNT
TIMER_OFL	DB	?	   ; TIMER HAS ROLLED OVER SINCE LAST READ
;COUNTS_SEC	EQU	18
;COUNTS_MIN	EQU	1092
;COUNTS_HOUR	EQU	65543
;COUNTS_DAY	EQU	1573040 = 1800B0H
;-------------------------------
;   SYSTEM DATA AREA
;-------------------------------
BIOS_BREAK	DB	?	   ; BIT 7 = 1 IF BREAK KEY HAS BEEN DEPRESSED
RESET_FLAG	DW	?	   ; WORD = 1234H IF KEYBOARD RESET UNDERWAY
DATA		ENDS
;
;--------------------------------
;   EXTRA DATA AREA
;--------------------------------
XXDATA		SEGMENT AT 50H
STATUS_BYTE	DB	?
XXDATA		ENDS
;
;--------------------------------
;   VIDEO DISPLAY BUFFER
;--------------------------------
VIDEO_RAM	SEGMENT AT 0B800H
REGEN		LABEL	BYTE
REGENW		LABEL	WORD
		DB	16384 DUP(?)
VIDEO_RAM	ENDS
;
;--------------------------------
;   ROM RESIDENT CODE
;--------------------------------
ROMCODE 	SEGMENT AT 0F000H
		DB	57344 DUP(?)		 ; FILL LOWEST 56K
		DB	'5700051 CORP. IBM 1981' ; COPYRIGHT NOTICE
ROMCODE 	ENDS
;
;--------------------------------
;   PROGRAM SEGMENT PREFIX
;--------------------------------
;
PROGRAM 	SEGMENT
INT20		DW			;INT 20 for DOS return
MEMORYSIZE	DW			;TOTAL MEMORY SIZE
CALLDOS_FAR	DB	5 DUP(?)	; LONG CALL DOS DISPATCHER
TERMADDR	DB	4 DUP(?)	; TERMINATE ADDRESS (ip,cs)
CTRLBREAK	DB	4 DUP(?)	; ctrl_break EXIT ADDRESS
RESERVED	DB	4ah DUP(?)	; RESERVED AREA
FCB_ONE 	DB	10H DUP(?)	; unopened fcb #1
FCB_TWO 	DB	10H DUP(?)	; unopened fcb #2
PARM_LENGTH	DB			; LENGTH OF PARAMETERS
PARM_FIELD	DB	19 DUP(?)	; PARAMETER STRING DATA
;
		SUBTTL
		PAGE
		ORG	100H		; DEFAULT ENTRY ADDRESS
PROGRAM_ENTRY	EQU	$
