//         IBMPC.CPP
//
// Low-level functions addressing BIOS & PC Hardware
//
// Original code written by:  Al Stevens for the Aztec C compiler
// Modified for Turbo C++ 2.0
//
// Compile to object using BCC or BCCX:
// bccx -c ibmpc
//
// To use TASM remove the comment prior to the #pragma inline and compile.
// This provides a good example where inline statements should be used.  The
// best example is Al Steven's use of inline statements to quickly retrieve
// system information on video retrace.
//

// #pragma inline
#include <dos.h>
static union REGS rg;

//             position the cursor

void pascal  cursor(int x, int y)
{
	rg.x.ax = 0x0200;
	rg.x.bx = 0;
	rg.x.dx = ((y << 8) & 0xff00) + x;
	int86(16, &rg, &rg);
}

//              return the cursor position
void pascal  curr_cursor(int *x, int *y)
{
	rg.x.ax = 0x0300;
	rg.x.bx = 0;
	int86(16, &rg, &rg);
	*x = rg.h.dl;
	*y = rg.h.dh;
}

//             set cursor type
void pascal  set_cursor_type(int t)
{
	rg.x.ax = 0x0100;
	rg.x.bx = 0;
	rg.x.cx = t;
	int86(16, &rg, &rg);
}
char attrib = 7;

//               clear the screen

void pascal  clear_screen()
{
	cursor(0, 0);
	rg.h.al = ' ';
	rg.h.ah = 9;
	rg.x.bx = attrib;
	rg.x.cx = 2000;
	int86(16, &rg, &rg);
}

//             return the video mode
int pascal  vmode()
{
	rg.h.ah = 15;
	int86(16, &rg, &rg);
	return rg.h.al;
}

//          test for scroll lock
int pascal   scroll_lock()
{
	rg.x.ax = 0x0200;
	int86(0x16, &rg, &rg);
	return rg.h.al & 0x10;
}
void (*helpfunc)();
int helpkey = 0;
int helping = 0;

//     insert a character and attribute into video RAM

void pascal  vpoke(unsigned vseg, unsigned adr, unsigned chr)
{
	if (vseg == 45056)			/* monochrome mode */
		poke(vseg, adr, chr);
	else	{
		_DI = adr;		/* offset of video character */
		_ES = vseg;		/* video segment */
		asm cld;
		_BX = chr;		/* the attribute and character */
		_DX = 986;		/* video status port */
                //        wait for video retrace to start
		do
			asm in  al,dx;
		while (_AL & 1);
                //        wait for video retrace to stop
		do
			asm in  al,dx;
		while (!(_AL & 1));
		_AL = _BL;
		asm stosb;		/* store character */
                //        wait for video retrace to start
		do
			asm in  al,dx;
		while (_AL & 1);
                //        wait for video retrace to stop
		do
			asm in  al,dx;
		while (!(_AL & 1));
		_AL = _BH;
                asm stosb;              // store attribute
	}
}

//      read a character and attribute from video RAM
int pascal  vpeek(unsigned vseg, unsigned adr)
{
	int ch, at;

        if (vseg == 45056)                              // monochrome mode
		return peek(vseg, adr);
	asm push ds;
        _DX = 986;                      // video status port
        _DS = vseg;                     // video segment address
        _SI = adr;                      // video character offset
	asm cld;
        //        wait for video retrace to start
	do
		asm in  al,dx;
	while (_AL & 1);
        //        wait for video retrace to stop
	do
		asm in  al,dx;
	while (!(_AL & 1));
	asm lodsb;			/* get the character */
	_BL = _AL;
        //        wait for video retrace to start
	do
		asm in  al,dx;
	while (_AL & 1);
        //        wait for video retrace to stop
	do
		asm in  al,dx;
	while (!(_AL & 1));
        asm lodsb;                      // get the attribute
	_BH = _AL;
	_AX = _BX;
	asm pop ds;
	return _AX;
}
