title	The CLock Device Driver Prototype
page	60,132
;program	proto.asm
;date		15 November 1986
;

code	segment				;define segment as code
	assume	cs:code, ds:code 	;COM file DS=CS
	org	100h			;COM file start

main	proc			;main procedure
start:				; start
loop:	call	select		;prompt for selection

	cmp	al,'F'		;find clock address?
	jne	lread		;no
	call	find		;find clock chip base address
	jmp	loop		;

lread:	cmp	al,'R'		;read?
	jne	ltime		;no
	call	isetup		;setup for INPUT
	call	read		;INPUT - read chip
	jmp	loop		;

ltime:	cmp	al,'T'		;display time?
	jne	lwrite		;no
	call	time		;
	jmp	loop		;

lwrite:	cmp	al,'W'		;write?
	jne	exit		;no
	call	osetup		;setup for OUTPUT
	call	write		;OUTPUT - DOS date to chip 
	jmp	loop		;

exit:	cmp	al,'E'		;exit?
	jne	loop		;no
	int	20h		;exit back to DOS

;structures for the Device Driver

dosdate	struc		;DOS DATE structure
dos_day	dw	?	;days since 1/1/80
dos_min	db	?	;minutes
dos_hr	db	?	;hours
dos_hun	db	?	;hundredths of a second
dos_sec	db	?	;seconds
dosdate	ends		;end of struc

;structures

rh		struc		;request header 
rh_len		db	?	;len of packet
rh_unit		db	?     	;unit code 
				;(block devices only)
rh_cmd		db	?     	;device driver command
rh_status	dw	?     	;returned by device driver 
rh_res1		dd	?     	;reserved
rh_res2		dd	?     	;reserved
rh		ends	      	;

rh0		struc		;Initialization (command 0)
rh0_rh		db	size rh dup (?)	;fixed portion
rh0_nunits	db	?     	;number of units 
				;(block devices only)
rh0_brk_ofs	dw	?     	;offset address for break
rh0_brk_seg	dw	?     	;segment address for break
rh0_bpb_tbo	dw	?     	;offset address of pointer
				;to BPB array
rh0_bpb_tbs	dw	?     	;segment address of pointer 
				;to BPB array
rh0_drv_ltr	db	?     	;first available drive 
				;(DOS 3+) (block only)
rh0		ends	      	;

rh4		struc		;INPUT (command 4)
rh4_rh		db	size rh dup(?)	;fixed portion
rh4_media	db	?     	;media descriptor from DPB
rh4_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh4_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh4_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh4_start	dw	?     	;start sector number 
				;(block only)
rh4		ends	      	;

rh8		struc		;OUTPUT (command 8)
rh8_rh		db	size rh dup(?)	;fixed portion
rh8_media	db	?     	;media descriptor from DPB
rh8_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh8_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh8_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh8_start	dw	?     	;start sector number 
				;(block only)
rh8		ends	      	;

rh9		struc		;OUTPUT_VERIFY (command 9)
rh9_rh		db	size rh dup(?)	;fixed portion
rh9_media	db	?     	;media descriptor from DPB
rh9_buf_ofs  	dw	?     	;offset address of 
				;data transfer area
rh9_buf_seg  	dw	?     	;segment address of 
				;data transfer area
rh9_count 	dw	?     	;transfer count 
				;(sectors for block) 
				;(bytes for character)
rh9_start	dw	?     	;start sector number (block only)
rh9		ends	      	;

;commands that do not have unique portions to the request header:
;	INPUT_STATUS 	(command 6)
;	INPUT_FLUSH	(command 7)
;	OUTPUT_STATUS	(command 10)
;	OUTPUT_FLUSH	(command 11)
;	OPEN		(command 13)
;	CLOSE		(command 14)
;	REMOVEABLE	(command 15)
;	 

;local storage

dosdays		dw	0	;DOS date (days since 1/1/80)
clock_port	dw	340h	;clock chip base address

table	label	byte
jan	db	31
feb	db	28
mar	db	31
apr	db	30
may	db	31
jun	db	30
jul	db	31
aug	db	31
sep	db	30
oct	db	31
nov	db	30
decm	db	31

;local procedures

hex2bcd	proc	near	;convert AL from Hex to BCD
;uses	ax,cx
	push	cx
	mov	cl,10	;divide by 10
	mov	ah,0	;setup for divide
	div	cl	;get 10's digits
	mov	cl,4	;shift count
	shl	al,cl	;place 10's in left half
	or	al,ah	;add back 1's
	pop	cx
	ret		;return to caller
hex2bcd	endp

bcd2hex	proc	near	;convert AL from BCD to hex
;uses ax,cx
	push	cx
	mov	ah,0	;setup for divide
	push	ax	;save for 1's processing
	mov	cl,16	;divide for left half of byte
	div	cl	; to get 10's digits
	mov	ah,0	;have 10's digits
	mov	cl,10	;convert to base 10
	mul	cl	; by multiplying by 10
	pop	cx	;process 1's digits
	and	cl,0fh	;keep 1's only
	add	al,cl	;add 1's to 10's
	pop	cx
	ret		;return to caller
bcd2hex	endp

;chip parameters
;	base address for the clock chip is hardware selcted
;	each port referenced to this base address contains
;	either a chip-maintained counter or a RAM location
;	for use by a program.
;
;base port address		base port address
;
;+0	1/10,000ths counter	+c	not used - RAM
;+1	1/100 +1/10 counter	+d	not used - RAM
;+2	seconds     counter	+e	not used - RAM
;+3	minutes     counter	+f	not used - RAM
;+4	hours       counter	+10	interrupt status register
;+5	day of week counter	+11	interrupt control register
;+6	day of monthcounter	+12	counter reset 
;+7	month       counter	+13	ram reset     
;+8	upper nibble    RAM	+14	status bit     
;+9	previous month  RAM	+15	GO command     
;+a     years since 80  RAM	+16	standby interrupt
;+b     reserved        RAM	+1f	test mode

;data declarations for the prototype program

input_data	label	byte
	db	16h	;length of request header
	db	0	;units	
	db	4	;command = input
	dw	?	;status
	dd	?	;reserved
	dd	?	;reserved
	db	?	;media descriptor
	dw	clkdata	;offset address of data transfer area
inseg	dw	?	;segment address of same
	dw	6	;6 bytes in DOS date format
	dw	?	;start sector

output_data	label	byte
	db	16h	;length of request header
	db	0	;units	
	db	8	;command = input
	dw	?	;status
	dd	?	;reserved
	dd	?	;reserved
	db	?	;media descriptor
	dw	clkdata	;offset address of data transfer area
outseg	dw	?	;segment address of same
	dw	6	;6 bytes in DOS date format
	dw	?	;start sector

clkdata	db	6	dup(?)

rh_ofs	dw	?	;request header offset address
rh_seg	dw	?	;request header segment address

pmsg1	db	'[F]indAddress,[R]ead,[T]imeDisplay,',
	db	'[W]rite,[E]xit : ',
pmsg1a	db	0dh,0ah,'$'
pmsg2	db	'no chip found!',0dh,0ah,'$'
pmsg3	db	'Clock chip found at address ',
pmsg3a	db	'0000h!',0dh,0ah,'$'
pmsg4	db	'Chip Time is ',
pmsg4m	db	'00/',
pmsg4d	db	'00/',
pmsg4y	db	'0000 ',
pmsg4h	db	'00:',
pmsg4mn	db	'00:',
pmsg4s	db	'00',0dh,0ah,'$'

select	proc	near	;prompt and select function
	lea	dx,pmsg1	;address of display string
	call	Dos9		;display
	mov	ah,1		;keyboard input
	int	21h		;DOS call
	push	ax		;save for return
	lea	dx,pmsg1a	;CR/LF 
	call	dos9		;display
	pop	ax		;restore input character
	ret			;return to caller
select	endp		;

isetup	proc	near	;set up ESBX for prototype use
	mov	ax,cs			;get code segment address
	mov	cs:rh_seg,ax		;save it
	mov	cs:inseg,ax		;set segment address
	mov	es,ax			;setup ES
	lea	bx,cs:input_data	;get offset address
	mov	cs:rh_ofs,bx		;save it
	ret				;return to caller
isetup	endp

osetup	proc	near	;set up ESBX for prototype use
	mov	ax,cs			;get code segment address
	mov	cs:rh_seg,ax		;save it
	mov	cs:outseg,ax		;set segment address
	mov	es,ax			;setup ES
	lea	bx,cs:output_data	;get offset address
	mov	cs:rh_ofs,bx		;save it
	ret				;return to caller
osetup	endp

clock_table	label	byte	;table of possible clock addresses
	dw	0240h		;first address
	dw	02c0h		;second address
	dw	0340h		;third address

find	proc	near	;find clock chip base address
	lea	si,cs:clock_table	;get address of table
	mov	cx,3			;three addressess
find1:	mov	dx,cs:[si]		;get 1st address
	add	dx,2			;base+2 = seconds
	in	al,dx			;get seconds
	test	al,80h			;high order bit set?
	jz	find2			;no - not empty port
	add	si,2			;next address
	loop	find1			;search thru clock table
;no port found
	lea	dx,pmsg2		;no port found
	call	dos9			;DOS call
	jmp	find3			;exit
;cx	3	2	1 
;port	1st	2nd	3rd
find2:	mov	dx,3			;convert back to port #
	sub	dx,cx			;port position
	shl	dx,1			;double it
	lea	di,cs:clock_table	;address of chip table
	add	di,dx			;word index
	mov	dx,cs:[di]		;get port
	lea	di,cs:pmsg3a		;string address
	call	hex2asc			;convert to ASCII
	lea	dx,pmsg3		;string to display
	call	dos9			;console display
find3:	ret				;return to caller
find	endp				;

hex2dec	proc	near	;convert hex to decimal ASCII
;			AX - input
;			DI - destination string
;			CX - number of places 
	push	ax		;save ax
	push	cx		;save cx
	push	dx		;save dx
	cmp	cx,2		;2 or 4 place conversion
	je	d10		;2!
	mov	cx,1000		;four places
	mov	dx,0		;clear hi order
	div	cx		;q=ax, rem=dx
	add	al,30h		;make it ASCII
	mov	cs:[di],al	;store it
	inc	di		;next
	mov	ax,dx		;remainder back in ax
	mov	cx,100		;three places
	mov	dx,0		;clear hi order
	div	cx		;q=ax, rem=dx
	add	al,30h		;make it ASCII
	mov	cs:[di],al	;store it
	inc	di		;next
	mov	ax,dx		;remainder back in ax
d10:	mov	cx,10		;two places
	mov	dx,0		;clear hi order
	div	cx		;q=ax, rem=dx
	add	al,30h		;make it ASCII
	mov	cs:[di],al	;store it
	inc	di		;next
	mov	ax,dx		;remainder back in ax
	add	al,30h		;make it ASCII
	mov	cs:[di],al	;store it
	inc	di		;next
	pop	dx		;
	pop	cx		;
	pop	ax		;
	ret
hex2dec	endp

time	proc	near		;display clock chip contents

	mov	dx,cs:clock_port	;get chip base address
	add	dx,2			;base+2 (seconds)
	in	al,dx			;get it
	call	bcd2hex			;convert to hex
	mov	ah,0			;clear hi order
	mov	cx,2			;2 places 
	lea	di,cs:pmsg4s		;
	call	hex2dec			;convert to decimal ASCII
	inc	dx			;base+3 (minutes)
	in	al,dx			;get it
	call	bcd2hex			;
	mov	ah,0			;clear hi-order
	lea	di,cs:pmsg4mn		;
	call	hex2dec
	inc	dx			;base+4 (hours)
	in	al,dx			;get it
	call	bcd2hex			;
	mov	ah,0			;clear hi-order
	lea	di,cs:pmsg4h		;
	call	hex2dec
	add	dx,2			;base+6 (day)
	in	al,dx			;get it
	call	bcd2hex			;
	mov	ah,0			;
	lea	di,cs:pmsg4d		;
	call	hex2dec			;
	inc	dx			;base+7 (month)
	in	al,dx			;
	call	bcd2hex			;
	mov	ah,0			;
	lea	di,cs:pmsg4m		;
	call	hex2dec			;
	add	dx,3			;base+10
	in	al,dx			;get year in hex
	mov	ah,0			;
	lea	di,cs:pmsg4y		;
	add	ax,1980			;make it readable
	mov	cx,4			;
	call	hex2dec			;convert year
	lea	dx,pmsg4		;
	call	dos9			;
	ret				;return to caller
time	endp		;

write	proc	near
;This procedure takes the date in DOS date format and 
;converts to Julian format for writing to the clock chip
;
;es:bx points to the request header
; point to DOS date and let ES:BX point to beginning
	mov	si,es:[bx].rh8_buf_ofs	;get data offset
	mov	ax,es:[bx].rh8_buf_seg	;get data segment
	mov	ds,ax			;to DS for (DS:SI use)
	push	si			;save offset
	push	ds			;save segment
	push	cs			;
	pop	es			;ES points to here
	lea	di,cs:dosdays		;destination address
	mov	cx,2			;move count = 2
	cld				;direction is forward
	rep	movsb			; from DOS to us
	push	cs			;restore DS
	pop	ds			; by using CS
;update clock chip with time from DOS date data
	pop	es			;restore DOS date segment
	pop	bx			;restore DOS date offset
	mov	dx,cs:clock_port	;get clock port
	inc	dx			;base+1
	mov	al,es:[bx].dos_hun	;get hundredths
	call	hex2bcd			;convert for clock use
	out	dx,al			;send to clock chip
	inc	dx			;base+2
	mov	al,es:[bx].dos_sec	;get seconds
	call	hex2bcd			;convert for clock use
	out	dx,al			;send to clock chip
	inc	dx			;base+3
	mov	al,es:[bx].dos_min	;get minutes
	call	hex2bcd			;convert for clock use
	out	dx,al			;send to clock chip
	inc	dx			;base+4
	mov	al,es:[bx].dos_hr	;get hours
	call	hex2bcd			;convert for clock use
	out	dx,al			;send to clock chip

;chip loaded with time - now calc Julian date from DOS date
	mov	ax,cs:dosdays		;get days since 1/1/80
	cmp	ax,0			;date not set?
	je	out8			;skip everything
	inc	ax			;* add 1 for elapsed days
	mov	bx,0			;BX = year count
out1:	cmp	ax,365			;day count within a year?
	jle	out2			;yes 
	sub	ax,365			;no - subtract 365
	inc	bx			;increment year count
	jmp	out1			;continue until w/i 1 yr
;BX has years since 1980 - now adjust for leap years
out2:	push	ax			;save leftover days
	mov	ax,bx			;AX now has years
	mov	cl,4			;divisor for leap years
	div	cl			;al=leaps, ah=remainder
	mov	cl,ah			;remainder=0 is leap itself
	mov	ah,0			;set up for subtract
	inc	ax			;add 1 to leap year count
	mov	dx,ax			;DX has 1 day/leap yr passed
	pop	ax			;restore days remaining
	sub	ax,dx			;subtract 1 day for each leap yr
	cmp	ax,0			;are we negative?
	jg	out3			;no - we are ok
	add	ax,365			;add back 365 days
	dec	bx			;subtract 1 year
out3:	push	bx			;save year count
	cmp	cl,0			;leap year if 0
	jne	out5			;not a leap year
	cmp	ax,59			;Feb 29?
	je	out4			;yes - set and exit
	jg	out5			;past Feb 29
	inc	ax			;before - reverse subtraction
	jmp	out5			;
out4:	mov	cx,2			;Feb
	mov	ax,29			; 29
	jmp	out7			;exit
;AX has days left in current year - now find month and day
out5:	mov	cx,1			;month count
	lea	di,cs:table		;days per month
	mov	bh,0			;clear hi-order
out6:	mov	bl,es:[di]		;get days in each month
	inc	di			;increment to next month
	cmp	ax,bx			;less than last day?
	jle	out7			;yes (in current month)
	sub	ax,bx			;no subtract days in month
	inc	cx			;increment month count
	jmp	out6			;continue until month found
;AX has days, CX has month - now get years since 1980
out7:	pop	bx			;restore year count
	jmp	out9			;go load chip 
;no date set (special case)
out8:	mov	bx,0			;1980
	mov	cx,1			;Jan
	mov	ax,1			; 1st
;BX = years since 1980, CX = month, AX = days - now load clock chip
out9:	mov	dx,cs:clock_port	;get chip base address
	add	dx,6			;base+6
	push	cx			;Hex2bcd destroys cx
	call	hex2bcd			;convert for chip use
	out	dx,al			;set days counter
	inc	dx			;base+7
	pop	ax			;restore month count
	call	hex2bcd			;convert for chip use
	out	dx,al			;set months counter
	add	dx,2			;base+9
	out	dx,al			;set months RAM
	inc	dx			;base+10
	xchg	al,bl			;move years to al
	out	dx,al			;set years since 1980 RAM
	ret				;back to caller

write	endp

read	proc	near	;convert clock chip data to DOS format
;This procedure takes the clock chip Julian date and time
;and converts to DOS date format
	mov	dx,es:[bx].rh4_buf_ofs	;get dos date data area
	mov	ax,es:[bx].rh4_buf_seg	;
	mov	es,ax			;set up es
	mov	bx,dx			;set up bx
;es:bx now points to the data area where DOS 
;expects the DOS date format returned
	push	es			;save segment for later
	push	bx			;save offset for later
;first read the clock chip for time
	mov	dx,cs:clock_port	;get the clock base address
	inc	dx			;base+1
	in	al,dx			;get hundredths
	call	bcd2hex			;convert data
	mov	es:[bx].dos_hun,al	;store hundredths
	inc	dx			;base+2
	in	al,dx			;get seconds
	call	bcd2hex			;convert data
	mov	es:[bx].dos_sec,al	;store seconds 
	inc	dx			;base+3
	in	al,dx			;get minutes
	call	bcd2hex			;convert data
	mov	es:[bx].dos_min,al	;store minutes 
	inc	dx			;base+4
	in	al,dx			;get hours
	call	bcd2hex			;convert data
	mov	es:[bx].dos_hr,al	;store hours
;now convert Julian chip date (BCD format) to DOS date format (hex)

;first check to see if month (and therefore year) has changed 
;by comparing the months COUNTER against the month RAM location 
	mov	dx,cs:clock_port	;get base clock address
	add	dx,7			;base+7
	in	al,dx			;get chip's month counter
 	call	bcd2hex			;convert to hex
	mov	bl,al			;save in bl 
	add	dx,2			;base+9
	in	al,dx			;get RAM version of month
	call	bcd2hex			;convert to hex
	cmp	al,bl			;is RAM & counter same?
	jg	newyear			;last month > current ( 12>1 )
	jl	updatemonth		;last month < current
	jmp	cvt2dos			;same month 
;December rolled over to January - update the Year count in RAM
newyear:
	inc	dx			;base+10
	in	al,dx			;get year (stored in RAM)
	inc	al			;add 1 year
	out	dx,al			;store in RAM year 
	dec	dx			;make it base+9
;now update month in RAM
updatemonth:
	mov	al,bl			;set current month
	call	hex2bcd			;convert for clock chip
	out	dx,al			;update month RAM

;determine days in previous years
cvt2dos:
	inc	dx			;base+10 (RAM)
	in	al,dx			;get years since 1980
	mov	ah,0			;set up for multiply
	push	ax			;save for leap year processing
	mov	bx,365			;days per year
	mul	bx			;times years - AX has days
	xchg	bx,ax			;save days in BX
	mov	cl,4			;leap divisor
	pop	ax			;get year count again
	div	cl			;divide for leap years elapsed
	mov	cl,ah			;save leap year indicator

;BX has total days and cl has leap year indicator
	mov	ah,0			;set up for add
	push	cx			;* save for later use
	cmp	cl,0			;* check for year is leap year
	je	leapadj			;* maybe not past leap 
	inc	ax			;* past leap year => add 1
leapadj:				;* continue
	add	bx,ax			;add leap days to total

;we have days since 1/1/80 for all previous years including
; the extra days in leap years past
curr_days:
	push	bx			;save total days past
	mov	dx,cs:clock_port	;get base clock chip address
	add	dx,7			;base+7
	in	al,dx			;get month counter
	call	bcd2hex			;convert to hex
	mov	ah,0			;set up for index
	push	cs			;days per month table
	pop	es			; addressed by ES
	lea	di,cs:table		; and DI
	mov	cx,0			;clear current year day count
	xchg	ax,cx			;month loop count in cx
	push	cx			;save for leap year check
	dec	cx			;* elapsed up to current month
	mov	bh,0			;clear hi-order
cvt2days:
	mov	bl,es:[di]		;days in this month
	inc	di			;increment for next month
	add	ax,bx			;add to total days
	loop	cvt2days		;until month count exhausted
	pop	cx			;restore months
	pop	bx			;total days past
	add	ax,bx			;add to days in current year
	pop	bx			;* leap indicator?
	cmp	bl,0			;* is current year leap? 
	jne	leapyr			;* no
	cmp	cl,3			;past March?
	jl	leapyr			;no 
	inc	ax			;yes - add 1 for 2/29
leapyr:	
	xchg	ax,cx			;* save days in cx
	dec	dx			;* base+6 is 
	in	al,dx			;* days in current month
	call	bcd2hex			;* convert to hex
	mov	ah,0			;* clear hi for next add
	add	cx,ax			;* add days in this month
	dec	cx			;* subtract 1 for elapsed days
	xchg	ax,cx			;* total days in ax
	pop	bx			;restore DOS date offset
	pop	es			;restore DOS date segment
	mov	es:[bx].dos_day,ax	;return days since 1/1/80
	ret				;return to caller
read	endp

dos9	proc	near
	mov	ah,9	;display service
	int	21h	;DOS Call
	ret		;return to caller
dos9	endp

hex2asc	proc

;requires:
;		dx = binary number 
;		di = address of ASCII string
;uses:
;		ax - for character conversion
;		cx - loop control
;returns:
;		nothing

	push	cx	;save cx
	push	ax	;save ax
	mov	cx,4	;number of hex digits
h1:	push	cx	;save cx inside this loop
	mov	cl,4	;shift count (bits/hex digit)
	rol	dx,cl	;rotate left 1 hex digit
	mov	al,dl	;move hex digit to al
	and	al,0fh	;mask off desired hex digit
	cmp	al,0ah	;is it above 9h?
	jge	h2	;yes
	add	al,30h	;numeric hex digit
	jmp	h3	;skip
h2:	add	al,37h	;alpha hex digit
h3:	mov	cs:[di],al	;store hex digit in string
	inc	di	;next string address
	pop	cx	;get saved loop count
	loop	h1	;loop start
	pop	ax	;restore ax
	pop	cx	;restore cx
	ret		;return to caller	
hex2asc	endp

main	endp			;end of main procedure
code	ends			;end of code segment
	end	start		;	