	TITLE	COPRNT	- Diskette Contents List - Print Cover Sheet
	SUBTTL	Version	1.0 - June 1983
	PAGE	81,132
;
CODE	SEGMENT	PARA PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE
;
	EXTRN	PNTR:WORD,STKCNT:WORD,TITLX:BYTE
;
	EXTRN	CONVRT:NEAR
;
	PUBLIC	PSX,RESTR
PSX	DB	0			;Pass counter
RESTR	DB	12,0			;Printer "restore" forms
DBUF	DB	7 DUP (0)		;Work buffer for file size
DBLK	DB	'  ',0			;Double	blank between columns
LFTB	DB	'|    ',0		;Left border
RGTB	DB	'    |'			;Right border (includes	CRLF)
CRLF	DB	13,10,0
BCNT	DB	0			;Body line counter
;
	PUBLIC	PRINT
PRINT	PROC	NEAR
	INC	PSX			;Count numbers of prints
	MOV	BCNT,33			;Set body line counter
	MOV	AX,STKCNT		;Load entry count
	MOV	DH,4			;Divide	by number of columns
	DIV	DH
	OR	AH,AH
	JZ	SETCNT			;Evenly	divisable
	INC	AL			;Ragged	edge
	CBW
SETCNT:	PUSH	AX			;Entries per column count
	CALL	DOBRDR			;Do upper border
	CALL	DOBLNE			;  and a blank line
	CALL	DOLFTM			;Do left margin
	MOV	DX,OFFSET TITLX
	CALL	DOPRT			;Output	the title line
	CALL	DORGTM			;Do right margin
	CALL	DOBLNE			;  and another blank line
	POP	CX
	MOV	BP,CX
	SHL	BP,1			;BP contains offset/column in ptr list
	MOV	SI,OFFSET PNTR		;Point to start	of ptr list
OTLP:	CALL	DOLFTM			;Do a left margin
	MOV	DL,4			;Set inner loop	count to columns
	XOR	BX,BX			;Clear column offset reg
INLP:	CALL	PRTENT			;Print stack entry
	ADD	BX,BP			;Step to next column entry
	DEC	DL
	JNZ	INLP			;End of	inner loop
	CALL	DORGTM			;Do a right margin
	ADD	SI,2			;Step to next ptr
	DEC	BCNT			;Decrement body	line count
	LOOP	OTLP			;End of	outer loop
	MOV	CL,BCNT			;Load remaining	body lines
	XOR	CH,CH
	JCXZ	NOFILL			;All used
FILL:	CALL	DOBLNE			;Fill out body lines
	LOOP	FILL
NOFILL:	CALL	DOBRDR			;Do bottom border
	MOV	DX,OFFSET RESTR
	CALL	DOPRT			;Restore page
	RET
PRINT	ENDP
;
	PUBLIC	DOPRT
DOPRT	PROC	NEAR			;This subroutine simply	prints
	PUSH	DX			;the string pointed to by the
	PUSH	SI			;DX reg	on entry.  The string
	MOV	SI,DX			;is terminated by a nul	byte.
	MOV	AH,5
DPLP:	MOV	DL,BYTE	PTR [SI]
	OR	DL,DL
	JZ	PRTEND
	INT	21H
	INC	SI
	JMP	DPLP
PRTEND:	POP	SI
	POP	DX
	RET
DOPRT	ENDP
;
PRTENT	PROC	NEAR			;Print one stack entry
	PUSH	CX
	PUSH	DX
	MOV	CX,12
	MOV	DI,WORD	PTR [SI+BX]	;DI points to stack entry
	OR	DI,DI			;If entry is zero, blank space
	JZ	BLNK1
	MOV	AH,5
PELP:	MOV	DL,BYTE	PTR [DI]	;Print to the end of the
	OR	DL,DL			;  name/type entry
	JZ	BLNK2			;  blanking remainder of 12
	INT	21H			;  character field
	INC	DI
	LOOP	PELP
BACK:	INC	DI
	MOV	AX,WORD	PTR [DI]	;Load file size
	MOV	DX,WORD	PTR [DI+2]
	PUSH	SI
	MOV	DI,OFFSET DBUF
	CALL	CONVRT			;Convert size to ASCII decimal
	POP	SI
	MOV	DX,OFFSET DBUF
	CALL	DOPRT			;Print size
GONE:	POP	DX
	PUSH	DX			;Reload	entry value
	DEC	DL
	JZ	PUNT			;If last column	don't space over
	MOV	DX,OFFSET DBLK
	CALL	DOPRT			;Two blanks between columns
PUNT:	POP	DX
	POP	CX
	RET
BLNK1:	MOV	CX,18			;No entry, so blank entire column
	CALL	CLER
	JMP	GONE
BLNK2:	CALL	CLER			;Blanks	remainder of name/type field
	JMP	BACK
PRTENT	ENDP
;
DOBLNE	PROC	NEAR
	PUSH	CX
	CALL	DOLFTM			;Output	a bordered blank line
	MOV	CX,78
	CALL	CLER
	CALL	DORGTM
	POP	CX
	RET
DOBLNE	ENDP
;
DOBRDR	PROC	NEAR
	MOV	CX,88
	MOV	DL,'-'
	CALL	DLFIL			;Output	a top or bottom	border
	MOV	DX,OFFSET CRLF
	CALL	DOPRT
	RET
DOBRDR	ENDP
;
DOLFTM	PROC	NEAR			;Outputs "|    "
	PUSH	DX
	MOV	DX,OFFSET LFTB
	CALL	DOPRT
	POP	DX
	RET
DOLFTM	ENDP
;
DORGTM	PROC	NEAR			;Outputs "    |CRLF"
	PUSH	DX
	MOV	DX,OFFSET RGTB
	CALL	DOPRT
	POP	DX
	RET
DORGTM	ENDP
;
CLER	PROC	NEAR			;Outputs CX blanks to the printer.
	MOV	DL,' '
DLFIL:	MOV	AH,5			;Outputs DL character CX times
CLRLP:	INT	21H
	LOOP	CLRLP
	RET
CLER	ENDP
;
CODE	ENDS
;
	END
