	Page	62,132
;
; This subroutine is called from the program FIX-CAL.PAS, a Turbo Pascal
; version 4.0 program.  The purpose of this routine is to call a subroutine
; that FIX-CAL has put out in memory at NewSeg:100.  This is a calendar
; program that will create a calendar for a given month and year.  FIX-CAL
; redirects the output to a disk file so the calendar may be read in and
; modified by FIX-CAL.
;
; The calendar program returns by means of a RETF instruction.  In the
; original program, puts the return address of Seg:0 on the stack, which
; points to the program segment prefix (PSP), and this location contains
; an INT 20, which causes the program to stop.  Since we don't want the
; program to stop, but we do want it to RETF, FIX-CAL changes the code
; in the calendar program to NOPs, which the program ignores.
;
; This subroutine had to be written in MASM because TP4 doesn't give you
; a way to put a return address on the stack.  TP version 3 did.
;
Data	Segment	word	Public
	Extrn	NewSeg:word
Data	Ends

Code	Segment	Byte	Public

	Assume	CS:Code,DS:Data

	Public	Runit

Runit	Proc	Far

	Push	BP
	Push	DS

	Push	CS			;Current CS for return address
	Mov	BX,Offset Retadr	;Get offset address
	Push	BX			;And put onto stack

	Mov	AX,NewSeg		;Get starting segment
	Push	AX			;And put onto stack
	Mov	BX,100h			;Starting offset
	Push	BX			;And put onto stack.

	Push	AX			;This is new code segment
	Pop	DS			;and also new data segment

	Ret				;Return as a way jumping to program

Retadr:	Pop	DS			;Restore original DS
	Pop	BP			;..BP
	Ret				;and return.

Runit	Endp

Code	Ends
	End
