;ͻ
;  PROGRAM = MOVE.ASM  
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

FILENAME       DB      128 DUP (0)
HANDLE_IN      DW      0
HANDLE_OUT     DW      0
TYPE_FROM      DW      0		       ;POINTS TO TYPE IN FILENAME
OPTIONS        DB      128 DUP(0)	       ;OPTIONS

X	       DW      0
Y	       DW      0
DISK_BUFFER    DD      0		       ;DISK BUFFER OFFSET

;44 BYTES
IMG_NAME       DB      '                              '
IMG_HEIGHT     DW      0
IMG_WIDTH      DW      0
IMG_WIDTH_BYTE DW      0
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

STR_NAME       DB      '                              '
STR_HEIGHT     DW      0
STR_WIDTH      DW      0
STR_WIDTH_BYTE DW      0
STR_PIX_SIZE   DW      1
STR_PIX_FMT    DW      0
STR_COLOR      DW      0
STR_COMPRESS   DW      0

BYTE_ADJUST    DW      0
EIGHT	       DW      8

IMG	       DB      'IMG',0
STR	       DB      'STR',0

TELL_HOW       DB      'Ŀ',cr,lf
	       DB      'syntax = STRETCH filename.IMG [X#],[Y#]                      ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      'filename.typ = name of image file....must have correct type  ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      '   X#  = Number of times to expand 1 vertical pixel          ',CR,LF
	       DB      '         X# only presently supports 2,4,8                    ',CR,LF
	       DB      '   Y#  = Number of times to expand 1 horizontal pixel        ',CR,LF
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'open error on input file',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
TYPE_ERROR     DB      'error in type of input file',cr,lf
	       Db      'must be IMG',cr,lf,'$'
NOT_IMP        DB      'NOT IMPLIMENTED YET',CR,LF,'$'
;ͻ
;  MOVE.ASM  
;ͼ
MOVE	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLD
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN700		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN800		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       CMP     AL,'.'                  ;START OF TYPE
	       JNE     GFN200		       ;
	       MOV     CS:TYPE_FROM,DI	       ;START OF TYPE
GFN200:
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE ALREADY
GFN300:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       CMP     AL,'a'
	       JB      GFN400
	       CMP     AL,'z'
	       JA      GFN400
	       AND     AL,0DFH		       ;CONVERT TO UPPER CASE
GFN400:
	       STOSB			       ;SAVE CHARACTER
	       LOOP    GFN300		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE
GFN700: 				       ;
	       MOV     AL,0		       ;
	       STOSB			       ;
	       MOV     DI,OFFSET OPTIONS       ;
	       LOOP    GFN300
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
	       CMP     WORD PTR CS:TYPE_FROM,0 ;
	       JE      GFN800		       ;ERROR
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       MOV     DS,BX
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       INC     BX		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
;Ŀ
;	       CHECK FOR CORRECT FILE TYPE				       
;
	       MOV     SI,OFFSET IMG	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       AND     BYTE PTR [DI],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+1],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+2],0DFH		;MAKE CAPITOL LETTER
	       REP     CMPSB		       ;
	       JNE     OIF050
;Ŀ
;	       OPEN INPUT FILE						       
;
	       MOV     AH,3DH		       ;OPEN FILE FOR READ/WRITE
	       MOV     AL,2H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       CHECK FOR OPTIONS					       
;
	       MOV     SI,OFFSET OPTIONS
OPT100:
	       LODSB
	       CMP     AL,0		       ;END OF OPTIONS?
	       JE      OPT900		       ;YES GO ON
	       AND     AL,0DFH

	       CMP     AL,'X'                  ;UP
	       JNE     OPT200
	       CALL    GET_NUMBER
	       MOV     X,AX
	       JMP     SHORT OPT100
OPT200:
	       CMP     AL,'Y'                  ;DOWN
	       JNE     OPT100
	       CALL    GET_NUMBER
	       MOV     Y,AX
	       JMP     SHORT OPT100
OPT900:
;Ŀ
;	       READ IMG HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,44
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       COPY TO STR HEADER					       
;
	       MOV     SI,OFFSET IMG_NAME
	       MOV     DI,OFFSET STR_NAME
	       MOV     CX,44
	       REP     MOVSB
;Ŀ
;	       CALCULATE HEADER PARMS					       
;
	       CMP     X,0
	       JE      CH200
	       MOV     AX,IMG_WIDTH
	       MUL     X
	       MOV     STR_WIDTH,AX
	       DIV     EIGHT
	       CMP     DX,0
	       JE      CH100
	       INC     AX
CH100:
	       MOV     STR_WIDTH_BYTE,AX
CH200:
	       CMP     Y,0
	       JE      CH300
	       MOV     AX,IMG_HEIGHT
	       MUL     Y
	       MOV     STR_HEIGHT,AX
CH300:
;Ŀ
;	       CHANGE FILENAME						       
;
	       MOV     SI,OFFSET STR	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     MOVSB		       ;
;Ŀ
;	       CREATE OUTPUT FILE					       
;
	       MOV     AH,3CH		       ;
	       MOV     CX,20H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     COF100
	       MOV     DX,OFFSET CREATE_ERROR  ;
	       JMP     ERROR
COF100:
	       MOV     HANDLE_OUT,AX
;Ŀ
;	       WRITE NEW HEADER 					       
;
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,44
	       MOV     DX,OFFSET STR_NAME
	       INT     21H
;Ŀ
;	       TRANSFER FILE						       
;
	       MOV     CX,IMG_HEIGHT
CFA050:
	       PUSH    CX
	       CALL    READ_LINE
	       CMP     X,0
	       JE      CFA200
CFA100:
	       CALL    EXPAND_X
CFA200:
	       MOV     CX,Y
	       CMP     CX,0
	       JNE     CFA300
	       INC     CX
CFA300:
	       CALL    WRITE_LINE
	       LOOP    CFA300
	       POP     CX
	       LOOP    CFA050
;Ŀ
;	       CLOSE FILES						       
;
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     BX,HANDLE_OUT	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       RET			       ;
MOVE	       ENDP

;ͻ
;  GET NUMBER  
;ͼ
;Ŀ
;	       GET NUMBER FOLLOWING COMMAND				       
;
GET_NUMBER     PROC    NEAR

	       PUSH    BX
	       MOV     BX,0
GN100:
	       CMP     BYTE PTR [SI+BX],'0'
	       JB      GN200
	       CMP     BYTE PTR [SI+BX],'9'
	       JA      GN200
	       INC     BX
	       JMP     SHORT GN100
GN200:
	       MOV     AX,BX
	       CALL    ASC2BIN
	       ADD     SI,BX
	       POP     BX
	       RET

GET_NUMBER     ENDP
;ͻ
;  ASCII TO BINARY  
;ͼ
DIVISOR        DW      0,1
TEN	       DW      10,100,1000,10000
;Ŀ
;	    DS:SI = START OF ASCII STRING				       
;	       AX = NUMBER OF CHARACTER IN STRING (1-5) 		       
;Ĵ
;	       AX = RETURNS BINARY NUMBER				       
;
	       PUBLIC  ASC2BIN
ASC2BIN        PROC    NEAR

	       PUSH    BX		       ;SAVE REGISTERS
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    SI		       ;

	       SHL     AX,1		       ;MAKE INTO WORD OFFSET
	       MOV     BX,AX		       ;
	       PUSH    SI		       ;
	       MOV     SI,OFFSET DIVISOR       ;
	       MOV     CX,[SI+BX]	       ;DIVISOR
	       POP     SI		       ;
	       XOR     BX,BX		       ;CLEAR BINARY HOLD REGISTER
					       ;
ASC100: 				       ;
	       LODSB			       ;GET ASCII NUMBER
	       AND     AL,0FH		       ;STRIP ASCII PART
	       XOR     AH,AH		       ;
	       MUL     CX		       ;
	       ADD     BX,AX		       ;
	       CMP     CX,1		       ;DONE?
	       JE      ASC300
	       MOV     AX,CX		       ;GET DIVISOR
	       XOR     DX,DX		       ;
	       DIV     TEN		       ;DIVIDE IT BY TEN
	       MOV     CX,AX		       ;PUT BACK IN DX
	       JMP     SHORT ASC100	       ;
ASC300:
	       MOV     AX,BX		       ;PUT BINARY NUMBER IN AX
	       POP     SI		       ;RESTORE REGISTERS
	       POP     DX		       ;
	       POP     CX		       ;
	       POP     BX		       ;
	       RET
ASC2BIN        ENDP
;ͻ
;  READ_LINE  
;ͼ
READ_LINE      PROC    NEAR

	       PUSH    BX
	       PUSH    CX
	       PUSH    DX
	       PUSH    DS
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,IMG_WIDTH_BYTE
	       LDS     DX,DISK_BUFFER
	       INT     21H
	       POP     DS
	       POP     DX
	       POP     CX
	       POP     BX
	       RET

READ_LINE      ENDP
;ͻ
;  WRITE_LINE  
;ͼ
WRITE_LINE     PROC    NEAR

	       PUSH    BX
	       PUSH    CX
	       PUSH    DX
	       PUSH    DS
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,STR_WIDTH_BYTE
	       LDS     DX,DISK_BUFFER
	       INT     21H
	       POP     DS
	       POP     DX
	       POP     CX
	       POP     BX
	       RET

WRITE_LINE     ENDP
;ͻ
;  EXPAND_X      
;ͼ
X_TABLE:
	       DW      0		       ;1
	       DW      OFFSET X_2	       ;2
	       DW      0		       ;3
	       DW      OFFSET X_4	       ;4
	       DW      0		       ;5
	       DW      0		       ;6
	       DW      0		       ;7
	       DW      OFFSET X_8	       ;8
EXPAND_X       PROC    NEAR


	       PUSH    AX
	       PUSH    BX
	       PUSH    CX
	       PUSH    DX
	       PUSH    DI
	       PUSH    SI
	       PUSH    DS
	       PUSH    ES
EX100:
	       MOV     BX,X
	       CMP     BX,8
	       JBE     EX200
	       JMP     SHORT EX800
EX200:
	       SUB     BX,1
	       SHL     BX,1
	       ADD     BX,OFFSET X_TABLE
	       CMP     WORD PTR [BX],0
	       JE      EX800

	       LES     DI,DISK_BUFFER
	       LDS     SI,DISK_BUFFER
	       ADD     DI,8000H
	       XOR     DX,DX
	       MOV     CX,CS:IMG_WIDTH_BYTE
	       CALL    cs:[BX]
	       LES     SI,CS:DISK_BUFFER
	       LDS     DI,CS:DISK_BUFFER
	       ADD     SI,8000H
	       MOV     CX,CS:STR_WIDTH_BYTE
	       REP     MOVSB
EX800:
	       POP     ES
	       POP     DS
	       POP     SI
	       POP     DI
	       POP     DX
	       POP     CX
	       POP     BX
	       POP     AX

	       RET

EXPAND_X       ENDP
;Ŀ
;	       X_2							       
;
X2_TABLE       DB      00H,03H,0CH,0FH
	       DB      30H,33H,3CH,3FH
	       DB      0C0H,0C3H,0CCH,0CFH
	       DB      0F0H,0F3H,0FCH,0FFH
X_2	       PROC    NEAR

	       LODSB
	       PUSH    DS
	       MOV     BX,CS
	       MOV     DS,BX
	       MOV     BX,OFFSET X2_TABLE

	       MOV     AH,AL
	       SHR     AL,1
	       SHR     AL,1
	       SHR     AL,1
	       SHR     AL,1
	       XLAT
	       STOSB
	       MOV     AL,AH
	       AND     AL,0FH
	       XLAT
	       STOSB
	       POP     DS
	       LOOP    X_2
	       RET

X_2	       ENDP
;Ŀ
;	       X_4							       
;
X4_TABLE       DB      00H,0FH,0F0H,0FFH
X_4	       PROC    NEAR
	       LODSB
	       PUSH    DS
	       MOV     BX,CS
	       MOV     DS,BX
	       MOV     BX,OFFSET X4_TABLE

	       PUSH    CX
	       MOV     CX,4
	       MOV     AH,AL
X4_200:
	       ROL     AH,1
	       ROL     AH,1
	       MOV     AL,AH
	       AND     AL,3
	       XLAT
	       STOSB
	       LOOP    X4_200
	       POP     CX
	       POP     DS
	       LOOP    X_4
	       RET

X_4	       ENDP
;Ŀ
;	       X_8							       
;
X_8	       PROC    NEAR

	       PUSH    BX
	       DIV     CS:EIGHT
X8_100:
	       PUSH    CX
	       MOV     CX,8
	       LODSB
	       MOV     BL,AL
X8_200:
	       RCL     BL,1
	       JC      X8_300
	       XOR     AL,AL
	       JMP     SHORT X8_400
X8_300:
	       MOV     AL,0FFH
X8_400:
	       STOSB
	       LOOP    X8_200
	       POP     CX
	       LOOP    X8_100
	       POP     BX
	       RET

X_8	       ENDP
;ͻ
;  CLEAR BUFFER 
;ͼ
CLEAR_BUFFER   PROC    NEAR

	       PUSH    AX
	       PUSH    CX
	       PUSH    DI
	       PUSH    ES

	       XOR     AX,AX
	       MOV     CX,IMG_WIDTH_BYTE
	       LES     DI,DISK_BUFFER

	       POP     ES
	       POP     DI
	       POP     CX
	       POP     AX
	       RET

CLEAR_BUFFER   ENDP
;ͻ
;ͼ
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
;ͻ
;ͼ
CSEG	       ENDS
	       END     MOVE
