;ͻ
;  PROGRAM = CUT.ASM   
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

FILENAME       DB      128 DUP (0)
HANDLE_IN      DW      0
HANDLE_OUT     DW      0
TYPE_FROM      DW      0		       ;POINTS TO TYPE IN FILENAME
OPTIONS        DB      128 DUP(0)	       ;OPTIONS

TOP	       DW      0
BOTTOM	       DW      0
RIGHT	       DW      0
LEFT	       DW      0
DISK_BUFFER    DD      0		       ;DISK BUFFER OFFSET
					       ;DISK BUFFER SEGMENT

;44 BYTES
IMG_NAME       DB      '                              '
IMG_HEIGHT     DW      0
IMG_WIDTH      DW      0
IMG_WIDTH_BYTE DW      0
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

CUT_NAME       DB      '                              '
CUT_HEIGHT     DW      0
CUT_WIDTH      DW      0
CUT_WIDTH_BYTE DW      0
CUT_PIX_SIZE   DW      1
CUT_PIX_FMT    DW      0
CUT_COLOR      DW      0
CUT_COMPRESS   DW      0

READ_POINTER   DW      44
	       DW      0
WRITE_POINTER  DW      44
	       DW      0
BYTE_ADJUST    DW      0
EIGHT	       DW      8

IMG	       DB      'IMG',0
CUT_STR        DB      'CUT',0

TELL_HOW       DB      'Ŀ',cr,lf
	       DB      'syntax = CUTIMG filename.IMG [t#],[b#],[r#],[l#]             ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      'filename.typ = name of image file....must have correct type  ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      '   t#  = Number of pixels to cut off top of file             ',CR,LF
	       DB      '   b#  = Number of pixels to cut off bottom of file          ',CR,LF
	       DB      '   r#  = Number of BYTES to cut off right side of file       ',CR,LF
	       DB      '   l#  = Number of BYTES to cut off left side of file        ',CR,LF
	       DB      '    #  = (0 to 65535)                                        ',CR,LF
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'open error on input file',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
TYPE_ERROR     DB      'error in type of input file',cr,lf
	       Db      'must be IMG',cr,lf,'$'
NOT_IMP        DB      'NOT IMPLIMENTED YET',CR,LF,'$'
SIZE_ERROR     DB      'pixels to cut exceed number of pixels in file',cr,lf,'$'
DETAIL	       DB      '          '
WIDTH_B_STR    DB      '0000 BYTES          ',CR,LF
	       DB      '   <'
WIDTH_STR      DB      '00000 PIXELS>    ',CR,LF
	       DB      '   Ŀ    ',CR,LF
	       DB      '                        /\ ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '         IMAGE             ',CR,LF
	       DB      '         SIZE              ',CR,LF
	       DB      '         BEFORE            ',CR,LF
	       DB      '         CUT               ',CR,LF
	       DB      '                          '
HEIGHT_STR     DB      '00000 ',CR,LF
	       DB      '                          PIXELS ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                           ',CR,LF
	       DB      '                        \/ ',CR,LF
	       DB      '       '
	       DB      '$'

;ͻ
;  CUT.ASM	 
;ͼ
CUT	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLD
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN700		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       CMP     AL,'.'                  ;START OF TYPE
	       JNE     GFN200		       ;
	       MOV     CS:TYPE_FROM,DI	       ;START OF TYPE
GFN200:
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE ALREADY
GFN300:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       CMP     AL,'a'
	       JB      GFN400
	       CMP     AL,'z'
	       JA      GFN400
	       AND     AL,0DFH		       ;CONVERT TO UPPER CASE
GFN400:
	       STOSB			       ;SAVE CHARACTER
	       LOOP    GFN300		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE
GFN700: 				       ;
	       MOV     AL,0		       ;
	       STOSB			       ;
	       MOV     DI,OFFSET OPTIONS       ;
	       LOOP    GFN300
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
	       CMP     WORD PTR CS:TYPE_FROM,0 ;
	       JE      GFN800		       ;ERROR
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       MOV     DS,BX
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       INC     BX		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
;Ŀ
;	       CHECK FOR CORRECT FILE TYPE				       
;
	       MOV     SI,OFFSET IMG	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       AND     BYTE PTR [DI],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+1],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+2],0DFH		;MAKE CAPITOL LETTER
	       REP     CMPSB		       ;
	       JNE     OIF050
;Ŀ
;	       OPEN INPUT FILE						       
;
	       MOV     AH,3DH		       ;OPEN FILE FOR READ
	       MOV     AL,0H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       CHECK FOR OPTIONS					       
;
	       MOV     SI,OFFSET OPTIONS
OPT100:
	       LODSB
	       CMP     AL,0		       ;END OF OPTIONS?
	       JE      OPT900		       ;YES GO ON
	       AND     AL,0DFH

	       CMP     AL,'T'                  ;UP
	       JNE     OPT200
	       CALL    GET_NUMBER
	       MOV     TOP,AX
	       JMP     SHORT OPT100
OPT200:
	       CMP     AL,'B'                  ;DOWN
	       JNE     OPT300
	       CALL    GET_NUMBER
	       MOV     BOTTOM,AX
	       JMP     SHORT OPT100
OPT300:
	       CMP     AL,'R'                  ;DOWN
	       JNE     OPT400
	       CALL    GET_NUMBER
	       MOV     RIGHT,AX
	       JMP     SHORT OPT100
OPT400:
	       CMP     AL,'L'                  ;LEFT
	       JNE     OPT100
	       CALL    GET_NUMBER
	       MOV     LEFT,AX
	       JMP     SHORT OPT100
OPT900:
;Ŀ
;	       READ IMG HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,44
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       COPY TO CUT HEADER					       
;
	       MOV     SI,OFFSET IMG_NAME
	       MOV     DI,OFFSET CUT_NAME
	       MOV     CX,44
	       REP     MOVSB
;Ŀ
;	       PRINT SIZE OF IMG					       
;
	       MOV     AX,IMG_WIDTH_BYTE
	       MOV     BX,4
	       MOV     DI,OFFSET WIDTH_B_STR
	       CALL    BIN2ASC

	       MUL     EIGHT
	       MOV     BX,5
	       MOV     DI,OFFSET WIDTH_STR
	       CALL    BIN2ASC

	       MOV     AX,IMG_HEIGHT
	       MOV     BX,5
	       MOV     DI,OFFSET HEIGHT_STR
	       CALL    BIN2ASC

	       MOV     DX,OFFSET DETAIL
	       MOV     AH,9
	       INT     21H
;Ŀ
;	       CHECK FOR SIZE						       
;
	       MOV     AX,LEFT
	       ADD     AX,RIGHT
	       CMP     AX,IMG_WIDTH_BYTE
	       JAE     CHK100
	       MOV     AX,TOP
	       ADD     AX,BOTTOM
	       CMP     AX,IMG_HEIGHT
	       JB      CHK200
CHK100:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     DX,OFFSET SIZE_ERROR    ;
	       JMP     ERROR
CHK200:
	       CMP     LEFT,0
	       JNE     CHK900
	       CMP     RIGHT,0
	       JNE     CHK900
	       CMP     TOP,0
	       JNE     CHK900
	       CMP     BOTTOM,0
	       JNE     CHK900
	       JMP     CLOSE
CHK900:
;Ŀ
;	       CALCULATE HEADER PARMS					       
;
	       MOV     AX,IMG_HEIGHT
	       SUB     AX,TOP
	       SUB     AX,BOTTOM
	       MOV     CUT_HEIGHT,AX

	       MOV     AX,IMG_WIDTH_BYTE
	       SUB     AX,RIGHT
	       SUB     AX,LEFT
	       MOV     CUT_WIDTH_BYTE,AX
	       MUL     EIGHT
	       MOV     CUT_WIDTH,AX
;Ŀ
;	       CHANGE FILENAME						       
;
	       MOV     SI,OFFSET CUT_STR       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     MOVSB		       ;
;Ŀ
;	       CREATE OUTPUT FILE					       
;
	       MOV     AH,3CH		       ;
	       MOV     CX,20H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     COF100
	       MOV     DX,OFFSET CREATE_ERROR  ;
	       JMP     ERROR
COF100:
	       MOV     HANDLE_OUT,AX
;Ŀ
;	       WRITE NEW HEADER 					       
;
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,44
	       MOV     DX,OFFSET CUT_NAME
	       INT     21H
;Ŀ
;	       TRANSFER FILE						       
;
	       CMP     TOP,0
	       JE      CFA200
	       MOV     CX,TOP
CFA100:
	       CALL    READ_LINE
	       LOOP    CFA100
CFA200:
	       MOV     CX,CUT_HEIGHT
CFA300:
	       CALL    READ_LINE
	       CALL    WRITE_LINE
	       LOOP    CFA300
;Ŀ
;	       CLOSE FILES						       
;
CLOSE:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     BX,HANDLE_OUT	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       RET			       ;
CUT	       ENDP

;ͻ
;  GET NUMBER  
;ͼ
;Ŀ
;	       GET NUMBER FOLLOWING COMMAND				       
;
GET_NUMBER     PROC    NEAR

	       PUSH    BX
	       MOV     BX,0
GN100:
	       CMP     BYTE PTR [SI+BX],'0'
	       JB      GN200
	       CMP     BYTE PTR [SI+BX],'9'
	       JA      GN200
	       INC     BX
	       JMP     SHORT GN100
GN200:
	       MOV     AX,BX
	       CALL    ASC2BIN
	       ADD     SI,BX
	       POP     BX
	       RET

GET_NUMBER     ENDP
;ͻ
;  ASCII TO BINARY  
;ͼ
DIVISOR        DW      0,1
TEN	       DW      10,100,1000,10000
;Ŀ
;	    DS:SI = START OF ASCII STRING				       
;	       AX = NUMBER OF CHARACTER IN STRING (1-5) 		       
;Ĵ
;	       AX = RETURNS BINARY NUMBER				       
;
	       PUBLIC  ASC2BIN
ASC2BIN        PROC    NEAR

	       PUSH    BX		       ;SAVE REGISTERS
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    SI		       ;

	       SHL     AX,1		       ;MAKE INTO WORD OFFSET
	       MOV     BX,AX		       ;
	       PUSH    SI		       ;
	       MOV     SI,OFFSET DIVISOR       ;
	       MOV     CX,[SI+BX]	       ;DIVISOR
	       POP     SI		       ;
	       XOR     BX,BX		       ;CLEAR BINARY HOLD REGISTER
					       ;
ASC100: 				       ;
	       LODSB			       ;GET ASCII NUMBER
	       AND     AL,0FH		       ;STRIP ASCII PART
	       XOR     AH,AH		       ;
	       MUL     CX		       ;
	       ADD     BX,AX		       ;
	       CMP     CX,1		       ;DONE?
	       JE      ASC300
	       MOV     AX,CX		       ;GET DIVISOR
	       XOR     DX,DX		       ;
	       DIV     TEN		       ;DIVIDE IT BY TEN
	       MOV     CX,AX		       ;PUT BACK IN DX
	       JMP     SHORT ASC100	       ;
ASC300:
	       MOV     AX,BX		       ;PUT BINARY NUMBER IN AX
	       POP     SI		       ;RESTORE REGISTERS
	       POP     DX		       ;
	       POP     CX		       ;
	       POP     BX		       ;
	       RET
ASC2BIN        ENDP
;ͻ
;  BINARY TO ASCII  
;ͼ
;Ŀ
;	       AX = BINARY NUMBER					       
;	       BX = NUMBER OF ASCII CHARACTERS TO FILL	(1-5)		       
;	    ES:DI = WHERE TO PUT ASCII STRING				       
;
	       PUBLIC  BIN2ASC
BIN2ASC        PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DI		       ;
	       PUSH    SI		       ;
	       PUSH    ES

	       SHL     BX,1		       ;MAKE INTO WORD OFFSET
	       MOV     SI,OFFSET DIVISOR       ;
	       MOV     CX,[SI+BX]	       ;DIVISOR

BIN100: 				       ;
	       XOR     DX,DX		       ;CLEAR DX FOR DIVIDE
	       DIV     CX		       ;
	       ADD     AL,'0'                  ;
	       STOSB			       ;
	       CMP     CX,1		       ;
	       JE      BIN300		       ;
	       PUSH    DX		       ;SAVE REMAINDER
	       MOV     AX,CX		       ;GET DIVISOR
	       XOR     DX,DX		       ;
	       DIV     TEN		       ;DIVIDE IT BY TEN
	       MOV     CX,AX		       ;PUT BACK IN DX
	       POP     AX		       ;GET REMAINDER IN AX
	       JMP     SHORT BIN100	       ;
BIN300:
	       POP     ES
	       POP     SI		       ;RESTORE REGISTERS
	       POP     DI		       ;
	       POP     DX		       ;
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET
BIN2ASC        ENDP
;ͻ
;  READ_LINE  
;ͼ
READ_LINE      PROC    NEAR

	       PUSH    BX
	       PUSH    CX
	       PUSH    DX
	       PUSH    DS
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,IMG_WIDTH_BYTE
	       LDS     DX,DISK_BUFFER
	       INT     21H
	       POP     DS
	       POP     DX
	       POP     CX
	       POP     BX
	       RET

READ_LINE      ENDP
;ͻ
;  WRITE_LINE  
;ͼ
WRITE_LINE     PROC    NEAR

	       PUSH    BX
	       PUSH    CX
	       PUSH    DX
	       PUSH    DS
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,CUT_WIDTH_BYTE
	       LDS     DX,DISK_BUFFER
	       ADD     DX,CS:LEFT
	       INT     21H
	       POP     DS
	       POP     DX
	       POP     CX
	       POP     BX
	       RET

WRITE_LINE     ENDP
;ͻ
;ͼ
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
;ͻ
;ͼ
CSEG	       ENDS
	       END     CUT
