;ͻ
;  PROGRAM = PIC2IMG.ASM  
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

IMG	       DB      'GMI',0
PIC	       DB      'PIC'
FILENAME       DB      128 DUP(0)
HANDLE_IN      DW      0
HANDLE_OUT     DW      0
TYPE_FROM      DW      0

LINES_PER_READ DW      0
READS_PER_FILE DW      0
BYTES_PER_READ DW      0

DISK_BUFFER    DD      0

;44 BYTES
IMG_NAME       DB      'FILE GENERATED FROM PCPAINT   '
IMG_HEIGHT     DW      0
IMG_WIDTH      DW      0
IMG_WIDTH_BYTE DW      0
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

PIC_PAGE       DW      1234H		       ;START OF PAGE
PIC_WIDTH      DW      0		       ;WIDTH OF IMAGE
PIC_HEIGHT     DW      0		       ;HEIGHT OF IMAGE
PIC_X_OFF      DW      0		       ;X OFFSET OF PIC
PIC_Y_OFF      DW      0		       ;Y OFFSET OF PIC
PIC_PIX_SIZE   DB      1		       ;SIZE OF PEL
PIC_2	       DB      0FFH		       ;PCPAINT 2.0
PIC_MODE       DB      'G'                     ;TYPE OF DISPLAY
PIC_DESC       DW      0		       ;DESCRIPTOR
PIC_COUNT      DW      0		       ;COUNT
PIC_BLOCK      DW      1		       ;NUMBER OF PACKED BLOCKS

PIC_PAC_SZ     DW      0		       ;NUMBER OF PACKED BYTES IN BLOCK
PIC_NORM       DW      0		       ;NUMBER OF BYTES UNPACKED
PIC_ID	       DB      0		       ;IDENTIFIER

EIGHT	       DW      8

TELL_HOW       DB      'Ŀ',cr,lf
	       DB      ' PIC2GMI filename.typ                         ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' filename = PC-Paint Plus filename            ',cr,lf
	       DB      ' typ      = must end in PIC                   ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' Converts PIC file to reverse IMG file (GMI)  ',cr,lf
	       DB      ' (top scan line on bottom)                    ',cr,lf
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'file not found...must end in PIC',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
;ͻ
;  MAIN.ASM  
;ͼ
MAIN	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
	       CLD
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN900		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       CMP     AL,'.'                  ;START OF TYPE
	       JNE     GFN200		       ;
	       MOV     CS:TYPE_FROM,DI	       ;START OF TYPE
GFN200:
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE ALREADY
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
	       CMP     WORD PTR CS:TYPE_FROM,0 ;
	       JNE     SET_BREAK
	       DEC     DI
	       MOV     CS:TYPE_FROM,DI
;Ŀ
;	       TURN BREAK KEY ON					       
;
SET_BREAK:
	       MOV     AX,CS		       ;SET DATA SEGMENT
	       MOV     DS,AX		       ;
	       CALL    BREAK_ON 	       ;SET UP CONTROL BREAK
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       ADD     BX,8		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
;Ŀ
;	       CHECK  FILENAME						       
;
	       MOV     SI,OFFSET PIC	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       AND     BYTE PTR [DI],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+1],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+2],0DFH		;MAKE CAPITOL LETTER
	       REP     CMPSB		       ;
	       JNE     OIF050
;Ŀ
;	       OPEN INPUT FILE						       
;
	       MOV     AH,3DH		       ;OPEN FILE FOR READ
	       MOV     AL,0H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       CHANGE FILENAME						       
;
	       MOV     SI,OFFSET IMG	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     MOVSB		       ;
;Ŀ
;	       CREATE OUTPUT TEMP FILE					       
;
	       MOV     AH,3CH		       ;
	       MOV     CX,20H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     COF100
	       MOV     DX,OFFSET CREATE_ERROR  ;
	       JMP     ERROR
COF100:
	       MOV     HANDLE_OUT,AX
;Ŀ
;	       READ PIC HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,19
	       MOV     DX,OFFSET PIC_PAGE
	       INT     21H
;Ŀ
;	       TRANSLATE TO IMG HEADER					       
;
	       MOV     AX,PIC_HEIGHT	       ;GET PIC HEIGHT
	       MOV     IMG_HEIGHT,AX	       ;MOV TO IMG HEIGHT
	       MOV     AX,PIC_WIDTH	       ;GET PIC WIDTH
	       MOV     IMG_WIDTH,AX	       ;MOV TO IMG WIDTH
	       XOR     DX,DX
	       DIV     EIGHT
	       CMP     DX,0
	       JE      TT100
	       INC     AX
TT100:
	       MOV     IMG_WIDTH_BYTE,AX       ;
;Ŀ
;	       WRITE IMG HEADER 					       
;
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,44
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       MOVE PICTURE DATA BETWEEN FILES				       
;
READ_BLOCK:
	       CALL    PROCESS_PAC
	       DEC     PIC_BLOCK
	       JZ      CLOSE_FILE
	       JMP     READ_BLOCK
;Ŀ
;	       CLOSE FILES						       
;
CLOSE_FILE:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     BX,HANDLE_OUT	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;

	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       CALL    BREAK_OFF	       ;BREAK KEY RESET
	       RET			       ;
MAIN	       ENDP

;ͻ
;  PROCESS PACKET  
;ͼ
PROCESS_PAC    PROC    NEAR

	       CALL    READ_PAC_HDR
	       CALL    READ_PAC
	       CALL    EXPAND_PAC
	       CALL    IMG_WRITE
	       RET

PROCESS_PAC    ENDP
;ͻ
;  READ_PAC_HEADER  
;ͼ
;Ŀ
;	       READ 5 BYTE PACKET HEADER				       
;
READ_PAC_HDR   PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
					       ;
	       MOV     AH,3FH		       ;
	       MOV     BX,HANDLE_IN	       ;
	       MOV     CX,5		       ;
	       MOV     DX,OFFSET PIC_PAC_SZ    ;
	       INT     21H		       ;
					       ;
	       POP     DX		       ;RESTORE REGISTERS
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET

READ_PAC_HDR   ENDP
;ͻ
;  READ PACKET  
;ͼ
;Ŀ
;	       READ PACKET						       
;
READ_PAC       PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DS
					       ;
	       MOV     AH,3FH		       ;
	       MOV     BX,HANDLE_IN	       ;
	       MOV     CX,PIC_PAC_SZ	       ;
	       SUB     CX,5		       ;NO NEED TO READ HEADER
	       LDS     DX,DISK_BUFFER	       ;
	       INT     21H		       ;
					       ;
	       POP     DS
	       POP     DX		       ;RESTORE REGISTERS
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET

READ_PAC       ENDP
;ͻ
;  EXPAND PACKET  
;ͼ
;Ŀ
;	       UNCOMPRESS PACKET					       
;
EXPAND_PAC     PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DI		       ;
	       PUSH    SI		       ;
	       PUSH    DS		       ;
	       PUSH    ES		       ;

	       MOV     BX,PIC_PAC_SZ
	       SUB     BX,5		       ;SUBTRACT HEADER
	       LES     DI,DISK_BUFFER	       ;
	       ADD     DI,8000H 	       ;
	       LDS     SI,DISK_BUFFER	       ;
EP100:
	       LODSB
	       CMP     AL,CS:PIC_ID	       ;START OF RUN?
	       JNE     EP700
	       LODSB
	       CMP     AL,0		       ;16 BIT VALUE?
	       JNE     EP400		       ;NO...BRANCH
	       LODSW			       ;GET WORD COUNT
	       MOV     CX,AX		       ;SETUP COUNT REGISTER
	       LODSB			       ;GET DATA
	       REP     STOSB		       ;
	       JMP     SHORT EP800
EP400:
	       MOV     CL,AL		       ;GET COUNT
	       XOR     CH,CH		       ;
	       LODSB			       ;GET CHARACTER TO REPEAT
	       REP     STOSB		       ;REPEAT CHARACTER
	       JMP     SHORT EP800	       ;EXIT
EP700:
	       STOSB			       ;STORE SINGLE CHARACTER
EP800:
	       CMP     SI,BX
	       JNE     EP100		       ;

	       POP     ES		       ;RESTORE REGISTERS
	       POP     DS		       ;
	       POP     SI		       ;
	       POP     DI		       ;
	       POP     DX		       ;
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET

EXPAND_PAC     ENDP
;ͻ
;  IMAGE WRITE  
;ͼ
;Ŀ
;	       WRITE IMAGE FILE 					       
;
IMG_WRITE      PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DS

	       MOV     AH,40H		       ;
	       MOV     BX,HANDLE_OUT	       ;
	       MOV     CX,PIC_NORM	       ;
	       LDS     DX,DISK_BUFFER	       ;
	       ADD     DX,8000H
	       INT     21H		       ;

	       POP     DS
	       POP     DX		       ;RESTORE REGISTERS
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET

IMG_WRITE      ENDP
;Ŀ
;
EOI	      EQU      20H		      ;END OF INTERRUPT
BRKINT	      EQU      1BH		      ;BREAK INTERRUPT
SAV_BRK       DW       ?
;ͻ
;  BREAK_ON  
;ͼ
	      PUBLIC   BREAK_ON
BREAK_ON      PROC     NEAR
	      PUSH     AX
	      PUSH     BX		       ;SAVE REGISTERS
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     SI		       ;
	      PUSH     ES		       ;

	      XOR      BX,BX		       ;SEGMENT 0
	      MOV      ES,BX		       ;
	      MOV      SI,BRKINT*4	       ;OFFSET OF INTERUPT VECTOR

	      MOV      CX,ES:WORD PTR[SI]      ;OFFSET OF CURRENT VECT
	      MOV      DX,ES:WORD PTR[SI+2]    ;SEGMENT OF CURRENT VECT
	      MOV      CS:SAV_BRK,CX	       ;SAVE OFFSET
	      MOV      CS:SAV_BRK+2,DX	       ;SAVE SEGMENT

	      MOV      AX,OFFSET BREAK	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[SI],AX      ;SET OFFSET
	      MOV      AX,CS		       ;SET THIS CODE SEGMENT
	      MOV      ES:WORD PTR[SI+2],AX    ;MOVE SEG ADDR TO INT.VECT
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;RESTORE REGISTERS
	      POP      SI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      BX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_ON      ENDP
;ͻ
;  BREAK_OFF  
;ͼ
	      PUBLIC   BREAK_OFF
BREAK_OFF     PROC     NEAR

	      PUSH     AX		       ;
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     DI		       ;
	      PUSH     ES		       ;

	      XOR      AX,AX		       ;
	      MOV      ES,AX		       ;SEGMENT 0
	      MOV      CX,CS:SAV_BRK	       ;RESET VECTOR BACK TO OLD RTN
	      MOV      DX,CS:SAV_BRK+2	       ;
	      MOV      DI,BRKINT*4	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[DI],CX      ;
	      MOV      ES:WORD PTR[DI+2],DX    ;
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;
	      POP      DI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_OFF     ENDP
;ͻ
;  BREAK   J
;ͼ
	      PUBLIC   BREAK
BREAK	      PROC     FAR

	      MOV      AX,CS
	      MOV      DS,AX
	      MOV      AL,EOI		       ;
	      OUT      020H,AL		       ;
	      CALL     BREAK_OFF
	      MOV      SP,OFFSET STACK-4       ;
	      RET

BREAK	      ENDP
;Ŀ
;
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
CSEG	       ENDS
	       END     MAIN
