@%BYLINE = by <R>
Mark Scaramella
A common problem encountered in using Ventura Publisher involves the 
use of data from Lotus or dBASE in Ventura. While Ventura handles 
a useful range of word processor format options, it does not automatically 
handle importing or exporting Lotus and dBASE III+ file formats.
@%SUBHEAD 1 =  The Options
There are three basic ways to address this situation:
@%CHECK MARK =  
@%CHECK TEXT = Buy a commercial utility which will convert the Lotus/dBASE 
files, or
@%CHECK MARK = 
@%CHECK TEXT = Take some time to learn more about how you can use 
Lotus, dBASE, your word processor, Ventura features and/or other programs 
and utilities to convert the data for Publishing yourself, or
@%CHECK MARK = 
@%CHECK TEXT = A combination of the two.

Which way you choose depends on the format that your data is starting 
from, how much data you want to convert, how frequently you need to 
convert it, how much time you have for the conversion, and, of course, 
the ever-present bugaboo, budgetary considerations.
@%SUBHEAD 1 = Commercial Utilities
While I do not own DBXL (a dBASE III+ clone), I was surprised to read 
recently that the latest release of DBXL has a built-in Ventura export 
facility. If you don't own it either, and you don't mind paying for 
a solution, there are a number of well-advertised utilities available 
for file conversion from spreadsheets and database formats. Not being 
an owner of any of them, I am not well qualified to comment on them. 
I have no doubt that they do what they say they will do, but will 
leave their review to others. 
My only problem with the commercial utilities in general is that they 
may not suit your situation exactly. As a rule, the more you know 
about how to do the conversion yourself, the more options you have 
for customization and flexibility.
@%SUBHEAD 1 = Typical Situations
In general, the database and spreadsheet data which people want to 
transfer to Ventura is usually a list of of one kind or another. A 
spreadsheet's row and column format is representative. If the data 
elements or columns are short and narrow (such as Name, Address, City, 
State, Zip Code, etc.;) up to say 30 characters per data element, 
you can usually separate the columns or fields of data in Ventura 
with tabs. If one or more of the data elements consists of long text 
elements (notes, product descriptions, etc.) then you may want the 
fields/columns individually tagged so that you can apply vertical 
rules (or vertical tabs) and constrain the text to certain columns 
on the finished page

@%SUBHEAD 1 = Personal Preferences
I will admit to a certain personal bias against spread-sheets in general, 
and Lotus in particular. While I do acknowledge that dBASE and similar 
database programs can be daunting to many new computer users, my experience 
is that spreadsheets are too often used for <169>lists.<170> If you 
find yourself using a spreadsheet for a list application, you are 
likely to bump your head at some point on the limitations it imposes 
as your list becomes large<197>particularly, if you are trying to 
handle a variety of related but separate data elements. In addition, 
somethings that are to do in a database program require you to jump-through 
hoops in spreadsheets for example, getting to the spot you want to 
change, or producing reports with sub-totals.
In my opinion, Lotus has received some deserved bad raps associated 
with lingering copy-protection, vaporware, and excessive upgrade pricing, 
which have led me to look elsewhere for spreadsheet applications. 
At this point, I would recommend Borland's Quattro as the best buy. 
It's cost-effective (actually its street price is in the same range 
as some of the Ventura utilities), better than Lotus in every respect 
I know of, and, given my database leanings, also has a slick built-in 
dBASE file conversion scheme.  With it,  converting to/from a data-base 
file format is an option when saving or loading <197> no separate 
utilities are needed.
I recommend that you take the time to get more familiar with the database 
world if you are dealing with a significant amount of data and relatively 
frequent conversions to Ventura.
If you don't have a database program now, your choice of database 
applications depends on what you are doing, what your background and 
skills are, and how much time you have. Check the <MI>PC Magazine 
<D>database reviews in the past for starters.  Try the local library 
if you don't have them. For simple, straightforward list applications 
there are the so-called <169>flat-file managers.<170> Then there are 
the <169>relational<170> systems which fall into two groups: dBASE 
compatible and non-dBASE compatible. Don't forget to consider the 
Shareware options like PC file and WAMPUM, a menu-driven dBASE derivative. 
As an experienced database user, I prefer and recommend FoxBase+ <197> 
it's an order of magnitude faster than dBASE, about half the price, 
and still retains all of the advantages of being a <169>standard.<170> 
There are ample books, utilities, user-groups, etc. available, similar 
to the Ventura phenomenon. Consideration should also be given to dBXL, 
VP-Info, and the dBASE compilers, again depending on your budget and 
data processing needs.
As PC's and software mature, database programs are becoming much more 
user-friendly. You might be pleasantly surprised at how easily some 
simple lists can be handled with the current crop of database programs.
@%SUBHEAD 1 = The Issues
The issues to be addressed in converting from Lotus or dBASE are:
@%CONT'D. LEFT = continued on page 39

@%STEP # = 1.
@%STEP TEXT = Getting rid of extraneous spaces
@%STEP # = 2.
@%STEP TEXT = Inserting required tabs
@%STEP # = 3.
@%STEP TEXT = Adding Tags
@%STEP # = 4.
@%STEP TEXT = Data selection
@%STEP # = 5.
@%STEP TEXT = Ventura frame complexity
@%SUBHEAD 1 = ASCII Files
Both Lotus and dBASE allow the generation of ASCII files as output 
options. I will assume that you have a basic understanding of ASCII 
files. There are two kinds of ASCII files:

@%STEP # = 1.
@%STEP TEXT = <169>Flat<170> ASCII files: files where the data is 
defined by the column position that it is in. Spaces are everywhere 
in this kind of file.
@%STEP # = 2.
@%STEP TEXT = <169>Comma-separated<170> ASCII files (sometimes called 
<169>Comma-delimited<170> or <169>Quote/Comma-delimited<170>

The data in a flat file is in columns. Data in a comma-separated file 
is, wouldn't you know, conveniently separated by commas or some other 
separator character. Sometimes the data in a comma-separated file 
also is enclosed in quotes to distinguish between commas as separators 
or commas as data.
Figure 1 shows a typical name and address data file with data elements.  In 
databases, data elements are called fields, whereas in a spreadsheet 
they are usually called columns.
Without the column headings, this data would be in a <169>flat<170> 
ASCII file format.
Comma-separated format is shown in Figure 2 and variations of the 
quote/comma separated format follow in Figures 3 and 4. 
You'll notice that the comma-separated formats and some quote/comma 
delimited formats have no extraneous spaces. If your application supports 
it, the comma-separated ASCII file output is the easiest to process 
with your word processor for Ventura. If all of the data will fit 
on one Ventura line, just globally replace the , or the <169>,<170> 
with a tab; remove the first and last quote, if applicable; and tag 
the lines with your tags.
Figure 5 shows the results following the global tab replacement. In 
this WordStar example the ^ is used to show the tab character<197>how 
it looks in your word processor may vary.
Next, add a tag as illustrated in Figure 6.
If you need multiple lines per record as in more complex tables, or 
if your data won't fit on one line, you'll have to tag some or all 
of the individual data elements or fields and use vertical rules/spacing 
(In From Left/ In From Right) features to generate your output.
Figure 7 shows what your tagged output might look like. You could 
use your word processor or, if you have dBASE III+/FoxBASE+, you could 
use a public domain dBASE Program I wrote, called DB2VP,  or a commercial 
utility. Whether you use a utility or not, it's still a good idea 
to see what this format looks like, since you may want to create it 
from scratch rather than use a database for simple, one-time applications.
In my opinion, since it uses  less line elements and gives more page 
composition options than tabbed lines, this is a preferred format 
for Ventura. 
@%SUBHEAD 1 = Form Letters
I occasionally get requests to do custom form letters using the high 
quality output of Ventura. Usually, they hand me a dBASE file with 
some names and addresses and either a Multimate or MicroSoft Word 
text file. I then get to figure out how to bring them together with 
Ventura quality. I'm sure there are several ways to approach this, 
but here's the method I came up with<197>Insert trial runs and proofs 
at approriate spots:<R>

@%STEP # = 1.
@%STEP TEXT = Bring the form letter into Ventura and set it up as 
a single letter leaving the name and address (or other variable data) 
blank.
@%STEP # =  2.
@%CHECK TEXT = Print an original <169>master<170> and...<R>

@%STEP TEXT = Make enough high quality copies for the mailing with 
a copier or,
@%STEP TEXT = Select enough copies from Ventura's print menu.
@%STEP # = 3.
@%STEP TEXT = Convert the dBASE file using my own (now public domain 
utility) to a pre-tagged ASCII file.
@%STEP # = 4.
@%STEP TEXT = Add a page break tag between each name/address with 
global search and replace.
@%STEP # = 5.
@%STEP TEXT = Bring the tagged name/address file into Ventura and 
set spacing and alignment to fit into master letter name/address space.
@%STEP # = 6.
@%STEP TEXT = Run the copies of the master through the Printer again 
to print the names and addresses or other variable data on the copies 
of the master letter.
@%SUBHEAD 1 = DB2VP.PRG
As mentioned, my attempts to work <169>smarter, not harder,<170> I 
recently wrote and submitted to the public domain, a dBASE program 
which automatically generates tagged or tabbed output. It has a small 
.DOC file which accompanies it and is simple to use. It requires dBASE 
or a compatible program to run it. VPUG has placed this DB2VP.PRG 
program file on the <MI>Ventura Professional! Forum<D> bulletin board 
system for users to download. 
@%SUBHEAD 1 = Spreadsheet Conversions to Ventura
I tried a few things with Lotus on a friend's computer. His version 
of Lotus has a translate utility which translates to <169>DIF<170> 
format among other things. There was no flat ASCII file conversion 
option and no comma delimited format option. The DIF format produced 
a file with each column on its own line and all the trailing spaces 
intact to fill up the width of the column. This DIF format would at 
best be <169>DIF<170>-icult to hand massage with a word processor 
into Ventura-ready format. You can print to disk with Lotus which 
would create an image of your spreadsheet in flat ASCII file format. 
The flat ASCII format has all those darned spaces and is another format 
which is difficult to make ready for Ventura. I can see why there 
is a market for the conversion utilities for Lotus.
If I had to convert a Lotus file to Ventura today, I would use Quattro. 
After loading the file, next I would save it as a .DBF file from within 
Quattro. Then, depending on the complexity of the data and the format, 
use dBASE and my DB2VP.PRG dBASE conversion program to generate a 
tagged output ASCII file for Ventura.
@%SUBHEAD 1 = Future Articles
In future articles, we'll go into more depth about how the DB2VP.PRG 
program works and what dBASE features can be exploited to prepare 
dBASE data for Ventura. 
@%END MARK = 

