**********************************************************************
* Program Name.........: DB2VP.PRG
* Purpose..............: dBASE to Ventura conversion utility
* Author...............: MARK C. SCARAMELLA
* Version..............: 1.01 updated to remove FoxBase unique
*                        fields() function.
*
* ====================================================================
* Copyright Notice.....: Copyright (C) 1988, Mark C. Scaramella
*                                            All rights reserved
*                        Released to the Public Domain
*                        Not for resale without the explicit permission
*                        of the author.  Modifications for personal
*                        use are authorized and encouraged.
*                        Please notify author of any improvements or
*                        fixes implemented or requested at:
*
*                          Mark C. Scaramella
*                      c/o ESD Corporation
*                          600 Meridian Ave.
*                          San Jose, CA  95126
*
*                        If you like this program and find it helpful and
*                        you would like to contribute to its "growth and
*                        development", a donation of $20.00 to the above
*                        address would be appreciated.
* =======================================================================
*
* Date................: 12/06/86
* Version.............: 1.1
* Requires............: dBASE III+, FoxBase+ or dBXL.
* Revisions...........: Removed FoxBase+ only feature: fields()
* Updates under consideration:
* - optional case conversion

set talk off
set dele on
set bell off
clos all
clea
stor space(30) to mdbname,moutfile,mindex
stor ' ' to mtabtag
@ 2,1 say '             **************************** DB2VP *************************'
@ 3,1 say '             A file conversion utility for sending data from dBASE format'
@ 4,1 say '                                 to Ventura Publisher.'
@ 5,1 say '                         by Mark Scaramella.  Copyright (c) 1988'
stor .f. to mok

do while .not. mok
@ 8,2 say 'Database file name.....: ' get mdbname pict '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
@ 9,2 say 'Index file name........: ' get mindex pict '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
@ 10,2 say 'Output File Name.......: ' get moutfile pict '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
@ 8,60 say '(blank to exit)'
@ 9,60 say '(Optional)'
@ 10,60 say '(default ext: .txt)'
@ 11,2 say '(T)abs or (F)ield tags?: ' get mtabtag pict '!'
@ 12,2 say '(Memo and logical fields not supported/processed.)'
read
if mdbname=' '.or.moutfile=' '
 clos all
 set talk on
 cancel
endif
sele a
stor trim(mdbname)+'.dbf' to mdbtest
if .not. file('&mdbtest')
 @ 18,1 say '*** Database File Name not found ***'
 loop
else
 @ 18,0
 if mindex=' '
  stor .t. to mok
 endif
endif
if mindex#' '
 *foxbase version
 stor trim(mindex)+'.idx' to mitest1
 *dbase version
 stor trim(mindex)+'.ndx' to mitest2
 if .not. (file('&mitest1').or.file('&mitest2'))
  @ 18,1 say '*** Index File Name not found ***'
 else
  @ 18,0
  stor .t. to mok
 endif
endif

enddo

use &mdbname
set safe off
copy stru exte to strutemp
set safe on
*stor fcount() to fields
sele b
use strutemp
GO BOTT
STOR RECNO() TO FIELDS
GO TOP
stor 1 to fno
do while .not. eof()
 stor ltrim(str(fno,2)) to fnostr
 stor field_type to mtype&fnostr
 if field_type='N'
  stor ltrim(str(field_len,3)) to mlen&fnostr
  stor ltrim(str(field_dec,4)) to mdec&fnostr
 endif
 skip
 stor fno+1 to fno
enddo
sele a
if mindex#' '
 set inde to &mindex
endif
set alte to &moutfile

if mtabtag='F'
stor 1 to counter
set alte on
do while .not. eof()
 do while counter<=fields
  stor ltrim(str(counter,2)) to cstr
  stor field(counter) to mfield
  do case
  case mtype&cstr='C'
   ? '@'+mfield+' = '+ltrim(trim(&mfield))
  case mtype&cstr='D'
   ? '@'+mfield+' = '+dtoc(&mfield)
  case mtype&cstr='N'
   if val(mdec&cstr) = 0
    stor mlen&cstr to lenstr
    ? '@'+mfield+' = '+ltrim(str(&mfield,&lenstr))
   else
    stor mlen&cstr to lenstr
    stor mdec&cstr to decstr
    ? '@'+mfield+' = '+ltrim(str(&mfield,&lenstr,&decstr))
   endif
  otherwise
   set alte off
   ? '***',mfield,'field type not supported...'
   set alte on
  endcase
  stor counter+1 to counter
 enddo
 stor 1 to counter
 skip
enddo

else

*tabs
stor space(12) to mtagname
@ 11,35 say 'Tag Name: ' get mtagname pict '!!!!!!!!!!!!'
read
stor trim(mtagname) to mtagname
stor chr(9) to tab
stor 1 to counter
set alte on
do while .not. eof()
 do while counter<=fields
  stor ltrim(str(counter,2)) to cstr
  stor field(counter) to mfield
  do case
  case mtype&cstr='C'
   if counter=1
    ? '@&mtagname = '+ltrim(trim(&mfield))
   else
    ?? tab+ltrim(trim(&mfield))
   endif
  case mtype&cstr='D'
   if counter=1
    ? '@&mtagname = '+dtoc(&mfield)
   else
    ?? tab+dtoc(&mfield)
   endif
  case mtype&cstr='N'
   if counter=1
    if val(mdec&cstr) = 0
     stor mlen&cstr to lenstr
     ? '@&mtagname = '+ltrim(str(&mfield,&lenstr))
    else
     stor mlen&cstr to lenstr
     stor mdec&cstr to decstr
     ? '@&mtagname = '+ltrim(str(&mfield,&lenstr,&decstr))
    endif
   else
    if val(mdec&cstr) = 0
     stor mlen&cstr to lenstr
     ?? tab+ltrim(str(&mfield,&lenstr))
    else
     stor mlen&cstr to lenstr
     stor mdec&cstr to decstr
     ?? tab+ltrim(str(&mfield,&lenstr,&decstr))
    endif
   endif
  otherwise
   set alte off
   ? '***',mfield,'field type not supported...'
   set alte on
  endcase
  stor counter+1 to counter
 enddo
 stor 1 to counter
 skip
enddo

endif

set alte off
clos alte
set talk on
set safe on
?
? 'File conversion complete....'
set dele off
cancel
