/*
**	WSWAP - Select lines to include/exclude from file
**
**	Try compiling with Microsoft C versions 5.1 or above.
**		qcl /DMSDOS wswap.c /c
**		link /stack:10000 wswap+\msc51\lib\binmode /NOE;
**	DISCLAIMER: The code may not be elegant, but it does the job.
**
**
**	Modification History
**	1.0	01-Aug-94	Steve Karra
*/

#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <io.h>
#include <string.h>

#define  TSWAP        "SWAP"
#define  TEND         "END"
#define  TDEFAULT     "DEFAULT"
#define  PLUS         '+'
#define  MINUS        '-'
#define  STAR         '*'
#define  BELL         '\007'
#define  CMDLEN       256
#define  MAXLINE      256
#define  MAXFN        64
#define  NTOKENS      32
#define  TOKLEN       16
#define  TTYPE        token[NTOKENS-1]
#define  TSELECT      token[NTOKENS-2]


static char *Version="WSWAP Version 1.0 (written by Steve Karra)";
char  token[NTOKENS][TOKLEN];
char  swapstr[TOKLEN];
char  remarkstr[TOKLEN], remarkstr2[TOKLEN];
char  *fn;


abortpgm(n,str)
int  n;
char *str;
{
	printf("File: %s\n", fn);
	switch(n) {
	    case(1):	printf("EOF Reached with no END statement\n");
			break;
	    case(2):	printf("Line: %s", str);
			printf("Maximum of %d tokens exceeded\n",(NTOKENS-2));
			break;
	    case(3):	printf("Line: %s", str);
			printf("END missing to previous selection\n");
			break;
	    case(4):	printf("Cannot delete original file [%s]\n", str);
			break;
	    case(5):	printf("Cannot rename temp file [%s] to original deleted file\n", str);
			break;
	    case(6):	printf("Cannot copy temp file [%s] to original\n", str);
			break;
	    default:	break;
	    }
	printf("Hit any key to continue ...");
	do {} while (!kbhit());
	while (kbhit()) getch();
	exit(-1);
}


gettokens(line)
char *line;
{
    int  i;
    char *cstr, *ch;

    for (i=0; i<(NTOKENS-2); i++) token[i][0]='\0';
    ch=&line[strlen(swapstr)];  i=0;

    do {
    	cstr=&token[i][0];
    	while (*ch==' ') ch++;
    	while ((*ch!=' ')&&(*ch!='\0')&&(*ch!='\n')&&(*ch!='\r')) *(cstr++)=*(ch++);
	*cstr='\0';  i++;
	if (i>=(NTOKENS-2)) abortpgm(2);
    } while ((*ch!='\0')&&(*ch!='\n')&&(*ch!='\r'));
}



main ( argc, argv )
int   argc;
char  *argv[];
{
    FILE  *ifptr, *ofptr;
    char  nf[MAXFN], line[MAXLINE], nline[MAXLINE], cmd[CMDLEN], *ch, *nch;
    int   onematch, match, pflag=0, mflag=0, sflag=0;
    int   remark, notfirst, endf, i, ifil;


    if (argc < 4) {
	fprintf(stderr,"%s\n", Version);
	fprintf(stderr,"%cUsage: %s TYPE SELECTION File_List\n", BELL, argv[0]);
	fprintf(stderr,"       File_List can optionally be prefixed with +,- or *\n");
	exit(-1);
	}


    strcpy(TTYPE,argv[1]);
    strcpy(TSELECT,argv[2]);

    for (ifil=3; ifil<argc; ifil++) {
	tmpnam(nf);	/* will be created on current drive */
	if (pflag=(*argv[ifil]==PLUS)) argv[ifil]++;
	else if (mflag=(*argv[ifil]==MINUS)) argv[ifil]++;
	else if (sflag=(*argv[ifil]==STAR)) argv[ifil]++;
	fn=argv[ifil];

        if (((ifptr=fopen(argv[ifil],"r")) == NULL) ||
                ((ofptr=fopen(nf,"w")) == NULL)) {
            fprintf(stderr,"%c%s: Cannot open files %s and/or %s\n",BELL, 
		argv[0], argv[ifil], nf);
            continue;
	    }

	notfirst=0;
        while (fgets(line, MAXLINE, ifptr) != NULL) {

	    if (!notfirst) {
		strcpy(remarkstr, line);
		ch = remarkstr;
		while ((*ch!='\0')&&(*ch!='\n')&&(*ch!='\r')) ch++;
		*ch = '\0';
		strcpy(remarkstr2, remarkstr);
		strcat(remarkstr," ");
		strcat(remarkstr2,"\011");
		strcpy(swapstr, remarkstr);
		strcat(swapstr, TSWAP);
		notfirst++;
		}

	    /* Reading ordinary lines - just copy to output if not SWAP */
            if (strncmp(line,swapstr,strlen(swapstr))==0) {

		/* Now we have to check if its a valid TYPE - if not just copy to output */
                gettokens(line);
                if (strcmp(token[0],TTYPE)==0) {

		    /* Its a match - now we loop until END.  Will check SELECT etc */
		    match=0;  onematch=0;

                    do {
		        /* If its the right type, uncomment, else comment */
			if (strncmp(line,swapstr,strlen(swapstr))==0) { /* special line */
			    gettokens(line);
			    if (!sflag) fputs(line, ofptr);
			    /* First check if a change */
                	    if (strcmp(token[0],TTYPE)==0) {
			        match=0;  endf=0;  i=0;
			        while ((!match)&&(i<(NTOKENS-2))&&(strlen(token[i])>0)) {
			    	    if (strcmp(token[i],TEND)==0) {
					endf++;
					break;
					}
			            if (strcmp(token[i],TSELECT)==0) match++,onematch++;
			            else if ((strcmp(token[i],TDEFAULT)==0)&&(!onematch)) match++;
			            else match=0;
				    i++;
			            }
				if (endf) break;
			        }
			    else abortpgm(3,line);
			    }
			else {  /* not special - ordinary line */
			    /* check for REM<space> and REM<tab> */
			    remark = ((strncmp(line,remarkstr,strlen(remarkstr))==0)||
				(strncmp(line,remarkstr2,strlen(remarkstr2))==0));
			    if ((!match) && (mflag)) {  /* don't touch */
				ch = &line[0];
				}
			    else if ((match) && (!mflag)) { /* include these ones */
				ch = (remark)?&line[strlen(remarkstr)]:&line[0];
				}
			    else {  /* don't include these */
				ch = &line[0];
				if ((!remark)&&(!pflag)&&(!sflag)) fprintf(ofptr, "%s", remarkstr);
			        }
			    if ( (!match) && (sflag) ) ;
			    else fputs(ch, ofptr);
			    }

                        if (fgets(line, MAXLINE, ifptr)==NULL) abortpgm(1,"\0");
                        } while (!feof(ifptr));
		    if (feof(ifptr)) abortpgm(1,"\0");
                    }
                else fputs(line, ofptr);  /* not a valid token so just copy */
                /* else if (!sflag) fputs(line, ofptr);  not a valid token so just copy */
                }
	    else fputs(line, ofptr);
            }

        fclose(ifptr);
        fclose(ofptr);

	/* We used to remove and rename, but now copy and remove */
	/* Changed because tmp files cannot be renamed across drives */
	strcpy(cmd,"copy ");  strcat(cmd,nf);  strcat(cmd," ");
	strcat(cmd,argv[ifil]);  strcat(cmd," /V > NUL:");
	if (system(cmd)) abortpgm(6,nf);
	if (remove(nf)!=0) abortpgm(4,nf);
/*
**	if (remove(argv[ifil])!=0) abortpgm(4,argv[ifil]);
**	if (rename(nf,argv[ifil])!=0) abortpgm(5,nf);
*/
    }

    exit(0);
}
