// Copyright(c) 1993 MARTZ Computing. All rights reserved.

#ifndef __PRINTER_H
#define __PRINTER_H

#include <owl.h>
#include <print.h>
#include <commdlg.h>

//Printer Library verison number (same style as Windows own GetVersion()
extern "C" DWORD WINAPI _export PrinterGetVersion(void);

//Centers a window to the screen
extern "C" void  WINAPI _export CenterWindow(HWND HWindow);

typedef struct tagAbortData {
  char Document[30];
  char PageCount[30];
  char Device[30];
  char Output[30];
} AbortData;

// Watch for virtual functions and modify them.
// When creating the object create it with the
// "new" operator because TPrinter->Print() will
// use the operator "delete" to remove the object
// after the report is complete.
_CLASSDEF(TReport)
class _EXPORT TReport {
  public:
  TReport();
  virtual ~TReport();

  //Change when reclassed, example: "TMyReport"
  virtual LPSTR getClassName()
     { return "TReport"; }

  private:
  HFONT hFont;
  HFONT hFontOld;

  protected:
  //Available to access if required to
  HDC  hDC;
  //Draws a rectangle (fills with current brush
  BOOL Rectangle(RECT rect);
  BOOL Rectangle(int l, int t, int r, int b);
  //Draws a box (rectangle) without filling
  BOOL Box(RECT rect);
  BOOL Box(int l, int t, int r, int b);
  //Draws a line from point to point
  BOOL Line(POINT start, POINT stop);
  BOOL Line(int l, int t, int r, int b);
  //Draws Text same as ExtTextOut()
  BOOL Text(LPSTR text, POINT start, RECT rect, UINT option);
  //Draws Text same as DrawText()
  BOOL Text(LPSTR text, RECT rect, UINT option);
  //Draws Text same as TextOut()
  BOOL Text(LPSTR text, int left, int top);
  //Draws a circle based on rectangle
  BOOL Circle(RECT rect);
  BOOL Circle(int l, int t, int r, int b);
  //Paints a bitmap to the current page
  BOOL Bitmap(HBITMAP hBitmap, POINT start, DWORD dwRop);
  //Paints an icon to the current page
  BOOL Icon(HICON hIcon, POINT start);

  //Resets font to default
  void Font();
  //Changes current font to settings after reseting to default font
  void Font(LOGFONT *pLogFont);
  //Changes current font to settings after reseting to default font
  void Font(int nHeight, int nWidth, int nEscapement,
            int nOrientation, int nWeight, BYTE bItalic,
            BYTE bUnderline, BYTE cStrikeOut, BYTE nCharSet,
            BYTE nOutPrecision, BYTE nClipPrecision,
            BYTE nQuality, BYTE nPitchAndFamily,
            LPCSTR lpszFaceName);

  //Gives the printable page dimentions
  RECT PageSize (BOOL Logical);//logical or device coodinates?
  //Gives the paper size dimentions 
  RECT PaperSize(BOOL Logical);//logical or device coodinates?
  //Call often to confirm all is okay
  BOOL isAborted();
  //Call if required to
  void AbortDoc();
  //same as Windows SetMapMode
  int SetMapMode(int fnMapMode);

  public:
  //Update Meter Control (0% - 100%)
  void UpdateMeter(WORD Percent);

  //Do not call directly, Called by TPrinter
  //PreSets PrintDlg Fields (example: pd.flags |= PD_SELECTION;)
  virtual void setDefaults(PRINTDLG *pd);

  //Called by TPrinter before and after DRAW() is called
  virtual void PreDraw(PRINTDLG *pd);     //before
  virtual void PostDraw(BOOL isCancelled);//after

  //return TRUE if NewPage, FALSE if EndDoc
  //if Page = 0 then print *selection*
  virtual BOOL Draw(WORD Page);
};


_CLASSDEF(TAbortDlg)
class _EXPORT TAbortDlg : public TDialog {
  public:
  TAbortDlg(PTWindowsObject AParent, Pvoid Data, PTModule AModule);
  virtual void SetupWindow();
  virtual void Cancel(RTMessage) = [ID_FIRST + IDCANCEL];
};


_CLASSDEF(TPrinter)
class _EXPORT TPrinter {
  public:
  TPrinter(PTWindowsObject AParent);
  virtual ~TPrinter();
  virtual LPSTR getClassName()
     { return "TPrinter"; }

  protected:
  AbortData ad;
  DOCINFO   di;
  PRINTDLG  pd;
  PTWindowsObject Parent;
  PTReport        Report;
  virtual WORD MessageBox(LPSTR Title, LPSTR Comment, UINT Style);
  virtual void UpdateDlg(WORD nPage);
  static  BOOL CALLBACK AbortProc(HDC hdcPrn, int nCode);

  public:
  static PTAbortDlg abortDialog;

  //Shows the setup Dialog
  void   Setup();
  //Prints report class to selected printer.
  //The class pointer aReport is automatically
  //deleted when it is not needed anymore.
  //example: printer->print(new TMyReport(),"MyReport : by me");
  //This example does NOT require to delete TMyReport,
  //it is already done (just like TDialog).
  BOOL   Print  (PTReport aReport, LPSTR DocName);
  //Not Completed at this time...
  BOOL   Preview(PTReport aReport, LPSTR DocName);

  protected:
  BOOL  QueryAbort();
  BOOL  BeginPrint();
  BOOL  EndPrint();
  DWORD ErrorHandler();
};

#endif