// *********************************************** //
// DBSERVER.C: Program to manage the flow of the
// messages to the listbox.
// *********************************************** //

#include <windows.h>
#include "DBSERVER.H"
#include "DBPUTS.H"
#include "string.h"

HANDLE hInst;
HWND    hDbLog = (HWND) NULL;

int PASCAL WinMain(
HANDLE hi,
HANDLE hPrevi,
LPSTR lpCmdLine,
int nCmdShow )
{
        MSG msg;

        if (!hPrevi)
        if (!MkClass(hi))
                return (FALSE);

        if (!MkWindow(hi, nCmdShow))
                 return (FALSE);

        while (GetMessage(&msg,
                NULL,
                NULL,
                NULL))
        {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
        }
        return (msg.wParam);
}

BOOL MkClass(
HANDLE hi)
{
        WNDCLASS  wc;

        wc.style = NULL;
        wc.lpfnWndProc = DbMessageServer;
        wc.cbClsExtra = 0;
        wc.cbWndExtra = 0;
        wc.hInstance = hi;
        wc.hIcon = LoadIcon(hi, (LPSTR) "DBSERVERIcon");
        wc.hCursor = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground = GetStockObject(WHITE_BRUSH);
        wc.lpszMenuName =  "DBSERVERMenu";
        wc.lpszClassName = "DBSERVERClass";

        return (RegisterClass(&wc));
}

BOOL MkWindow(
HANDLE  hi,
int             nCmdShow)
{
        HWND    hWnd;
        hInst = hi;
        hWnd = CreateWindow(
                 "DBSERVERClass",
                 "DbServer",
                 WS_OVERLAPPEDWINDOW,
                 CW_USEDEFAULT,
                 CW_USEDEFAULT,
                 200,                                   // CX
                 150,                                   // CY
                 NULL,
                 NULL,
                 hi,
                 NULL
        );

        if (!hWnd)
                 return (FALSE);

        ShowWindow(hWnd, nCmdShow);
        UpdateWindow(hWnd);
        return (TRUE);
}

long FAR PASCAL DbMessageServer(
HWND hWnd,
WORD message,
WORD wP,
LONG lP)
{
        FARPROC lpAbout;

        switch (message)
        {
        case WM_COMMAND:
                switch(wP)
                {
                case MSG_ABOUT:
                        lpAbout = MakeProcInstance(About, hInst);

                        DialogBox(hInst,
                                "AboutBox",
                                hWnd,
                                lpAbout);

                        FreeProcInstance(lpAbout);
                        break;

                case MSG_SIG1:
                {
                        char buf[81];
      int cItems;

                        GlobalGetAtomName((ATOM) lP,
                                buf, 80);
                        GlobalDeleteAtom((ATOM) lP);
                        SendMessage(hDbLog, LB_ADDSTRING,
                                0, (LONG) &buf[0]);
                        cItems = SendMessage(hDbLog,
                                LB_GETCOUNT,0, 0);
                        SendMessage(hDbLog, LB_SETCURSEL,
                                (WPARAM)cItems-1,0);
                        }
                        break;

                case MSG_CLEARIT:
                        SendMessage(hDbLog, LB_RESETCONTENT,
                                        0, 0L);
                        break;
                case MSG_CHECKDLL:
                        CheckDLL();
                        break;

                default:
                        return (DefWindowProc(hWnd, message, wP, lP));
                }
                break;

        case WM_DESTROY:
                PostQuitMessage(0);
                break;

        case WM_CREATE:
        {
                HWND hWndResult;

                hWndResult = SetHandle(hWnd);

                if(hWndResult != hWnd)
                        {
                        MessageBox(hWnd,
                                (LPSTR) "Could not register handle",
                                (LPSTR) "DBSERVER Error",
                                MB_OK | MB_ICONHAND);
                        DestroyWindow(hWnd);
                        }
                hDbLog = CreateWindow(
                        "listbox", "DbPuts.DLL",
                        WS_CHILD | WS_VISIBLE |
                        WS_VSCROLL | LBS_NOTIFY,
                        0,0,100,100, hWnd, NULL,
                        hInst, NULL);

                AlignListbox(hWnd,hDbLog);
                DbPuts("DbServer started.");
                }
                break;

        case WM_SIZE:
       AlignListbox(hWnd,hDbLog);
             break;
        default:
                return (DefWindowProc(hWnd, message, wP, lP));
        }
        return (NULL);
}

BOOL FAR PASCAL About(
HWND hDlg,
unsigned message,
WORD wP,
LONG lP)
{
        switch (message) {
        case WM_INITDIALOG:
                return (TRUE);

        case WM_COMMAND:
                if (wP == IDOK
                                        || wP == IDCANCEL) {
                EndDialog(hDlg, TRUE);
                return (TRUE);
                }
                break;
        }
        return (FALSE);
}

void AlignListbox(
HWND hWnd,
HWND hListbox)
{
RECT rectWnd,rectWndClient,rectListbox;
int frame,diff;
char buf[80];

GetWindowRect(hWnd,&rectWnd);
GetClientRect(hWnd,&rectWndClient);
GetWindowRect(hListbox,&rectListbox);

MoveWindow(hListbox,0,0,
        rectWndClient.right,rectWndClient.bottom,TRUE);
GetWindowRect(hListbox,&rectListbox);
diff = rectWnd.bottom - rectListbox.bottom;

frame = GetSystemMetrics(SM_CYFRAME);

if (diff > frame)
  MoveWindow(hWnd,rectWnd.left,rectWnd.top,
                rectWnd.right-rectWnd.left,
                rectWnd.bottom-rectWnd.top-diff+frame,TRUE);
}
