AutoDoc v3.70 
Listing of D:\example.wk1, File Date:07/10/88 11:28:22                                                                                                                                            Page 1
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Record count report
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
          Report on record types in D:\example.wk1
          ----------------------------------------

          Records by type, length in Kbytes and % of total

             Range records:    0   length:   0.0K   0.0%
              Text records:   38   length:   0.6K  20.1%
           Numeric records:   16   length:   0.2K   7.6%
           Formula records:   24   length:   0.7K  25.2%
             Blank records:    2   length:   0.0K   0.6%
                        Total data length:   1.6K  53.4%
                                 Overhead:   1.4K

                        Total file length:   3.0K

Note: "Overhead" includes any window, graphics and data base settings

-----------------------------------------------------------------------

The following report lists the first 200 characters found in each
spreadsheet row and ALL of the formula in each row in equation format.  

As data and text are found they are listed with the cell location range
indicated in the left hand margin, but in the correct column on the page.

For each row of a repeated formula an equation is constructed that would 
compute the row values using the indicated formula.  The name of the
variable being computed is taken from the leading text in the row.  The variable 
names in the equation are taken in the same way from any other rows referenced.
Standard 1-2-3 formulae are translated into a standard algebraic format,
with the notation [t] refering to the current cell location.

The first and last cell in the equation range are indicated in the last 
line of the equation.  The ACTUAL values shown in the worksheet are 
also listed on the same line.

Finally a range listing and a variable Xref listing are appended at the end
together with a simple set of instructions for customization.

AutoDoc v3.70 
Listing of D:\example.wk1, File Date:07/10/88 11:28:22                                                                                                                                            Page 2
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Cell Range     |A       |B       |C       |D       |E       |F       |G       |H       |I       |J       |K       |L       |M       |N       |O       |P       |Q       |R       |S       |T       |U       
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
HA1..C1         Example
HA3             Expenditures
HA4..F4         ;;       Jan      Feb      Mar      April    Total
HA5..F5         apples   2.400000 3.900000 5.600000 7.500000 18.9000000

G               apples:5[t] = $apples:20[t] * apples:13[t] 
                 = <<2.4 to 18.9>>, for t = Jan to Total, at B5..F5

HA6..F6         oranges  5.200000 8.400000 13.50000 6.400000 33.3500000

G               oranges:6[t] = $oranges:21[t] * oranges:14[t] 
                 = <<5.2 to 33.35>>, for t = Jan to Total, at B6..F6

HB7..F7         
HA8..F8         Total    7.600000 12.30000 19.10000 13.90000 52.2500000

G               Total:8[t] = SUM( apples:5[t]..oranges:6[t] )  
                 = <<7.6 to 52.25>>, for t = Jan to Total, at B8..F8

HA11            Quantities
HB12..F12                Jan      Feb      Mar      April    Total
HA13..F13       apples   2        3        4        5        14.0000000

G               apples:13[t] = SUM( apples:13[t-4]..apples:13[t-1] )  
                 = <<14.>>, for t = Total, at F13

HA14..F14       oranges  4        6        9        4        23.0000000

G               oranges:14[t] = SUM( oranges:14[t-4]..oranges:14[t-1] )  
                 = <<23.>>, for t = Total, at F14

HB15..F15       
HA16..F16       Total    6.000000 9.000000 13.00000 9.000000 37.0000000

G               Total:16[t] = SUM( apples:13[t]..oranges:14[t] )  
                 = <<6. to 37.>>, for t = Jan to Total, at B16..F16

HA18            Prices
HB19..F19                Jan      Feb      Mar      April    Total
HA20..F20       $apples  1.200000 1.300000 1.400000 1.500000 1.3500000

G               $apples:20[t] = @AVG( $apples:20[t-4]..$apples:20[t-1] )  
                 = <<1.35>>, for t = Total, at F20

HA21..F21       $oranges 1.300000 1.400000 1.500000 1.600000 1.4500000

G               $oranges:21[t] = @AVG( $oranges:21[t-4]..$oranges:21[t-1] )  
                 = <<1.45>>, for t = Total, at F21

AutoDoc v3.70 
Listing of D:\example.wk1, File Date:07/10/88 11:28:22                                                                                                                                            Page 3
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Range Names And Definitions In D:\example.wk1
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
AutoDoc v3.70 
Listing of D:\example.wk1, File Date:07/10/88 11:28:22                                                                                                                                            Page 4
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Index Of Row Names[1..15] (And Which Rows Referenced Them) In D:\example.wk1
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

           apples:5|    8
          apples:13|    5   13   16
         oranges:14|    6   14
         $apples:20|    5   20
        $oranges:21|    6   21AutoDoc v3.70 
Listing of D:\example.wk1, File Date:07/10/88 11:28:22                                                                                                                                            Page 5
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Cell Range     |A       |B       |C       |D       |E       |F       |G       |H       |I       |J       |K       |L       |M       |N       |O       |P       |Q       |R       |S       |T       |U       
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
AutoDoc v3.70 
Listing of D:\example.wk1, File Date:07/10/88 11:28:22                                                                                                                                            Page 6
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Explanation and customizing AutoDoc v3.70 
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

                Automated Documentation Of Spreadsheet Equations
                ------------------------------------------------

                                       by

                      Copyright (c) 1988, John D. Pearson


Have you ever wondered why spreadsheets have to be so @DA..  @DIFF..  to read.
Commercial "cell" listings help but so far they do not translate the structure
of the spreadsheet back into english.  This program tries a different tack.

It assumes that your spreadsheet follows a convention that rows correspond to
variables and columns to time periods like so:

               A         B         C         D         E
     1
     2         ;;           Jan       Feb       Mar       Apr
     3         apples         1         2         0         3
     4         oranges       22        44       -10       100
     5         -----     ------    ------    ------    ------
     6         Total     +B3+B4    +C3+C4    +D3+D4    +E3+E4

The example shows a very simple spreadsheet.  Apart from the data it has one
repeated formula in the cell range A6..E6.  Commercial cell listing programs
repeat this formula in every cell as shown.  AutoDoc treats this as an equation.

To AutoDoc an equation is simply a cell formula that is repeated for two or more
cells in a row.  In the example above the equation in range A6..E6 defines the
"total" as the sum of the "apples" and "oranges" for each of the periods "Jan"
to "Apr".

AutoDoc recovers the equations from the spreadsheet and displays the equation in
the context of the text and data as follows.

Cell Range     |A        |B        |C        |D        |E
---------------------------------------------------------------
     A2..E2    ;;        Jan       Feb       Mar       Apr
     A3..E3    apples    1         2         0         3
     A4..E4    oranges   22        44        -10       100
     A5..E5    -----     -----     -----     -----     -----

               Total[t] = apples[t] + oranges[t]
                 = <<23..103>>, for t = Jan to Apr in B6 to E6

     A6        Total     23        46        -10       103

Now this may appear to be trivial (and it is), however take a more complicated
situation with many equations with forward and backward references and this
simple idea makes a complex spreadsheet very readable.

AutoDoc generates an ASCII output file like the above which contains the
following:

         The first column shows the range of cells in the
         rows that contain entries since only one page width
         of text/data will be displayed. (Up to 255 characters)

         The remaining columns contain the entries as they
         might appear on the screen but left justified in
         each column width.

         All equations found are summarized as above with
         [t] referring to the current cell "time period" and
         <<23..103>> provides the first and last values
         computed using the equation.  The cell range shows
         where they are in the spreadsheet row even if not displayed

You may customize the names by adding a column and rows(s) of sensible
abbreviations then add markers ;; as above to show which row contains the
current column headers and which column contains sensible variable names.

If you do not make any changes to your spreadsheet then AutoDoc will construct
variable names from the leading text in each row, but the column headers will be
the usual 1-2-3 headers.  A..IV.  AutoDoc generates proper names that do not
contain algebraic operator symbols (+-/).  If nothing is provided then surrogate
row names are invented Row:236 etc.  Even this can be helpful.

AutoDoc appends a listing of the ranges found and a simple unsorted listing of
the references to each of the variable names or rows.

Absolute row and column references are flagged as in 1-2-3 using the $ sign.  An
absolute column reference will be [$D] while an absolute row reference will
appear as row:232:$[$D].  If range names are defined then AutoDoc uses these in
the equation listing in upper case.

Operation And Screen Output
---------------------------

To use AutoDoc you will need this program and an IBM compatible running with PC
or MS-DOS, then type:

AUTODOC  [input [output]]

at the DOS prompt, with [ ] meaning optional.  (Do not type the [] symbols).
The INPUT and OUTPUT files may be fully qualified drive\path\name specifications
with .WK1 default on input and .FOR on output.

It takes no other parameters.  If neither INPUT nor OUTPUT are given then
AUTODOC is entirely menu driven.  A configuration file is automatically written
to the source drive for each use and is read for the default options next time.

For example if you have a file test.wk1 on c:\123\data and your AUTODOC.EXE file
is in a utility directory c:\utils then type:

c:
cd c:\123\data
c:\utils\autodoc

-- and you will be prompted for everything else by the menus including the
format options available for the formula file output.  The resulting
configuration file will be written back to "c:\utils\autodoc.cnf".

The help key F1 and the file choice keys F9 and F10 provide a range of available
choices for each option in most cases which try to be self explanatory.  Try
experimenting on the test example to get a feel for the programs capability.

After providing the file to be listed and approving the output format, AUTODOC
will read the file once to identify all usable row and column names.  Next it
re-reads the file and generates the equation listing on an auxiliary file with
extension .FOR.  At the same time a video MAP is displayed showing the first 55
columns of the spreadsheet.  You may also list this map as one of the options.

The MAP display flags in color and highlights changes in row structure along
each row.  This may show a formula that has been miscopied along a row.  Each
break in the row is independently listed to the formula file and should be
examined.  Most users are so entranced with the marching screen display that
they do not notice the errors.  The MAP list reports the changes by capitalizing
the cell type symbols.

Limitations of this program:
----------------------------
Comments on the current version (3.5) of AutoDoc:

AutoDoc ONLY thrives on spreadsheets that follow the variable/time convention
described above.  On all others it will generate more paper than insight since
every cell may becomes a fresh equation.

It is designed to fully process rows 1..1001 of Lotus 1-2-3 version 2 files.
Further rows 1002..  are processed without any ;; names but otherwise everything
else continues.  First time users with an arbitrary spreadsheet are advised to
turn on "variable names" and "row numbers" as configuration options.

If you have insufficient memory then on large spreadsheets or with a large
number of range names you may encounter a "heap over-flow" error.  Memory used
to be cheap..buy some.

It does NOT automatically check and correct for duplicate variable names, macro
text or range names used out of context.  New 1-2-3 or @addin functions will
appear as "@unknown_function" and cause that formula to be truncated but the
listing continues.

Be warned that absolute row or column references can be VERY misleading.  If
duplicate names are used then key references will appear to be the same unless
the option "add row numbers to names" is used.

The popular LIST.COM program by Vernon Buerg and available on most bulletin
boards, is an excellent way to peruse the output file and selectively print
pages.

------------------------------------------------------------------------------
Finally this is a simple but powerful interpretative program.  It is your
responsibility to review the output carefully and to base any conclusions
derived from the results solely upon your own judgement.  If in doubt check a
1-2-3 cell listing.

While every effort has been made to ensure that the program is bug-free on a
turbo XT and on a COMPAQ 386, there are almost certainly situations and PC
configurations that AutoDoc has not encountered and in which it may not function
correctly.
------------------------------------------------------------------------------

Updates
-------
AutoDoc is copyrighted by the author and distributed "as-is" for comment and
personal use only.  It is not placed in the public domain.  You are encouraged
to try it and circulate it with this file attached.  If you find it useful or
for an updated version of this program with documentation write to:

     Dr. John D. Pearson,
     2007 Franklin Avenue,
     McLean Va. 22101.

and enclose $15 to cover expenses.  Suggestions for improvements are welcome.


This file supercedes version 2.1 called AD21.ARC (version 3.6 9/1/88.)

It is automatically appended to the .FOR output file as long as it is
on the source path to AUTODOC.EXE

