IBM ASCII characters for Lotus 123 Release 2 (and Symphony).
------------------------------------------------------------

     It seems that Lotus is having many problems with public 
acceptance of the new Release 2 version of 123.  Symphony has 
also had problems in gaining market acceptance compared to the 
original 123.  I like to call this the "Classic Coke Syndrome", 
after my favorite of all drinks, Coca Cola (version 1.0)!  Once 
we get used to the way things work in 123 version 1a, they go and 
change it on us!  Actually the new release is very good, and has 
several features that have been a long time in coming for Lotus, 
whereas several other spreadsheet programs have these features 
for quite some time (ie. text values).  If you are contemplating 
the upgrade to release 2, you really don't have much choice in 
the matter.  Version 1a has been discontinued and is no longer 
available, so it is really pointless to ask IF we should upgrade, 
the question is not IF, but WHEN!  

     There are a few problems one encounters when converting 
spreadsheets built in the 1a version to release 2.  These 
problems and some work-arounds are discussed in Lotus magazine in 
the March 1986 issue, and for the most part we can make 
adjustments to our worksheets to allow them to work in release 2 
just as they did in 1a.  

     There is, however, one substantial change in release 2 that 
has no normal fix, but is something that many people have come to 
use.  This is the (undocumented) use of the IBM EXTENDED ASCII 
character set in 123.  I have used these characters to draw lines 
and boxes, among other things, in my lotus worksheets for the 
purpose of appearance.  They rroook mahvelous!  In release 2 they 
are translated upon load to look like garbage.  This I cannot 
live with.  

     Investigation of the problem turns up the fact that Lotus 
has completely re-defined the ASCII character set that IBM has so 
carefully laid out.  They call this new character set the Lotus 
International Character Set (LICS).  Just when most of the 
software and accessory hardware such as printers are accepting 
the IBM EXTENDED ASCII character set as the defacto standard, 
Lotus comes along and thinks they can just re-define it at will!  
Lotus Corp. offers absolutely no help with this problem since our 
use of these characters was "undocumented" in version 1a.  

     Thankfully it turns out that the problem can be fixed with a 
little "corrective surgery" to our 123 release 2 program.  As a 
matter of fact there is no inherent reason for the lack of the 
IBM character set in 123, other than the inflexibility of Lotus 
Development Corp.  This "fix" falls into the same category as 
being able to select the colors that Lotus products use on the 
display, that is Lotus could have very easily had an install 
option allowing us to select colors, (as well as the character 
set), but for some unknown reason (that I would love to know!), 
they do not provide these options.  As a matter of fact, the 
"corrective surgery" described here is a direct violation of the 
123 License agreement (the same for patching colors, and removal 
of copy protection), and while I am not a lawyer, I think this 
means that they could take action.  So, I have just paid $495 for 
a program that I have to modify in order for it to work as it 
SHOULD, and such modifications make me a CRIMINAL in the eyes of 
Lotus!  HA!  What a JOKE!! (maybe the joke is really on me, after 
all I'm the one who PAID for the privilege!)  Well, I will take 
my chances, you can do what you want!

     What follows is an explanation of exactly how to patch 123 
Release 2 to allow use of the IBM EXTENDED ASCII character set.  
This requires use of the DOS debug program, and the ability to 
follow instructions.  The patch is fairly simple, but requires 
that you accurately type the replacement values.  If you make a 
mistake, simply quit and restart the sequence of instructions 
from the beginning.  Anything entered by you is shown here in 
lower case, the debug responses are in upper case.  On some lines 
I have placed comments which are preceded by a semicolon, do not 
type these comments.  I use the debug search command "s" to 
locate the items to patch in the file. The locations shown here 
are for my 123.set and will most likely be different in yours.  
You will use the numbers that debug tells you.  These 
instructions will function with Symphony just as well as they do 
for 123.

STEP 1.) ----- Make a bakup of your 123.set file.

C>copy 123.set old123.set
        1 File(s) copied

STEP 2.) ----- Enter the debug program with the original file.

C>debug 123.set

STEP 3.) ----- At the debug prompt "-", type this command to 
               search for the beginning of the extended LICS 
               table.  Debug will respond with something like 
               xxxx:nnnn, we will use the nnnn part in the next 
               command.  Depending upon exactly which screen 
               driver set you selected when you installed Lotus, 
               you may find more than one location reported in 
               the search.  This is because some of the drivers 
               work for a two monitor system, and the universal 
               driver is designed to work on both the IBM 
               Monochrome Adapter and the Color Graphics Adapter 
               as well as function on a Compaq which emulates 
               both of these cards.  Lotus will use a different 
               internal table for each of the displays.  If your 
               search reports more than one location, simply 
               repeat STEP 4 for each location where the table is 
               found.

-s 0 l 0 60 27 5e 22 7e fe         ; find the translation
1105:2CDB                          ;  table.

STEP 4.) ----- Enter the edit "e" command and the location 
               reported by the previous search command above.  
               Debug will respond with the location address and 
               the first byte value.  Here we are going to type 
               the ENTIRE extended ascii character set in 
               hexadecimal.  This is 128 total bytes and you must 
               not make a mistake in any one!!  After the period 
               "." type the first value 80 followed by a space.  
               Do not hit the return key.  The next value will 
               appear, after the period type 81 and another 
               space.  Continue typing numbers and spaces until 
               the entire table is entered.  After the "ff" value 
               is entered, you will hit the return key.  Repeat 
               this step for each of the locations reported by 
               the search command above.  It will look something 
               like this (the location address may be different):

-e 2cdb                            
1105:2CDB  60.80   27.81   5E.82   22.83   7E.84
1105:2CE0  FE.85   FE.86   FE.87   FE.88   FE.89   FE.8a   FE.8b   FE.8c
1105:2CE8  FE.8d   FE.8e   FE.8f   60.90   27.91   5E.92   22.93   7E.94
1105:2CF0  69.95   5F.96   1E.97   1F.98   FE.99   F9.9a   11.9b   FE.9c
1105:2CF8  FE.9d   FE.9e   FE.9f   9F.a0   AD.a1   9B.a2   9C.a3   22.a4
1105:2D00  9D.a5   9E.a6   15.a7   0F.a8   63.a9   A6.aa   AE.ab   7F.ac
1105:2D08  E3.ad   F2.ae   F6.af   F8.b0   F1.b1   FD.b2   33.b3   22.b4
1105:2D10  E6.b5   14.b6   F9.b7   54.b8   31.b9   A7.ba   AF.bb   AC.bc
1105:2D18  AB.bd   F3.be   A8.bf   41.c0   41.c1   41.c2   41.c3   8E.c4
1105:2D20  8F.c5   92.c6   80.c7   90.c8   45.c9   45.ca   45.cb   49.cc
1105:2D28  49.cd   49.ce   49.cf   44.d0   A5.d1   4F.d2   4F.d3   4F.d4
1105:2D30  4F.d5   99.d6   4F.d7   30.d8   55.d9   55.da   55.db   9A.dc
1105:2D38  59.dd   50.de   E1.df   85.e0   A0.e1   83.e2   61.e3   84.e4
1105:2D40  86.e5   91.e6   87.e7   8A.e8   82.e9   88.ea   89.eb   8D.ec
1105:2D48  A1.ed   8C.ee   8B.ef   64.f0   A4.f1   95.f2   A2.f3   93.f4
1105:2D50  6F.f5   94.f6   6F.f7   ED.f8   97.f9   A3.fa   96.fb   81.fc
1105:2D58  98.fd   70.fe   FE.ff

STEP 5.) ----- Now we will enable a new feature, this is the 
               ability for 123 to read EXTENDED ASCII characters 
               from a text file on disk with the "\FI" File 
               Import command.  This command always decremented 
               the value of any character with a value higher 
               than 128 by 128 in version 1a, and Release 2 
               normally does the same thing.  We will patch out 
               the subtraction and subsequent translation of the 
               EXTENDED ASCII characters to normal ascii.  First 
               search for the location of the subtraction and 
               translation, note the location that debug reports.

-s 0 l 0 2c 80 d7 5b 1f            ; find the subtraction and
1105:57C1                          ;  subsequent translation.

STEP 6.) ----- Enter the assemble command "a" and the location 
               reported by the previous search above.  Enter the 
               subtract command shown, hit return, and enter the 
               nop (no operation) instruction on the next line.  
               Hit return twice to enter the line, and exit the 
               assemble command.  Remember the exact locations 
               will probably be different in your file.  It will 
               look like this:

-a 57c1
1105:57C1 sub al,00           ; set subtraction value to 0  
1105:57C3 nop                 ; disable translation
1105:57C4

STEP 7.) ----- We are done!  Save the results with the write 
               command "w".

-w
Writing 9816 bytes            ; the number of bytes may differ

STEP 8.) ----- Quit debug with the quit command "q".

-q

     THAT'S IT!!  Run 123 and enjoy your newfound capabilities.  

     You can now enter any of the IBM EXTENDED ASCII characters 
in several ways: 

1.) -- By retrieving them with "/FR" assuming they already exist 
       in a worksheet file.

2.) -- By using the @char(x) function where "x" is the decimal 
       number of the character desired.

3.) -- By using the "/FI" function to import the characters from 
       any ASCII text file containing them.

     You can keep the OLD123.SET file if you wish for bakup 
reasons, or just in case you want to go back to an unmodified 
setup.  If you have any questions or problems, you can contact 
me, Scott Mueller at:

MUELLER BUSINESS SYSTEMS
1059 E. Plate Drive
Palatine, IL 60067
(312) 359-0558

