program algetrig;

{$N+,E+,Q+,S+,R+,I-,O-,F+,P+,T-,X-,V-,B+,A-,G-,D-,L-,Y-}

(* compiled in Borland Turbo Pascal 7.0 for DOS *)

uses crt,drivers;

label tryagain, next, oops, dec, done;

var
entry,sine,cosine,tangent,cotangent,secant,cosecant,radians,degrees,
grads,common_log,natural_log:extended;

answer:boolean;

decimal,count:integer;

logfile,docfile:text;

filename:string;

reply,dummy:char;


procedure beep;

begin
sound(988);
delay(200);
nosound;
end;

procedure typo;

begin
textcolor(12);
writeln;
writeln(' You entered a non-number typo.');
beep;
textcolor(15);
end;

procedure finish;

begin
WriteLn(logfile);
if count = 1 then
writeln (logfile,'You made ', count, ' entry.')
else
writeln (logfile,'You made ', count, ' entries.');
writeln(logfile,'_______________________________________________________________________________');
end;

procedure undefined;

begin
textcolor(12);
writeln;
writeln(' Logarithms of numbers not greater than zero do not exist.');
textcolor(15);
end;

procedure core_sin;

begin
case reply of
'D','d':sine:=sin(entry*(pi/180));
'R','r':sine:=sin(entry);
'G','g':sine:=sin((entry*(pi/2)*0.01));
end;
end;

procedure core_cos;

begin
case reply of
'D','d':cosine:=cos(entry*(pi/180));
'R','r':cosine:=cos(entry);
'G','g':cosine:=cos((entry*(pi/2)*0.01));
end;
end;


procedure sin_;

label start,oops,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: SINE');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Make the entry in degrees, radians, or grads?  Or to exit, just press Enter.');
write(' (D/R/G) >  ');
if not eoln(input) then
readln(reply)
else goto done;
case reply of
'D','d':goto oops;
'R','r':goto oops;
'G','g':goto oops;
else goto start;
end;
oops:
reset(input);
writeln;
writeln(' Sine: Press Enter on a blank line to exit.');
write(' Enter your number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto oops;
end;
count:=count+1;
core_sin;
writeln;
writeln(' The sine of ',entry:1:decimal,' ',upcase(reply),'''s');
writeln(' is ',sine:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The sine of ',entry:1:decimal,' ',upcase(reply),'''s ');
writeln(logfile,'is ',sine:1:decimal);
end;
goto start;
done:
if answer = true then
finish;
end;


procedure cos_;

label start,oops,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: COSINE');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Make the entry in degrees, radians, or grads?  Or to exit, just press Enter.');
write(' (D/R/G) >  ');
if not eoln(input) then
readln(reply)
else goto done;
case reply of
'D','d':goto oops;
'R','r':goto oops;
'G','g':goto oops;
else goto start;
end;
oops:
reset(input);
writeln;
writeln(' Cosine: Press Enter on a blank line to exit.');
write(' Enter your number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto oops;
end;
count:=count+1;
core_cos;
writeln;
writeln(' The cosine of ',entry:1:decimal,' ',upcase(reply),'''s');
writeln(' is ',cosine:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The cosine of ',entry:1:decimal,' ',upcase(reply),'''s ');
writeln(logfile,'is ',cosine:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;


procedure tan_;

label start,oops,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: TANGENT');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Make the entry in degrees, radians, or grads?  Or to exit, just press Enter.');
write(' (D/R/G) >  ');
if not eoln(input) then
readln(reply)
else goto done;
case reply of
'D','d':goto oops;
'R','r':goto oops;
'G','g':goto oops;
else goto start;
end;
oops:
reset(input);
writeln;
writeln(' Tangent: Press Enter on a blank line to exit.');
write(' Enter your number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto oops;
end;
count:=count+1;
core_cos;
if (cosine < 0.00000000000000001) and (cosine > -0.00000000000000001) then
begin
writeln;
writeln(' The tangent of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The tangent of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
end;
goto start;
end;
core_sin;
tangent:=sine/cosine;
if (tangent < 0) and (tangent > -0.000000000000000001) then
tangent := 0;
writeln;
writeln(' The tangent of ',entry:1:decimal,' ',upcase(reply),'''s');
writeln(' is ',tangent:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The tangent of ',entry:1:decimal,' ',upcase(reply),'''s ');
writeln(logfile,'is ',tangent:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;


procedure cot_;

label start,oops,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: COTANGENT');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Make the entry in degrees, radians, or grads?  Or to exit, just press Enter.');
write(' (D/R/G) >  ');
if not eoln(input) then
readln(reply)
else goto done;
case reply of
'D','d':goto oops;
'R','r':goto oops;
'G','g':goto oops;
else goto start;
end;
oops:
reset(input);
writeln;
writeln(' CoTangent: Press Enter on a blank line to exit.');
write(' Enter your number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto oops;
end;
count:=count+1;
core_sin;
if (sine < 0.00000000000000001) and (sine > -0.00000000000000001) then
begin
writeln;
writeln(' The cotangent of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The cotangent of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
end;
goto start;
end;
core_cos;
cotangent:=cosine/sine;
writeln;
writeln(' The cotangent of ',entry:1:decimal,' ',upcase(reply),'''s');
writeln(' is ',cotangent:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The cotangent of ',entry:1:decimal,' ',upcase(reply),'''s ');
writeln(logfile,'is ',cotangent:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;


procedure sec_;

label start,oops,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: SECANT');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Make the entry in degrees, radians, or grads?  Or to exit, just press Enter.');
write(' (D/R/G) >  ');
if not eoln(input) then
readln(reply)
else goto done;
case reply of
'D','d':goto oops;
'R','r':goto oops;
'G','g':goto oops;
else goto start;
end;
oops:
reset(input);
writeln;
writeln(' Secant: Press Enter on a blank line to exit.');
write(' Enter your number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto oops;
end;
count:=count+1;
core_cos;
if (cosine < 0.00000000000000001) and (cosine > -0.00000000000000001) then
begin
writeln;
writeln(' The secant of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The secant of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
end;
goto start;
end;
secant:=1/cosine;
writeln;
writeln(' The secant of ',entry:1:decimal,' ',upcase(reply),'''s');
writeln(' is ',secant:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The secant of ',entry:1:decimal,' ',upcase(reply),'''s ');
writeln(logfile,'is ',secant:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;


procedure csc_;

label start,oops,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: COSECANT');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Make the entry in degrees, radians, or grads?  Or to exit, just press Enter.');
write(' (D/R/G) >  ');
if not eoln(input) then
readln(reply)
else goto done;
case reply of
'D','d':goto oops;
'R','r':goto oops;
'G','g':goto oops;
else goto start;
end;
oops:
reset(input);
writeln;
writeln(' CoSecant: Press Enter on a blank line to exit.');
write(' Enter your number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto oops;
end;
count:=count+1;
core_sin;
if (sine < 0.00000000000000001) and (sine > -0.00000000000000001) then
begin
writeln;
writeln(' The cosecant of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The cosecant of ',entry:1:decimal,' ',upcase(reply),'''s is undefined.');
end;
goto start;
end;
cosecant:=1/sine;
writeln;
writeln(' The cosecant of ',entry:1:decimal,' ',upcase(reply),'''s');
writeln(' is ',cosecant:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The cosecant of ',entry:1:decimal,' ',upcase(reply),'''s ');
writeln(logfile,'is ',cosecant:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;


procedure r_to_d;

label start,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: RADIANS  TO DEGREES and GRADS');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Press Enter on a blank line to exit.');
write(' Enter radians >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto start;
end;
count:=count+1;
degrees:=entry*(180/pi);
grads:=entry*(200/pi);
writeln;
writeln(' That equals ',degrees:1:decimal,' degrees,');
writeln;
writeln(' and that equals ',grads:1:decimal,' grads.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,entry:1:decimal,' radians');
writeln(logfile,'equals ',degrees:1:decimal,' degrees,');
writeln(logfile,'and it equals ',grads:1:decimal,' grads.');
end;
goto start;
done:
if answer=true then
finish;
end;


procedure d_to_r;

label start,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: DEGREES  TO RADIANS AND GRADS');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Press Enter on a blank line to exit.');
write(' Enter degrees >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto start;
end;
count:=count+1;
radians:=entry*(pi/180);
grads:=radians*(200/pi);
writeln;
writeln(' That equals ',radians:1:decimal,' radians,');
writeln;
writeln(' and that equals ',grads:1:decimal,' grads.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,entry:1:decimal,' degrees');
writeln(logfile,'equals ',radians:1:decimal,' radians,');
writeln(logfile,'and it equals ',grads:1:decimal,' grads.');
end;
goto start;
done:
if answer=true then
finish;
end;


procedure g_to_r;

label start,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: GRADS  TO RADIANS AND DEGREES');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Press Enter on a blank line to exit.');
write(' Enter grads >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto start;
end;
count:=count+1;
radians:=entry*(pi/200);
degrees:=radians*(180/pi);
writeln;
writeln(' That equals ',radians:1:decimal,' radians,');
writeln;
writeln(' and that equals ',degrees:1:decimal,' degrees.');
if answer=true then
begin
writeln(logfile);
writeln(logfile,entry:1:decimal,' degrees');
writeln(logfile,'equals ',radians:1:decimal,' radians,');
writeln(logfile,'and it equals ',degrees:1:decimal,' degrees.');
end;
goto start;
done:
if answer=true then
finish;
end;


procedure natural;

label start,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: NATURAL LOG');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Press Enter on a blank line to exit.');
write(' Enter the number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto start;
end;
if entry <= 0 then
begin
undefined;
beep;
goto start;
end;
count:=count+1;
natural_log:=ln(entry);
writeln;
writeln(' The natural log of ',entry:1:decimal);
writeln(' is ',natural_log:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The natural log of ',entry:1:decimal);
writeln(logfile,'is ',natural_log:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;


procedure common;

label start,done;

begin
if answer=true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: COMMON LOG');
writeln(logfile);
end;
start:
reset(input);
writeln;
writeln(' Press Enter on a blank line to exit.');
write(' Enter the number >  ');
if not eoln(input) then
readln(entry)
else goto done;
if ioresult = 106 then
begin
typo;
goto start;
end;
if entry <= 0 then
begin
undefined;
beep;
goto start;
end;
count:=count+1;
Common_log:=Ln(entry)/ln(10);
writeln;
writeln(' The common log of ',entry:1:decimal);
writeln(' is ',common_log:1:decimal);
if answer=true then
begin
writeln(logfile);
writeln(logfile,'The common log of ',entry:1:decimal);
writeln(logfile,'is ',common_log:1:decimal);
end;
goto start;
done:
if answer=true then
finish;
end;



procedure equations;

begin
textcolor(1);
textbackground(1);
clrscr;
textcolor(14);
writeln('        opp            adj            opp     Sin                 Cos      1');
writeln(' Sin =  ,  Cos =  ,  Tan =  =  ,  and  Cot =  = ');
writeln('        hyp            hyp            adj     Cos                 Sin     Tan');
writeln;
writeln('         1                     1');
writeln(' Sec =  ,  while  Csc = ');
writeln('        Cos                   Sin');
writeln;
textcolor(15);
writeln;
write(' Identities');
textcolor(142);
writeln(':');
textcolor(14);
writeln;
writeln(' 1) Sin + Cos = 1');
writeln(' 2) 1 + Tan = Sec');
writeln(' 3) 1 + Cot = Csc');
writeln(' 4) Sin(-) = -Sin  (odd function)');
writeln(' 5) Cos(-) = Cos  (even function)');
writeln;
writeln('                                                    ');
writeln('                                                  ');
writeln(' 6) Sin   -   = Cos        7) Cos   -   = Sin ');
writeln('           2                                2       ');
writeln('                                                    ');
textcolor(13);
gotoxy(1,24);
writeln(' press Enter to return to menu...');
textcolor(1);
reset(input);
if not eoln(input) then
read(dummy)
else exit;
end;


procedure manual;

begin
donesyserror;
assign(docfile,'algetrig.doc');
rewrite(docfile);
if ioresult <> 0 then
begin
initsyserror;
textcolor(1);
textbackground(1);
clrscr;
gotoxy(1,11);
textcolor(12);
writeln('  Sorry, I can''t use this disk drive for some reason.');
gotoxy(1,12);
writeln('  Try exiting and restarting the program. Make sure your current directory');
gotoxy(1,13);
write('  is valid, I need to write "');
textcolor(14);
write('ALGETRIG.DOC');
textcolor(12);
writeln('" to the -current- directory');
writeln('  that you run AlgeTrig within. Press Enter to return to the main menu.');
reset(input);
textcolor(1);
if not eoln(input) then
read (dummy)
else exit;
end;
clrscr;
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile,'                        AlgeTrig 1.3 by Duane Bailey');
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile,'Requires an 80286 or higher processor, 55 KB of free RAM memory, probably');
writeln(docfile,'needs DOS 2.1 or higher. I recommend a hard drive for speed in keeping a log');
writeln(docfile,'file when you choose to keep one.');
writeln(docfile);
writeln(docfile,'______________________________________________________________________________');
writeln(docfile);
writeln(docfile);
writeln(docfile,'This program can find the sine, cosine, tangent, cotangent, secant, and');
writeln(docfile,'cosecant of the angles you enter. You can give it the values in degrees,');
writeln(docfile,'radians, or grads. It also converts between the three modes. Finally, it finds');
writeln(docfile,'both natural logarithms (based on "e") and common logarithms (based on 10).');
writeln(docfile,'AlgeTrig can also keep a text log file if you wish. You choose the path and');
writeln(docfile,'name. The program is intended to be easy to use, but if you need help mail me');
writeln(docfile,'your questions. If the program is worth $8.00 bucks to you, you get my number');
writeln(docfile,'and "almost free" updates if any come along. This means I would individually');
writeln(docfile,'compute the exact price of disk and postage, and charge only that, in order to');
writeln(docfile,'break even. You will also get info on other computer creations of mine; I have');
writeln(docfile,'written 3 other programs, written a short book on science, and painted some');
writeln(docfile,'superb pictures with a mouse and some superb shareware paint programs that');
writeln(docfile,'blow Windows paintbrush totally away. (I do like Windows, but let''s face it,');
writeln(docfile,'the paint module is on a budget...)');
writeln(docfile);
writeln(docfile,'I''m writing this manual mainly with some programmers'' support in mind. I''ll go');
writeln(docfile,'into a couple algorithms.');
writeln(docfile);
writeln(docfile,'The language I''m using only provides Sine and Cosine functions; however, the');
writeln(docfile,'other four trig functions are derived from these two anyway.');
writeln(docfile);
writeln(docfile);
writeln(docfile,'        opp            adj            opp     Sin                 Cos      1');
writeln(docfile,' Sin =  ,  Cos =  ,  Tan =  =  ,  and  Cot =  = ');
writeln(docfile,'        hyp            hyp            adj     Cos                 Sin     Tan');
writeln(docfile);
writeln(docfile,'         1                     1');
writeln(docfile,' Sec =  ,  while  Csc = ');
writeln(docfile,'        Cos                   Sin');
writeln(docfile);
writeln(docfile,' Identities:');
writeln(docfile);
writeln(docfile,' 1) Sin + Cos = 1');
writeln(docfile,' 2) 1 + Tan = Sec');
writeln(docfile,' 3) 1 + Cot = Csc');
writeln(docfile,' 4) Sin(-) = -Sin  (odd function)');
writeln(docfile,' 5) Cos(-) = Cos  (even function)');
writeln(docfile);
writeln(docfile,'                   ');
writeln(docfile,'                  ');
writeln(docfile,' 6) Sin   -   = Cos ');
writeln(docfile,'           2       ');
writeln(docfile,'                   ');
writeln(docfile);
writeln(docfile,'                   ');
writeln(docfile,'                  ');
writeln(docfile,' 7) Cos   -   = Sin ');
writeln(docfile,'           2       ');
writeln(docfile,'                   ');
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile,'Always when programming I''m very careful about zero denominators. Now for');
writeln(docfile,'tangent, cotangent, secant, and cosecant, I -first- evaluate the denominator');
writeln(docfile,'in your choice of either degrees, radians, or grads. If it''s zero then I abort');
writeln(docfile,'the division and leave the appropriate message on the screen. Then I start');
writeln(docfile,'over by asking you for the next one. If the division were to be attempted, the');
writeln(docfile,'program would suddenly stop running, and you would be looking at a DOS prompt.');
writeln(docfile,'Try Tan, (C), and choose degrees. Enter 90 to see what I mean. At 90 degrees');
writeln(docfile,'the cosine is 0.');
writeln(docfile);
writeln(docfile,'If you goof and enter a letter when it''s supposed to be a number, your entry');
writeln(docfile,'is not counted. Also, in the two logarithm routines, if you enter a number');
writeln(docfile,'that is either negative or zero, your entry is not counted. But in the trig');
writeln(docfile,'functions if you get "undefined" for an answer, the entry is counted. (As');
writeln(docfile,'things rotate through multiples of 2, there are an infinite number of angles');
writeln(docfile,'that have some undefined trig function, how could you be expected to know?).');
writeln(docfile,'This information is valuable sometimes anyway. The entry is counted as valid.');
writeln(docfile);
writeln(docfile,'The logarithm routines: Well my language only provides for natural logs, that');
writeln(docfile,'is, Ln(x). To get a common log, that is, Log(x), I had to rack my brain, but I');
writeln(docfile,'figured it out. Here it is:');
writeln(docfile);
writeln(docfile,'           Ln(x)');
writeln(docfile,'Log(x) = ');
writeln(docfile,'           Ln(10)');
writeln(docfile);
writeln(docfile,'______________________________________________________________________________');
writeln(docfile);
writeln(docfile);
writeln(docfile,'The log file: It''s a "plain-Jane" ASCII text file containing your session. You');
writeln(docfile,'don''t have to keep one, but it sure could help if you had 101 problems to do');
writeln(docfile,'quickly and needed the results in concrete form right away if not sooner. You');
writeln(docfile,'can edit it as you wish, import parts of it to other programs, print it, etc.');
writeln(docfile,'.... a harried and hurried engineer''s dream!');
writeln(docfile);
writeln(docfile,'If you have any problems or bugs to report, -please- mail them to me and tell');
writeln(docfile,'me as much as you can about what went wrong. For example if your computer has');
writeln(docfile,'a math co-processor chip, tell me what brand, model number, whether SX or DX,');
writeln(docfile,'etc.... I am testing the program exhaustively but you never know, it may');
writeln(docfile,'misbehave on some particular configuration of machine. It does not require a');
writeln(docfile,'math co-processor, and one is unlikely to help, but you never know, it may try');
writeln(docfile,'to fight with some of the newer off-brand math chips.');
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile);
writeln(docfile,'Revision history:');
writeln(docfile,'1.0: Original release, project took 4 days from conception to completion.');
writeln(docfile,'1.1: Made the functions A through F easier to exit (less effort).');
writeln(docfile,'1.2: Made the calculations sections scroll, for ease of use.');
writeln(docfile,'1.3: Got rid of the stupid counter device...!  "You entered 5 numbers"');
writeln(docfile);
writeln(docfile,'Duane Bailey');
writeln(docfile,'2059 Bethabara Rd, Apt 28');
writeln(docfile,'Winston-Salem, NC 27106');
writeln(docfile);
writeln(docfile,'(910) 922-3827');
writeln(docfile);
close(docfile);
textcolor(1);
textbackground(1);
clrscr;
gotoxy(5,11);
textcolor(14);
writeln('Done! The name of the manual is "ALGETRIG.DOC" in the current directory.');
writeln;
gotoxy(5,14);
writeln('                        Press Enter to continue...');
textcolor(1);
gotoxy(1,14);
initsyserror;
reset(input);
if not eoln(input) then
readln(dummy);
end;

begin
initsyserror;
oops:
textbackground (0);
textcolor(7);
reset (input);
clrscr;
writeln;
writeln;
writeln;
write (' Want to keep a log file?  (Y/N)  ');
textcolor(14);
if not eoln (input) then
readln (reply)
else goto oops;
case reply of
'y', 'Y' : goto next;
'n', 'N' : goto dec;
else goto oops;
end;
next:
reset(input);
clrscr;
textcolor(7);
writeln;
writeln;
writeln;
writeln(' Name  your log file (use a path too if needed)');
writeln;
write(' > ');
textcolor(14);
if not eoln(input) then
begin
donesyserror;
readln (filename);
assign(logfile, filename);
rewrite(logfile);
if ioresult <> 0 then
begin
initsyserror;
textcolor(7);
clrscr;
reset(input);
gotoxy(2,12);
write('I can''t use this file: "');
textcolor(14);
write(filename);
textcolor(7);
writeln('"');
write(' ...Try naming it something else. Press Enter... ');
beep;
if not eoln(input) then
readln(reply)
else goto next;
goto next;
end;
end
else goto next;
case reply of
'y', 'Y' : answer := true;
else answer := false;
end;
Dec:
reset(input);
textcolor(7);
textbackground(0);
clrscr;
writeln;
writeln;
writeln;
writeln(' How many decimal places do you want?');
write(' (2 through 18) >  ');
textcolor(14);
if not eoln(input) then
readln(decimal)
else goto dec;
if ioresult = 106 then
goto dec;
if decimal < 2 then
goto dec;
if decimal > 18 then
goto dec;
textbackground(0);
textcolor(0);
clrscr;

delay(100);

textbackground(1);
textcolor(1);
gotoxy(1,25);
writeln('                                                                              ');
delay(40);
gotoxy(1,1);
writeln('                                                                                ');
delay(40);
gotoxy(1,24);
writeln('                                                                                ');
delay(40);
gotoxy(1,2);
writeln('                                                                                 ');
gotoxy(1,23);
writeln('                                                                               ');
delay(40);
gotoxy(1,3);
writeln('                                                                                ');
delay(40);
gotoxy(1,22);
writeln('                                                                                ');
delay(40);
gotoxy(1,4);
writeln('                                                                                ');
delay(40);
gotoxy(1,21);
writeln('                                                                                ');
delay(40);
gotoxy(1,5);
writeln('                                                                                ');
delay(40);
gotoxy(1,20);
writeln('                                                                                ');
delay(40);
gotoxy(1,6);
writeln('                                                                                ');
delay(40);
gotoxy(1,19);
writeln('                                                                                ');
delay(40);
gotoxy(1,7);
writeln('                                                                                ');
delay(40);
gotoxy(1,18);
writeln('                                                                                ');
delay(40);
gotoxy(1,8);
writeln('                                                                                ');
delay(40);
gotoxy(1,17);
writeln('                                                                                ');
delay(40);
gotoxy(1,9);
writeln('                                                                                ');
delay(40);
gotoxy(1,16);
writeln('                                                                                ');
delay(40);
gotoxy(1,10);
writeln('                                                                                ');
delay(40);
gotoxy(1,15);
writeln('                                                                                ');
delay(40);
gotoxy(1,11);
writeln('                                                                                ');
delay(40);
gotoxy(1,14);
writeln('                                                                                ');
delay(40);
gotoxy(1,12);
writeln('                                                                                ');
delay(40);
gotoxy(1,13);
textcolor(9);
writeln('                            Mission Control was here                                 ');
delay(70);

tryagain:
reset(input);
textcolor(15);
textbackground(0);
clrscr;
textbackground(1);
textcolor(15);
writeln('ͻ');
write('');
textcolor(2);
write(' ');
textcolor(13);
write('                     AlgeTrig 1.3  by Duane Bailey');
textcolor(2);
write('                       ');
textcolor(15);
writeln(' ');
writeln('                                                                             ');
writeln('                                                                             ');
writeln('                                                                             ');
writeln('  A)  Sine         { finds sine (sin) in degrees, radians, and grads }       ');
writeln('  B)  Cosine       { finds cosine (cos) in degrees, radians, and grads }     ');
writeln('  C)  Tangent      { finds tangent (tan) in degrees, radians, and grads }    ');
writeln('  D)  CoTangent    { finds cotangent (cot) in degrees, radians, and grads }  ');
writeln('  E)  Secant       { finds secant (sec) in degrees, radians, and grads }     ');
writeln('  F)  CoSecant     { finds cosecant (csc) in degrees, radians, and grads }   ');
writeln('  G)  Rad-to-Deg   { converts radians to degrees and grads }                 ');
writeln('  H)  Deg-to-Rad   { converts degrees to radians and grads }                 ');
writeln('  I)  Grad-to-Rad  { converts grads to radians and degrees }                 ');
writeln('  J)  NaturalLog   { finds natural logarithms; ln x, based on "e" }          ');
writeln('  K)  CommonLog    { finds common logarithms; log x, based on 10 }           ');
writeln('  L)  Equations    { in case you forgot... }                                 ');
writeln('  M)  Manual       { generate the user''s manual if it''s been lost }          ');
writeln('  N)  EXIT         { ends this program }                                     ');
writeln('                                                                             ');
writeln('                                                                             ');
writeln('                                                                             ');
write('');
textcolor(2);
write('                                                                          ');
textcolor(15);
writeln(' ');
writeln('ͼ');
textbackground(0);
textcolor(14);
Write('To run one of these subroutines, enter the letter');
textcolor(142);
write(':  ');
textcolor(14);
write('>  ');
textcolor(15);
textbackground(0);
if not eoln(input) then
readln (reply)
else
begin
textbackground(1);
clrscr;
beep;
goto tryagain;
end;
textcolor(15);
textbackground(1);
count:=0;
clrscr;
case reply of
'a', 'A' : sin_;
'b', 'B' : cos_;
'c', 'C' : tan_;
'd', 'D' : cot_;
'e', 'E' : sec_;
'f', 'F' : csc_;
'g', 'G' : r_to_d;
'h', 'H' : d_to_r;
'i', 'I' : g_to_r;
'j', 'J' : natural;
'k', 'K' : common;
'l', 'L' : equations;
'm', 'M' : manual;
'n', 'N' : goto done;
else
begin
clrscr;
beep;
goto tryagain;
end;
end;
goto tryagain;
done:
donesyserror;
textcolor(7);
textbackground(0);
clrscr;
if answer = true then
begin
textcolor(15);
writeln;
writeln;
write('  Your log file is: "');
textcolor(14);
write(filename);
textcolor(15);
write('"');
textcolor(143);
writeln('.');
writeln(logfile);
writeln(logfile);
writeln(logfile,'Don''t forget to register if you haven''t already...it''s only  $8.00!');
writeln(logfile);
writeln(logfile,'Duane Bailey');
writeln(logfile,'2059 Bethabara Rd, Apt. 28');
writeln(logfile,'Winston-Salem, NC 27106');
writeln(logfile);
close (logfile);
beep;
end;
textcolor(9);
writeln;
writeln;
writeln('  I''m glad you used AlgeTrig.......');
write('  It''s only $8.00, so hurry and register if you haven''t already');
textcolor(137);
writeln('!');
textcolor(1);
write('  ');
textbackground(7);
write(' AlgeTrig ');
textcolor(9);
textbackground(0);
writeln(' 1993 by Duane Bailey  (my handle: "Mission Control")');
textcolor(11);
writeln;
writeln('  Duane Bailey');
writeln('  2059 Bethabara Rd, Apt. 28');
writeln('  Winston-Salem, NC 27106');
writeln;
writeln('  (910) 922-3827');
writeln
end.
