(* This subroutine converts a real number to a string.	The conversion is
   performed so that the resulting string has as few characters as possible.
   For example, the real number 1.0 can be converted to any of the following
   strings: 1, 1.00000, 1E+0, 100.0E-2, etc.  The shortest string is the single
   digit 1, which is the string that would be produced by this subroutine.  All
   real numbers are converted so that at least 5 significant digits of precision
   are retained (except that leading and trailing zeros are removed where
   possible).
						    David B. Parker	     *)

Type RealStrString=String[12];
Function RealStr(Value:Real):RealStrString;
Var Expn,LDig:Integer; TStr:String[12]; EStr:String[3]; Sgn,TrZ:String[1];

    Procedure FullReal;
    Begin
    Str(Expn,EStr); If LDig=3 Then TrZ:='0' Else TrZ:='';
    RealStr:=Sgn+Copy(TStr,2,LDig-1)+TrZ+'E'+EStr;
    End;

Begin
Str(Value:12,TStr);
If (TStr[1]='-') Or (TStr[1]=' ') Then
   Begin If TStr[8]<>'E' Then Str(Value:11,TStr); End
Else Begin
     If TStr[8]<>'E' Then Str(Value:10,TStr) Else Str(Value:11,TStr);
     TStr:=' '+TStr; End;
If TStr[2]='0' Then RealStr:='0'
Else Begin
     If TStr[9]='+' Then Val(Copy(TStr,10,3),Expn,LDig)
     Else Val(Copy(TStr,9,4),Expn,LDig);
     If TStr[1]='-' Then Sgn:='-' Else Sgn:='';
     LDig:=7; While TStr[LDig]='0' Do LDig:=LDig-1;
     If Expn<0 Then
	If Expn<=-4 Then FullReal
	Else RealStr:=Sgn+'0.'+Copy('00',1,-1-Expn)+TStr[2]+Copy(TStr,4,LDig-3)
     Else If (LDig-3)<=Expn Then
	  If (-32768.0<=Value) And (Value<=32767.0) Then
	     RealStr:=Sgn+TStr[2]+Copy(TStr,4,LDig-3)+Copy('0000',1,Expn+3-LDig)
	  Else If Expn<=(LDig-2) Then Begin
	       If Expn=(LDig-3) Then TrZ:='' Else TrZ:='0';
	       RealStr:=Sgn+TStr[2]+Copy(TStr,4,LDig-3)+TrZ+'.0'; End
	  Else FullReal
     Else RealStr:=Sgn+TStr[2]+Copy(TStr,4,Expn)+'.'
		  +Copy(TStr,Expn+4,LDig-Expn-3); End;
End;
