Program Cube;

(* This program generates an AcroSpin file called CUBE.ACD that displays a *)
(* cube.  It has been tested with Turbo Pascal Versions 3 and 5.  You can  *)
(* modify the color of the cube and the colors of the printing by changing *)
(* the constants in the next section.					   *)
(*							David B. Parker    *)

(* Constants. *)

Const CubeColor   =14; (* Color to use for the cube.	  *)
      FragileColor=12; (* Color to use for 'FRAGILE'.     *)
      ThisEndColor=10; (* Color to use for 'THIS END UP'. *)

(* Variables. *)

Var Output:Text;    (* Output file.	  *)
    I,J,K :Integer; (* Looping variables. *)

(* Include the subroutines that write out text and convert reals to strings. *)

{$I REALSTR.PAS}
{$I WRITETEX.PAS}

(* Open the output file. *)

Begin
Assign(Output,'CUBE.ACD');
Rewrite(Output);

(* Write out the 'FRAGILE' and 'THIS END UP' messages on layers 0 and 1. *)

Writeln(Output,'Set Layer 0');
WriteText(FragileColor,  (* Color.			*)
	  0.1,0.1,	 (* X and Y sizes.		*)
	  0.0,0.0,30.0,  (* Rotate 30 degrees around Z. *)
	  0.25,0.25,1.0, (* Position of lower left.	*)
	  'FRAGILE');    (* Character string.           *)

Writeln(Output,'Set Layer 1');
WriteText(ThisEndColor,   (* Color.					     *)
	  0.08,0.08,	  (* X and Y scale factors.			     *)
	  -90.0,10.0,0.0, (* Rotate -90 dgrs around X, then 10 dgrs around Y *)
	  0.10,1.0,0.45,  (* Position of lower left.			     *)
	  'THIS END UP'); (* Character string.                               *)

(* Write out the 8 end points for the cube.  The name given to each	*)
(* end point consists of the prefix P followed by a number from 0 to 7. *)

Writeln(Output,'EndpointList X Y Z Name' );
For I:=0 To 1 Do
    For J:=0 To 1 Do
	For K:=0 To 1 Do Writeln(Output,I,' ',J,' ',K,' P',4*I+2*J+K);

(* Write out the 12 lines for the cube.  This loop uses a tricky     *)
(* little algorithm to decide which end points need to be connected. *)

Writeln(Output,'Set Color ',CubeColor,' Layer 2');
Writeln(Output,'LineList From To');
For I:=0 To 6 Do
    For J:=0 To 2 Do
	If (I And (1 Shl J))=0 Then Writeln(Output,'P',I,' P',I+(1 Shl J));

(* Close the output file. *)

Close(Output);
End.
