/***********************************************************************
*                                                                      *
*   A tap listener is an independent applications that  opens a queue  *
*   to receive information about file operations occuring in file      *
*   transfers (e.g. via ZMODEM).                                       *
*   These informations can be used for add-in applications like        *
*   auto-unzippers or online viewers.                                  *
*                                                                      *
*   ------------------------------------------------------------------ *
*                                                                      *
*   This tap listener program is queue driven and just lists all       *
*   events, that come in through the queue.                            *
*                                                                      *
*   ------------------------------------------------------------------ *
*                                                                      *
*   Manufacturing: ICC -Ss TAP.C                                       *
*                                                                      *
*   ------------------------------------------------------------------ *
*                                                                      *
*   No copyright by Markus Schmidt, 1993                               *
*                                                                      *
***********************************************************************/

#define INCL_DOSFILEMGR
// #define INCL_WINWINDOWMGR
#define INCL_DOSQUEUES
#define INCL_DOSMEMMGR
#define INCL_NOCOMMON

#include <os2.h>
#include <stdio.h>

#include "tap.h"

int main()
{
	int i;
	long size;
	char szQueName[]= TAP_QUEUE_NAME;
	HQUEUE hq= 0;


	// Find a free name and create a data queue to receive info
	for (i= 0; i<TAP_MAX && hq==0; i++) {
		DosCreateQueue(&hq, QUE_FIFO, szQueName);
		szQueName[strlen(szQueName)-1]++;
	}

	if (hq) {
		REQUESTDATA rqd;
		ULONG length;
		VOID *data;
		BYTE prio;
		TAP_HOSTINFO *phi;
		char *pcdata;


		do {
			// read message from queue
			DosReadQueue(hq, 
					&rqd,		// ulData-field for eventcode
					&length,	// field for data length or offset
					&data,		// field for data pointer
					0, 			// get first element from queue
					0,			// wait synchronously for data
					&prio,		// element priority
					0);			// no semaphore

			// dump it
			printf("%d %p %4d  =>", rqd.ulData, data, length);

			// react according to event
			switch (rqd.ulData) {

				case TAP_EVENT_HOSTINFO:
						phi= data;
						printf("HOSTINFO %s V%s\n", phi->szHostName,
													phi->szHostVers);
						break;

				case TAP_EVENT_OPENFORREAD:
				case TAP_EVENT_OPENFORWRITE:
				case TAP_EVENT_OPENFORAPPEND:
						// data:	filename '\0' "<size>" 
						//          (size is decimal ascii, "0" if not avail)
						// length:	strlen(filename)+1

						size= atoi((char*)data+strlen(data)+1);
						printf("OPEN FILE %s (%ld bytes)\n", data, size);
						break;

				case TAP_EVENT_READBLOCK:
				case TAP_EVENT_WRITEBLOCK:
						// data:	block of data
						// length:	length of block
						pcdata= data;
						printf("DATA %d BYTES, %02x %02x ... \n", 
								length, pcdata[0], pcdata[1]);
						break;

				case TAP_EVENT_READBYTE:
						// data:	(UCHAR)data
						// length:	1
						printf("DATA 1 BYTE, %02x \n", (UCHAR)(LONG)data);
						break;

				case TAP_EVENT_SEEK:
						// data:	NULL
						// length:	new offset into file
						printf("SEEK TO POS %d\n", length);
						break;

				case TAP_EVENT_CLOSE:
						// data:	NULL
						// length:	0
						printf("CLOSE\n");
						break;

				default:
						// other events are legal and should be
						// ignored
						printf("PANIC: UNKNOWN EVENT (maybe a future event)\n");
						break;
			}

			// free blocks of data
			if (data!=NULL)
				DosFreeMem(data);

		} while (rqd.ulData!=TAP_EVENT_CLOSE);

	}

	// Destroy queue
	DosCloseQueue(hq);

	// terminate
	return (0);
}
