#define  INCL_BASE
#define  INCL_NOPM
#include <stdio.h>
#include <string.h>
#include <os2.h>
#include "tuneplyr.h"

#define  TP_VERSION        "V1.0"
char allTunes[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

void play_tune(char *fileName, char tuneNo);

int main(int argc, char *argv[])
{
char *nextTune;

   printf("\nTunePlayer %s, Copyright (c) 1992, CoralSoft, Inc.", TP_VERSION);
   if (argc != 3)
      {
      printf("\nUsage:\n");
      printf("\n\ttuneplay [tune file] [tune number]\n");
      printf("\n\tWhere [tune file] = Data file created by 'Tune Editor'");
      printf("\n\t                    application (*.$$a)");
      printf("\n\t      [tune number] = Number of the tune (0-9A-Z)");
      printf("\nTunePlay allows background or batch playing of tunes\n");
      printf("\ncreated with the OS/2 Tune Editor, found in the OS/2");
      printf("\nProductivity Folder.  When you save a tune file, it");
      printf("\nis given the extension '.$$a'.  By default, these files");
      printf("\nare stored on your boot drive in the \\OS2\\APPS directory");
      printf("\nBy specifying '*' for the tune number, all tunes in the");
      printf("\nfile will be played with a slight pause between each.");
      return -1;
      }

   if (*argv[2] != '*')
      play_tune(argv[1], *argv[2]);
   else
      {
      for (nextTune= allTunes; *nextTune; nextTune++)
         {
         play_tune(argv[1], *nextTune);
         DosSleep(1000L);
         }
      }
   return 0;

}

void play_tune(char *fileName, char tuneNo)
{
int rc;
PTUNENOTE tuneBase;
BYTE tuneName[26];

   memset(tuneName, 0, 26);
   rc= createTune(fileName, tuneNo, &tuneBase, tuneName);
   if (rc)
      return;
   if (!tuneBase)
      return;
   printf("\nPlaying > %s", tuneName);
   fflush(stdout);
   playTune(tuneBase);
   closeTune(tuneBase);

}
