/************************************************************************

      Module Name........: $modname$
      Module Description.: Player for 'Tune Editor' files
      Module Date........: $date$
      Written By.........: Steve Horne / CoralSoft, Inc.
                           305 Judson Dr. 
                           Mobile, AL  36608
                           (205) 344-2251
      Version............: $version$
      Release............: $release$

-------------------------------------------------------------------------

   Description
   -----------
   $notes$
   This VIO application will play a tune from a PMDiary
   data file.  These files are created with the 'Tune Editor' mini-app
   located in the 'Productivity' folder.  The files created by the
   Tune Editor have an extension of '$$a'.  The full path/filename must
   be supplied to these routines.
   $notesend$

   $log$

-------------------------------------------------------------------------

   The C and C++ structures and code in this document have been created
   by CoralSoft, Inc. and are considered proprietary and confidential.
   This information may not be distributed by any means, electronic or
   mechanical, without the prior written consent of CoralSoft, Inc.
   No warranties are either EXPRESSED or IMPLIED.
   Copyright (c) 1992, CoralSoft, Inc.

************************************************************************/
#define  INCL_BASE
#define  INCL_NOPM
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <os2.h>
#include "tuneplyr.h"

ULONG tuneFreqs[63] = {
/* Naturals */
   784L, 698L, 659L, 587L, 523L, 494L, 440L, 392L, 349L, 330L, 294L, 262L,
      247L, 220L, 196L, 175L, 165L, 147L, 131L, 123L, 110L,
/* Flats */
   740L, 659L, 622L, 554L, 494L, 466L, 415L, 370L, 330L, 311L, 277L, 247L,
      233L, 208L, 185L, 165L, 156L, 139L, 123L, 117L, 104L,
/* Sharps */
   831L, 740L, 698L, 622L, 554L, 523L, 466L, 415L, 370L, 349L, 311L, 277L,
      262L, 233L, 208L, 185L, 175L, 156L, 139L, 131L, 117L
   };

const double durMap[] =
   {  0.25, 0.33333, 0.5, 0.66667, 1.0, 1.33333, 2.0, 2.66667, 4.0, 8.0,
      0.25, 0.5, 1.0, 2.0, 4.0, 8.0 };

typedef struct _TuneTitleLine {
   BYTE tuneNo;
   BYTE colonSpace[2];
   BYTE tuneName[25];
   BYTE vertBar;
   BYTE filler[10];
   } TuneTitleLine;

typedef struct _TuneTempoLine {
   BYTE tempo[4];
   BYTE vertBar;
   BYTE filler[34];
   } TuneTempoLine;

typedef struct _TuneNoteLine {
   BYTE barDivisor[2];
   BYTE aspace;
   BYTE noteIdx[2];
   BYTE vertBar;
   BYTE filler[33];
   } TuneNoteLine;

typedef union _TuneInBuff {
   BYTE buffer[39];
   TuneTitleLine title;
   TuneTempoLine tempo;
   TuneNoteLine note;
   } TuneInBuff;

int readTune(FILE *inFile, BYTE tuneNo, PTUNENOTE *base, PBYTE tuneName);

int createTune(PSZ tuneFile, BYTE tuneNo, PTUNENOTE *tuneBase, PBYTE tuneName)
{
int rc;
FILE *inFile;

   inFile= fopen(tuneFile, "r");
   if (inFile == NULL)
      return errno;
   tuneNo= toupper(tuneNo);
   rc= readTune(inFile, tuneNo, tuneBase, tuneName);
   fclose(inFile);
   if (rc)
      return rc;
   return 0;

}

int readTune(FILE *inFile, BYTE tuneNo, PTUNENOTE *base, PBYTE tuneName)
{
TuneInBuff inBuff;
BOOL foundTune;
int divisor, noteIdx;
double length;
PTUNENOTE nextNote, lastNote;
USHORT tempo;

   *base= nextNote= lastNote= NULL;
   while (!feof(inFile))
      {
      foundTune= FALSE;
      while (!foundTune)
         {
         memset(inBuff.buffer, 0, sizeof(inBuff.buffer));
         if (fgets(inBuff.buffer, sizeof(inBuff.buffer), inFile) == NULL)
            return ferror(inFile);
         if (inBuff.title.vertBar == '|')
            if (inBuff.title.tuneNo == tuneNo)
               {
               foundTune= TRUE;
               if (tuneName)
                  memcpy(tuneName, inBuff.title.tuneName, 25);
               }
         }
      memset(inBuff.buffer, 0, sizeof(inBuff.buffer));
      if (fgets(inBuff.buffer, sizeof(inBuff.buffer), inFile) == NULL)
         return -1;
      tempo= atoi(inBuff.tempo.tempo);
      while (TRUE)
         {
         memset(inBuff.buffer, 0, sizeof(inBuff.buffer));
         if (fgets(inBuff.buffer, sizeof(inBuff.buffer), inFile) == NULL)
            break;
         if (inBuff.note.vertBar != '|')
            break;
         if (nextNote)
            {
            nextNote->next= (PTUNENOTE) malloc(sizeof(TUNENOTE));
            nextNote= nextNote->next;
            }
         else
            {
            nextNote= (PTUNENOTE) malloc(sizeof(TUNENOTE));
            *base= nextNote;
            }
         divisor= atoi(inBuff.note.barDivisor);
         noteIdx= atoi(inBuff.note.noteIdx);
         length= tempo;
         length= 60000.0 / length;
         length/= durMap[divisor];
         nextNote->freq= tuneFreqs[noteIdx];
         nextNote->dur= length;
         if (divisor > 9)
            nextNote->rest= TRUE;
         else
            {
            nextNote->rest= FALSE;
            lastNote= nextNote;
            }
         nextNote->next= NULL;
         }
      if (lastNote)
         {
         if (lastNote->next)
            {
            closeTune(lastNote->next);
            lastNote->next= NULL;
            }
         }
      else
         {
         closeTune(*base);
         return -2;
         }
      return 0;
      }
   return -3;
}

void closeTune(PTUNENOTE base)
{
   if (base->next)
      closeTune(base->next);
   free(base);
   return;
}

void playTune(PTUNENOTE base)
{
PTUNENOTE nextNote;

   if (!base)
      return;

   nextNote= base;
   while (nextNote)
      {
      if (nextNote->rest)
         DosSleep(nextNote->dur);
      else
         DosBeep(nextNote->freq, nextNote->dur);
      nextNote= nextNote->next;
      }
   return;
}

