/* RXMSGBOX - REXX program to display a message box to inform the user
   of a long-running task that must be done by the parent REXX program,
   and then disappear once the parent task has completed.

   1994-08-05 Bruce Hgman

   The RXMSGTST.CMD REXX program is used as a skeleton program, from
   which you can copy code to put into your own rexx program as a
   parent task to drive the message subtask.

   You invoke this program using the START command, as illustrated
   in the rxmsgtst.cmd program.  The first argument is the name of
   the rexx queue to use as the communication device between the
   parent task and this subtask.  The other arguments are words to
   display as the message in the white-on-red box.

   The subtask sleeps until there is data in the queue, at which time
   the subtask pulls the line from the queue and displays the message
   and then terminates after a short sleep.
*/
if 0 < RxFuncQuery('SysLoadFuncs') then
   do;
      Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
      Call SysLoadFuncs;
   end;
else nop
parse arg QueueName MsgStrings
/*
  Set named queue as active queue
*/

TName = RxQueue("Set",QueueName); TName = RxQueue("Get")
if TName \= QueueName then
   do
      say 'TName='TName 'QueueName='QueueName
      say 'Failure in RxQueue Set queue named:' QueueName
      Call SysSleep 5
      exit
   end

call charout ,d2c(27)'[0;1;5;37;41m' /* bright white on bright red */
'@mode 80,5'                         /* make a small window */
call charout ,d2c(27)'[2J'd2c(27)'[2;5H'MsgStrings
do while 1>queued(); Call SysSleep 1; end
pull DisplayMsg
/* bright white on dark green */
call charout ,d2c(27)'[0;1;37;42m'd2c(27)'[2J'd2c(27)'[2;5H'
if DisplayMsg\='' & DisplayMsg\=' ' then say DisplayMsg
else say 'Task completed.'
Call SysSleep 2
'@exit'
