/* RxMsgTst - REXX program to test RXMSGBOX.CMD "pop-up" message
   display subtask.  This program can be adapted for your use in
   your rexx programs.
   This program is a "skeleton program" used to test the interface
   to the RXMSGBOX.CMD REXX program that is the message display
   subtask.  You must copy portions of this code to your own
   REXX program within which you want to display a pop-up message
   to the user while the parent rexx program is doing a long task.
   To switch focus to the message display task launched using the
   START command, this program uses the PMSW package available on
   IBM OS2 USER forum on Compuserve or other IBM OS/2 sources.
   The PMSW2.DLL file should be in the OS/2 \os2\dll directory or
   in another directory that is in the LIBPATH.
   Author:  Bruce Eric Hgman, IBM Boca Raton FL 1994-08-05
*/

/* Note:  since PMSW2 is used to switch focus to another window,
   you can't assume focus will return to this window containing
   your parent REXX program unless you take steps to identify it
   to the switch window and use PMSW2 to take focus back to the
   parent.  A suggested way of doing this is to launch the parent
   task using a desktop object and use the title of that object
   (or a portion of the title:
      PRC=PMSW2("*substring of title*")
*/
OurSwitchListName='RXMSGTST.CMD' /* name or title substring */
/* if you launched this program using: start "rxmsgtst.cmd" /c rxmsgtst
*/

Call SetupDLLsForSubtask   /* Include this call in your own program */
Call CreateQueueForSubtask /* Include this call in your own program */


/* Replace the text below with your own message text */
MsgString='Please wait while RXMSGTST does a long-running task.'


/* Include this call in your program */
/* Set variable MsgString to the message you want displayed */
Call StartRxMsgBoxSubtask MsgString


/*  */
/* Here is where you would put long-running task */
/*  */


/* After the long-running task is complete, include the call
   to stop the subtask.  This program uses a prompt to simulate
   the long-running task time.
*/
say 'Please enter a response to stop subtask.'
pull response

Call StopRxMsgBoxSubtask response /* include this call in your program */
return

/*  */
/* Copy the code below to end of file to your program as procedures */
/*  */

/* Create a unique queue for communication with our subtask */
CreateQueueForSubtask:
   /* Rexx will create a MessageQueueName for us */
   MessageQueueName = RxQueue("Create")
   PreviousQueueName = RxQueue("Set",MessageQueueName);
   CurrentQueueName  = RxQueue("Get")
   if CurrentQueueName \= MessageQueueName then
      do
         say 'Failure in RxQueue "Set"'
         say 'Processing may be unsuccessful.'
      end
   drop CurrentQueueName
   JunkQName=RxQueue("Set",PreviousQueueName);
   return

/* Load REXXUTIL functions if not loaded already, and PMSW2 */
SetupDLLsForSubtask:
   if 0 < RxFuncQuery('SysLoadFuncs') then
      do;
         Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
         Call SysLoadFuncs;
      end;
   if 0 < RxFuncQuery('PMSW2') then
      Call RxFuncAdd 'PMSW2','PMSW2','PMSW2'
   return

/* Start a subtask for the message display and switch focus to it */
StartRxMsgBoxSubtask:
   Call CreateQueueForSubtask
   '@start "'MessageQueueName'" /c ' ||,
      'rxmsgbox.cmd' MessageQueueName MsgString
   bLoop=1
   do while bLoop
      PRC=PMSW2(MessageQueueName,'/r')
      if PRC\='ERROR:' then bLoop=0
   end
   PRC=PMSW2(MessageQueueName)
   return

/* Switch focus to the message subtask and tell it to stop */
StopRxMsgBoxSubtask:
   parse arg MsgString
   JunkQName=RxQueue("Set",MessageQueueName)    /* set msg queue */
   PRC=PMSW2(MessageQueueName)
   queue MsgString
   bLoop=1
   do while bLoop
      PRC=PMSW2(MessageQueueName,'/r')
      if PRC\='READY:' then bLoop=0
   end
   JunkQName=RxQueue("Set",PreviousQueueName)
   PRC = RxQueue("Delete",MessageQueueName)

   /* switch focus back to ourself */
   /* This is only possible if we named ourself.*/
   PRC=PMSW2(OutSwitchListName,'/r') /* test if known */
   if PRC='READY:' then
      PRC=PMSW2(OurSwitchListName)
   return
