/*
##################################
#            TDDemo.c:           #
# Thread Demo Program for PrjMgr #
##################################
# Written 1995 by Roland Knospe  #
##################################
*/

/* Need only DOSPROCESS from os2.h */
#define INCL_DOSPROCESS
#include <os2.h>

/* Header for the Video library */
#include <sys/video.h>

/* Header for _beginthread & _endthread */
#include <stdlib.h>

/* Own Header */
#include "TDDemo.h"

LONG ThreadCount=0;  /* Counter for active Thread's */


/* Main Function */
int main( void )
{
   PARAM Param[10]; /* Parameter structures */
   int i;           /* Universal Counter */

   v_init();                     /* Init Video Manager */
   v_attrib(B_WHITE|F_BLACK);    /* Set Colors */
   v_clear();                    /* Clear Screen */
   v_gotoxy(13,3);               /* Goto Screen position x=13 y=3 */
   v_printf("Thread Demo: Do not terminate this program !!!!");

   /* Start 10 Thread's */
   for(i=0;i<10;i++)
   {
      /* Init Parameter */
      Param[i].Number=i;
      Param[i].MaxCount=100+i*200;
      Param[i].x=10+40*(i%2);
      Param[i].y=7 +2 *(i/2);
      /* Start Thread MyThread with 10k Stacksize */
      _beginthread( MyThread, NULL, 10240, (void*)&Param[i] );
   }

   /* Show number of Thread's every 200 msec */
   do
   {
      DosSleep(200);

      DosEnterCritSec();
         i=ThreadCount;
         v_gotoxy( 30,20);
         v_printf("Active Threads:%d      ",i);
      DosExitCritSec();
   }
   while ( i>0 ); /* One thread running ?  */

   /* Bye Bye ... */
   return 0;
}


/* Thread Function */
void MyThread( void *arg )
{
   int counter;    /* Counter */
   PARAM *Param;   /* Parameter Pointer */

   Param=(PARAM*)arg;   /* Convert *arg to *Param */

   DosEnterCritSec();   /* Critical Area !! Only one can Change it at the same time*/
     ThreadCount++;     /* Increase ThreadCounter */
   DosExitCritSec();

   DosSleep(100);       /* Wait 100 msec */

   /* Counter Loop -> Count from MaxCount to Zero */
   for( counter=Param->MaxCount;counter>=0;counter--)
   {
      DosSleep(10);          /* Wait a moment */
      DosEnterCritSec();     /* Critical Area -> Video library */
         v_gotoxy( Param->x,Param->y);
         v_printf("Counter #%d =%d            ",Param->Number,counter);
      DosExitCritSec();
   }

   DosEnterCritSec(); /* Bye Bye .... */
      ThreadCount--;
   DosExitCritSec();
   _endthread();
}

