/***********************************************************************
*    pri.c -  Utility to start a program at specified priority
*
*    Description  - This can be used to create a session that runs at
*     high priority, by entering "PRI 3 \OS2\CMD.EXE" .  Any program
*     that is run from the resulting command shell will run at the
*     same priority.
*
***********************************************************************/
#define	INCL_BASE
#include "os2.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void help(void)
      {
      puts(
"Priority booster utility.                  Sep 20 1990  Natural MicroSystems");
      puts("");
      puts(
"Usage:  PRI <priority> <executable name> [optional program arguments ...]");
      puts( "" );
      puts( " Priority:");
      puts( "   1 - idletime");
      puts( "   2 - regular ");
      puts( "   3 - timecritical");
      puts( "   4 - foreground static");
      return ;
      }

void main( int argc, char *argv[] )
   {
   int i;
   int priority ;
   char argbuff[512];
   char errbuff[48];
   RESULTCODES resc;
   char  *p;
   char filename[80] ;
   char exename[80] ;

   if ( argc < 3 )
      {
      help () ;
      exit (0) ;
      }

   priority = atoi( *++argv ) ;
   if (priority < 1 || 4 < priority)
      {
      help () ;
      exit (0) ;
      }


   if ( i=DosSetPrty( PRTYS_PROCESSTREE, priority, 0, 0 ) )
      {
      printf( "DosSetPrty failed to set priority to %d: (error %d)\n", priority, i );
      exit(1);
      }

   argc -= 2 ;
   ++ argv ;

   p = argbuff;

   strcpy (filename, *argv);           // 1st arg is exe file name
   argc --;

   if ( NULL == strrchr( filename, '.'))    /*chk if no extension */
       strcat (filename, ".exe");

   if ( NULL == strrchr( filename, '\\'))    /*chk if no path */
       {
       i = DosSearchPath(SEARCH_CUR_DIRECTORY | SEARCH_ENVIRONMENT, "PATH",
                                  filename, exename, sizeof exename);
       if (i != 0)
           {
           if (i==2)    // ERROR_FILE_NOT_FOUND
               printf("File not found: %s\n", filename);
           else
               printf("DosSearchpath returned error %d\n", i);
           exit (1) ;
           }
       }
   else
       strcpy (exename, filename);

   // build arg buffer for execpgm: consists of exe name, null, then
   //  args separated by spaces, ended by two nulls

   strcpy(p, exename);
   p += (strlen(exename)+1);
   *p = '\0';                  // mark beginning of second string

   while (argc--)
       {
       strcat(p, *++argv);
       if (argc == 0)
           {
           p[strlen(p)+1] = '\0' ;     // ends with TWO nulls
           break ;
           }
       strcat(p, " ");
       }

   i = DosExecPgm(errbuff,             // buff to receive name if can't start
                  sizeof errbuff -1,
                  EXEC_ASYNC,          /* run as asynch child */
                  argbuff,
                  NULL,                // env
                  &resc,
                  filename );

   if (i != 0)
       {
       errbuff[sizeof errbuff -1] = '\0';
       if (i == 2)           // ERROR_FILE_NOT_FOUND
           printf("File not found: %s\n", errbuff);
       else
           printf("DosExecPgm error %d, errbuff = %s\n", i, errbuff);
       exit(1) ;
       }
   exit(0) ;
   }
