/********************************************************************\
*                                                                    *
* COPYRIGHT:  Copyright (c) 1992 Impact Software, INC.               *
*                                                                    *
* AUTHOR:     Ronald T. Burr                                         *
*             Impact Software, Inc.                                  *
*             5889 Kanan Rd. Suite 330                               *
*             Agoura, Ca 91301                                       *
*             VOICE     (800) 676-9390                               *
*             FAX       (818) 879-5593                               *
*             COMPUSERVE 71041,1565                                  * 
*                                                                    *
* Header File for Impact Software's OS/2 entryfield.  The purpose    *
* of this entryfield is to provide the picture mask support so badly *
* needed yet mysteriously not included in OS/2's entryfields.  We    *
* have created a new entryfield class called:                        *
*                                                                    *
*                    WC_EFPICMASK                                    *
*                                                                    *
* This entryfield works almost identically to the OS/2 entryfield    *
* with a few exceptions noted below.  This entryfield accepts and    *
* sends all standard entryfield messages.  It allows the developer   *
* to specify a format string when the entryfield is created, which   *
* determines things like:                                            *
*                                                                    *
*  o  numeric entry only                                             *
*  o  alpha characters only                                          *
*  o  any characters                                                 *
*  o  special delimiting characters                                  *
*                                                                    *
* There are certain initialization characters which tell the         *
* entryfield what type of data, if any, is allowable for a partic-   *
* ular character postion.  Any other character in the initialization *
* string which is not one of these  special characters or a space,   *
* is interperted as a "mask" character, and as such becomes a perm-  *
* anent part of the entryfield.  For example:                        *
*                                                                    *
* CONTROL "(999)999-9999", ID_E_PHONE, 78, 236, 18, 8, WC_EFPCIMASK, *
*         ES_LEFT | ES_AUTOTAB | ES_MARGIN | WS_TABSTOP | WS_VISIBLE *
*                                                                    *
* this resource statement would create an entryfield for a phone     *
* number.  The '9' indicates that particular character position is   *
* numeric only.  The (, ) and - are interperated as mask characters  *
* and are therefore permanent parts of the entryfield and can not be *
* deleted or typed over.  As soon as the user enters data and the    *
* cursor has reached a mask character, the cursor is automatically   *
* advanced to the first editable position after the mask(s).         *
*                                                                    *
* Following is another example to create a date entryfield:          *
*                                                                    *
* CONTROL "99/99/9999", ID_E_DATE, 349, 236, 50, 8, WC_EFPICMASK,    *
*         ES_LEFT | ES_MARGIN | WS_TABSTOP | WS_VISIBLE              *
*                                                                    *
* As you can see these entryfields are very easy to use, and require *
* only the most minimal code changes.  Simply update your resource   *
* file with the new control type and any picture mask.  The only     *
* other requirement is to call the function fnInitWCPicMsk(HAB hab)  *
* at the beginning of your application, preferably as soon as you    *
* have created the anchor block.  Only because you will not be able  *
* to load any resources which include the WC_EFPICMASK control until *
* you have called the init function to register the class.  For      *
* example:                                                           *
*                                                                    *
*   if((hAB = WinInitialize(0)) == 0)                                * 
*      return(FALSE);                                                * 
*                                                                    * 
*   if((hMQ = WinCreateMsgQueue(hAB, 0)) == 0)                       * 
*      return(FALSE);                                                * 
*                                                                    * 
*   fnInitWCPicMsk(hAB);                                             * 
*                                                                    *
*                                                                    *
* Also you will need to include this header file, and link with one  *
* of the following libraries:                                        *
*                                                                    *
*     wcpic32.lib  - 32 bit C Set/2 model                            *
*     wcpich.lib   - 16 bit huge model                               *
*     wcpicl.lib   - 16 bit large model                              *
*     wcpicm.lib   - 16 bit medium model                             *
*     wcpics.lib   - 16 bit small model                              *
*                                                                    *
* The 32 bit version also has a DLL which contains the actual code,  *
* wcpic32.dll.  The 16 bit versions are just standard libraries.     *
* The compile/link parameters for the 32 bit version were as follows *
*                                                                    *
*  COMPILE:                                                          *
*     /Q+ /Ss /W3 /Ge- /Gm+ /Gd+ /Ti+ /O- /C /Sr+ /Se /Sm            *
*                                                                    *
*  LINK:                                                             *
*     /NOI                                                           *
*                                                                    *
*                                                                    *
* The special initialization characters are as follows:              *
*                                                                    *
* '9'       - numeric only                                           *
* 'X'       - Alphanumeric only, convert to CAPS                     *
* 'x'       - Alphanumeric only, no case conversion                  *
* '?'       - any character                                          *
* ' '       - non eraseable space                                    *
*                                                                    *
* any other character of the 256 ascii characters will be            *
* interperetted as a mask character.                                 *
*                                                                    *
* Restrictions:                                                      *
*                                                                    * 
* This entryfield has no insert mode it always acts as overtype      *
* regardless of the state of the insert toggle.  This might sound    *
* weird but once you use it kind of makes sense.  The mouse is fully *
* supported.  The ES_RIGHT, ES_CENTER, ES_MIXED, ES_ANY, & ES_DBCS   *
* styles are not currently supported, they are ignored if you pass   *
* them as a parameter.  The ES_UNREADABLE style works, but not the   *
* way you'll really want it to.  If you're desparate for an          *
* unreadable entryfield which controls the input it will suffice for *
* now.  Of course ES_PICTUREMASK never did work, otherwise I         *
* wouldn't be doing this.                                            * 
*                                                                    *
*                                                                    *
* That's it folks, I hope you find this entryfield useful. Keep in   *
* mind this is a public domain application, you are free to use and  *
* distribute it as you like.  I know there are many more features I  *
* want to add, and I'm sure after using this lib you'll have many    *
* features you'd like added.  We are currently working on a more     *
* feature packed version of this lib which will be avaiable for      *
* sale.  If you are interested in recieving a copy of this new lib   *
* send us a note to that affect and we'll let you know as soon as it *
* is available.  If you include $7.00 or more we will put you on     *
* the beta list and provide you a free copy when the product is      *
* released.  You can still get on the beta list even if you don't    *
* send any money, but you will have to purchase the first release(at *
* a discount of couse).  Also include any enhancement suggestions.   *
*                                                                    *
* Our address and phone number are at the top of this file.  Also    *
* our company specializes in doing OS/2 and Windows contract         *
* development, so if you need any assistance in that area please     *
* feel free to give us a call.                                       *
*                                                                    * 
\********************************************************************/


#define WC_EFPICMASK          ((PSZ)0xffff0050L)

BOOL EXPENTRY fnInitWCPicMsk(HAB hab);
MRESULT EXPENTRY EFPicMaskProc(HWND, USHORT, MPARAM, MPARAM);


