/* Telephone program
   Written by Helge Hafting
   email:
   hafting@pvv.unit.no
   snail mail:
   poverudvn. 22
   N-3440 Ryken
   NORWAY
*/

arg tlf

if (tlf='' | tlf='?') then signal hjelp

call rxfuncadd "mciRxInit", "MCIAPI", "mciRxInit"
call mciRxInit

rc = mciRxSendString('open waveaudio alias lyd wait', 'RetStr', '0', '0')
if rc <> 0 then signal feil

forrige = '_'
do while tlf <> '' 
 siffer = left(tlf,1)
 tlf = substr(tlf,2)
 type = pos(siffer,'ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789*0#')
 if type > 0 then do
  if siffer = '*' then siffer='stjerne'
  else if type < 27 then siffer = trunc((type + 2) / 3)
  filnavn = siffer'.wav'
  if siffer = forrige then rc = mciRxSendString('seek lyd to start wait', 'RetStr', '0', '0')
  else rc = mciRxSendString('load lyd' filnavn 'wait', 'RetStr', '0', '0')
  if rc <> 0 then signal feil
  rc = mciRxSendString('play lyd wait', 'RetStr', '0', '0')
  if rc <> 0 then signal feil
 end
end


rc = mciRxSendString('close lyd wait', 'RetStr', '0', '0')
if rc <> 0 then signal feil

call mciRxExit

exit(0)

feil:
MacRC = mciRxGetErrorString(rc, 'ErrStVar')
say 'error' rc',' ErrStVar
rc = mciRxSendString('close lyd wait', 'RetStr', '0', '0')
call mciRxExit
exit(rc)

hjelp:
say
say 'Usage: dial <phone number>'
say 'Examples:'
say
say 'dial 1234567'
say 'dial (865) 9-ABC-567'
say 'dial 12-345-76 *5 *2 ##4'
exit(0)


