/* os2comm.c - version 1.2
*
* This program is intended to demonstrate the
* use of the comm device driver under OS/2.
* This program was written by Jim Gilliland.
*/

#define   LINT_ARGS
#define   INCL_BASE
#define   INCL_DOSDEVICES
#include  <os2.h>
#include  <stdio.h>
#include  <conio.h>
#include  <process.h>
#include  <malloc.h>
#define   STK_SIZE    1024

void main(int, char**, char**);
int      initcomm(int, char, int, int);
void far keytocom(void);
void far comtodsp(void);
int      parsarg(char*, char*, int*,
                 char*, int*, int*);
unsigned short    com, cfile;
unsigned int      cflag, ktcid, ctdid;
unsigned long far main_sem, far ctd_sem;

char *usage ="\nOS2Comm - usage is:\r\n"
"\n\tOS2COMM COMx:baudrate,parity,"
                "databits,stopbits"
"\n\twhere:"
"\n\t\t COMx     = COM1, COM2, or COM3"
"\n\t\t baudrate = 300,1200,2400,"
                  "4800,9600, or 19200"
"\n\t\t parity   = N,O,E,M, or S"
"\n\t\t databits = 5,6,7, or 8"
"\n\t\t stopbits = 1 or 2\r\n";

void main(argc, argv, envp)
int argc;
char **argv, **envp;
{
 char far *ctdstack, far *ktcstack;
 RESULTCODES retcodes;
 unsigned int act, baud, dbits, sbits;
 char parity, comport[8];

 puts("OS2Comm.c version 1.2");
 puts("Copyright 1988 by Jim Gilliland");

 if (argc < 2 || argc > 3)
    {  puts(usage);
       exit(1);     }

 if (parsarg(argv[1], comport, &baud,
             &parity, &dbits, &sbits))
    {  puts(usage);
       exit(1);    }

 /* Open com device driver: */
 if (DosOpen(comport, &com, &act,
             0L, 0, 0x01, 0x0012, 0L))
  {  fprintf(stderr,"\nError opening port");
     exit(1);  }

 /* Initialize com device driver: */
 if (initcomm(baud, parity, dbits, sbits))
  { fprintf(stderr,"\nPort setup error");
    exit(1);   }

 /* Open capture file, if specified: */
 if (argc > 2)
   if (DosOpen(argv[2], &cfile, &act,
               0L, 0, 0x12, 0x0022, 0L))
     { fprintf(stderr,"\nErr: %s\n",argv[2]);
       exit(1);    }
   else cflag = 1;
 else cflag = 0;

 /* allocate stack for threads: */
 ctdstack = malloc(STK_SIZE);
 ktcstack = malloc(STK_SIZE);

 if (ctdstack == NULL || ktcstack == NULL)
    {  puts ("Unable to allocate stacks");
       exit(2);    }

 /* Create receive and display thread: */
 if (DosCreateThread(comtodsp, &ctdid,
                     ctdstack+STK_SIZE))
   { puts("Can't create COM receive thread");
     exit(1);    }

 /* Set semaphore to block main thread: */
 DosSemSet(&main_sem);

 /* Create transmit thread: */
 if (DosCreateThread(keytocom, &ktcid,
                     ktcstack+STK_SIZE))
   { puts("Can't create COM transmit thread");
     exit(1);    }

 puts("Alt-X will end this program");

 /* Set high priority for COM threads */
 DosSetPrty(2,3,0,ktcid); /* time-critical */
 DosSetPrty(2,3,1,ctdid); /* time-crit +1  */

/* Wait for clear semaphore (see keytocom) */
 DosSemWait(&main_sem, -1L);

/* Suspend the other threads before ending */
 DosSuspendThread(ktcid);
 DosSuspendThread(ctdid);

 /* Close com driver and capture file: */
 DosClose(com);
 if (cflag==1) DosClose(cfile);

 DosExit(1,0); /* Exit: end all threads */
}
/*******************************************/

void far comtodsp()
/* This routine is run as a separate thread */
{
 char comchar[512];
 unsigned int bytes, readerr, cnt;

 while (-1)   /* Do forever: */
 {
    /* read character(s) from COMport: */
    readerr = DosRead(com,comchar,512,&bytes);
    if (readerr)     continue;
    if (bytes == 0)  continue;

    /* Write character(s) to screen: */
    VioWrtTTy(comchar,bytes,0);

    /* write character(s) to capture file: */
    if (cflag == 1)
       DosWrite(cfile,comchar,bytes,&cnt);
 }
}
/*******************************************/

void far keytocom()
/* This routine is run as a separate thread */
{
 KBDKEYINFO keyinfo;
 int written;
 char charcode, scancode;

 while (-1)   /* Do forever: */
 {
   KbdCharIn (&keyinfo, 0, 0);
   charcode = keyinfo.chChar;
   scancode = keyinfo.chScan;

   /* Alt-X indicates End-Of-Processing: */
   if (charcode == 0x00 && scancode == 0x2D)
      {
      /* Clear Main semaphore:  */
      DosSemClear(&main_sem);
      continue;
      }

   /* skip Alt-keys & F-Keys: */
   if (charcode == 0x00) continue;

   /* Write character(s) to com port: */
   DosWrite(com, &charcode, 1, &written);
 }
}
/*******************************************/

int initcomm(baud,parity,dbits,sbits)
char parity;
int baud, dbits, sbits;
   /* this routine used by main thread */
{
struct {
  unsigned char databits, parity, stopbits;
  } linechar;

struct {
  unsigned char onmask, offmask;
  } modemctrl;

struct {
  unsigned int wtime, rtime;
  unsigned char flags1, flags2, flags3;
  unsigned char errchar, brkchar;
  unsigned char xonchar, xoffchar;
  } dcb;

int comerr, act;

 /* Set bitrate: */
 if (DosDevIOCtl( NULL, (char *)&baud,
                       0x41, 01, com))
   { fprintf(stderr,"\nBitrate error");
     return(1);     }

 /* Set databits, stopbits, parity: */
 if (parity == 'N') linechar.parity = 0;
 if (parity == 'O') linechar.parity = 1;
 if (parity == 'E') linechar.parity = 2;
 if (parity == 'M') linechar.parity = 3;
 if (parity == 'S') linechar.parity = 4;
 if (sbits == 2) linechar.stopbits = 2;
 if (sbits == 1) linechar.stopbits = 0;
 linechar.databits = dbits;
 if (DosDevIOCtl( NULL, (char *)&linechar,
                       0x42, 01, com))
    { puts("Line characteristics error");
      return(1);     }

 /* Set modem control signals: */
 modemctrl.onmask  = 0x03; /* DTR & RTS on */
 modemctrl.offmask = 0xff; /* nothing off */
 if (DosDevIOCtl( (char *)&comerr,
       (char *)&modemctrl, 0x46, 01, com))
     { puts("Modem control error");
       return(1);     }

 /* Set com device processing parameters:  */
 dcb.wtime = 100; /* 1sec transmit timeout */
 dcb.rtime = 100; /* 1sec receive  timeout */
 dcb.flags1 = 0x01;  /* enable DTR,        */
 dcb.flags2 = 0x43;  /*   RTS, XON/XOFF    */
 dcb.flags3 = 0x04;  /* recv timeout mode  */
 dcb.errchar = 0x00; /* no error translate */
 dcb.brkchar = 0x00; /* no break translate */
 dcb.xonchar = 0x11;  /* standard XON  */
 dcb.xoffchar = 0x13; /* standard XOFF */
 if (DosDevIOCtl( NULL, (char *)&dcb,
                       0x53, 01, com))
     { puts("Device control block error");
       return(1);     }

 return(0);
}

int parsarg(arg,port,baud,parity,dbits,sbits)
char *arg, *port;
char *parity;
int *baud, *dbits, *sbits;
    /* this routine used by main thread */
{
  int strptr;
  char strhold[8];
  strupr(arg);   /* cvt to uppercase */

  /* Parse cmdline for COM port: */
  if ((strptr = strcspn(arg,":")) == 0)
                                  return(1);
  if (strptr > 8) return(1);
  strncpy(port, arg, strptr);
  *(port+strptr) = '\0';
  arg = arg+strptr+1;

  /* Parse for cmdline baudrate: */
  if ((strptr = strcspn(arg,",")) == 0)
                                  return(2);
  strncpy(strhold, arg, strptr);
  *(strhold+strptr) = '\0';
  *baud = atoi(strhold);
  if (*baud != 300 &&  *baud != 1200 &&
      *baud != 2400 && *baud != 4800 &&
      *baud != 9600 && *baud != 19200)
                                  return(2);
  arg = arg+strptr+1;

  /* Parse cmdline for parity: */
  if ((strptr = strcspn(arg,",")) == 0)
                                  return(3);
  *parity = *(arg+strptr-1);
  if (*parity != 'N' && *parity != 'O' &&
      *parity != 'E' && *parity != 'M' &&
      *parity != 'S')             return(3);
  arg = arg+strptr+1;

  /* Parse cmdline for databits: */
  if ((strptr = strcspn(arg,",")) == 0)
                                  return(4);
  *dbits = *(arg+strptr-1) - '0';
  if (*dbits != 5 &&   *dbits != 6 &&
      *dbits != 7 &&   *dbits != 8)
      return(4);
  arg = arg+strptr+1;

  /* Parse for stopbit value: */
  if ((strptr = strcspn(arg,",")) == 0)
                                  return(5);
  *sbits = *(arg+strptr-1) - '0';
  if (*sbits != 1 && *sbits != 2) return(5);

  return(0);
}
