/* INETLOG.CMD  REXX Program to extract and totalize daily and monthly	*/
/* time-ons by analyzing the IBM WARP Internet Dialer CONNECT.LOG file	*/
/*											*/
/* Jerry Levy,  Marblehead, MA 	05 Mar 95					*/
/* Please pass on comments, suggestions, problems to JLEVY@IBM.NET		*/
/* -------------------------------------------------------------------------------------------	*/
/*Program History									*/
/*  1.0	12 Feb 95	First distribution						*/
/*  2.0	05 Mar 95	Updated                                        				*/
/* 	-Cleaned up program								*/
/*	-Added some more error traps						*/
/*	-Changed all rounding to nearest .01 minutes:  Advantis calculates		*/
/*	 online time to nearest second, and .01 mins is quite close enough		*/
/*	-Use_VRexx equate was added: bypasses VRexx if not = "YES"		*/
/* -------------------------------------------------------------------------------------------	*/
/* GETTING STARTED (See ReadMe.1st for more detail)				*/
/* The surest way is to place all files extracted after unzipping INETLOG.ZIP	*/
/* into a folder.  No matter where that folder is placed double-clicking on	*/
/* INETLOG.CMD will start the program properly.  If the OS/2 window does not	*/
/* stay open after everything scrolls by, go into the INETLOG.CMD Settings	*/
/* Notebook, go to the Sessions page, and de-select "Close Window on Exit".	*/
/*											*/
/* You must, of course, have set up your IBM Information Highway Internet	*/
/* Dialer to log, and you must know the location and name of the logfile,  usually	*/
/* c:\tcpip\etc\connect.log.  If you have problems, read through the README.1ST	*/
/* file.											*/
/* -------------------------------------------------------------------------------------------	*/
/* Customize these three items if you need to.  Don't forget the quotation marks	*/
/* for the first two as the equates aren't syntactically correct without them		*/

   log_file = "c:\tcpip\etc\connect.log"	/* Complete path and filespec for the log file	*/

  output_file = "c:\tcpip\etc\file.$$$" /* File you want output saved to 		*/

   Use_VRexx = "YES"	/* "YES", YES, "yes" or yes means we prompt for	*/
				/* filenames with VREXX dialog boxes		*/
/* -------------------------------------------------------------------------------------------	*/


signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP
signal on error name CLEANUP
signal on notready name CLEANUP

/* Load the REXXUTIL functions	*/

   call rxfuncadd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
   call sysloadfuncs

crlf = d2c(13)||d2c(10)	/* carriage return + linefeed	*/

/* initialize all of these	*/

month.01 = "Jan"
month.02 = "Feb"
month.03 = "Mar"
month.04 = "Apr"
month.05 = "May"
month.06 = "Jun"
month.07 = "Jul"
month.08 = "Aug"
month.09 = "Sep"
month.10 = "Oct"
month.11 = "Nov"
month.12 = "Dec"

dcounter = 0			/* Counter increments each sign-on in a day		*/
mcounter = 0			/* Same for each sign-on in a month			*/
signons_each_day = 0	/* Accumulate number of connects daily		*/
signons_each_month = 0	/* Accumulate number of connects monthly		*/
TimeOn = 0			/* Time, each connect  (minutes)			*/
DailyTimeOn = 0		/* Accumulated minutes, daily			*/
MonthlyTimeOn = 0		/* Accumulated minutes, monthly			*/ 
old_m = 0			/* Storage of a 2-digit month (eg 05 = May)		*/
old_d = 0			/* and a 2-digit day					*/ 

monthline = ""			/* Initialize both of these as null strings		*/
dayline = ""			/* These are for monthly and daily output strings	*/

/* A typical line generated in the connect.log upon disconnect looks like this: 	*/
/*	   11/15 19:08:38 Disconnected after 00:06:20  0 errors  0 discards		*/
/* so we search for a key_phrase using the RexxUtil function SysFileSearch	*/

	key_phrase = "Disconnected after"	/* Word or phrase we"ll search for	*/

/* Now we Initialize VREXX	*/

if Use_VRexx = "YES" then
   do								/* Start up VREXX	*/
      "@echo off"
      call RxFuncAdd "VInit", "VREXX", "VINIT"
      initcode = VInit()
      if initcode = "ERROR" then signal CLEANUP
   end

 if Use_VRexx = "YES" then	    				 /* Select logfile	*/
      do until result <> ""		/* Don't accept a nonexistent filename	*/
         call VdialogPos 30, 50
         button = VFileBox("Select File to Analyze", log_file, filename)
         if button = "OK" then log_file = filename.vstring
         if button = "CANCEL" then call CLEANUP

         call stream log_file, "c", "query exists"
         if result = "" then
            do
               say log_file "does not exist, try again!"||crlf
               call beep 1000,100
            end
      end
 
if Use_VRexx = "YES" then		/* Choose file for outputting to disk		*/
   do until prompt.vstring <> ""	/* Have to enter something.			*/

   call VDialogPos 50, 50
  				/* The padding with spaces below controls dialog	*/
				/* box size, and prevents lopping off of last char	*/
				/* consequent to use of System Proportional font	*/ 
   prompt.0 = 6
   prompt.1 = "Include path and filename.  If file exists it will be                           "
   prompt.2 = "overwritten after being saved as a .BAK file.    "
   prompt.3 = ""
   prompt.4 = "No wildcards are allowed.  "
   prompt.5 = ""
   prompt.6 = "Default dir is" directory() "if no path is indicated.    "
   prompt.vstring = output_file
   button =  VInputBox("Select Filename to Save Output to", prompt, 30, 3)
   if button = "CANCEL" then call CLEANUP

/* We don't let you name the output file connect.log, config,sys, or autoexec.bat	*/
   if prompt.vstring <> "" then file = prompt.vstring
   file = translate(filespec("name", file))
   if file == CONNECT.LOG | file == CONFIG.SYS | file == AUTOEXEC.BAT then
      do
         say "Output file is" file||".  You are not allowed to"
         say "use CONNECT.LOG, CONFIG.SYS, or AUTOEXEC.BAT as an output filename."||crlf
         call beep 1000,100
         prompt.vstring = ""
     end
     if prompt.vstring = "" then call beep 1000,100
     if prompt.vstring <> "" then prompt.vstring = output_file
end

/* Check if the output file exists.  If it does, we overwrite it. If not we create it. 		*/
/* We also don't want to do something stupid like try to erase a vital file or the		*/
/* connect logfile										*/

if Use_Vrexx <> "YES" then
   do
        call stream log_file, "c", "query exists"
         if result = "" then
            do
               say "Aborting." log_file "does not exist."
               say "Check for the correct logfile name at the log_file equate in INETLOG.CMD."
               call beep 1000,100
               call CLEANUP
            end
   end

if Use_VRexx <> "YES" then
   do
      file = translate(filespec("name", output_file))

      if file == CONNECT.LOG | file == CONFIG.SYS | file == AUTOEXEC.BAT then
         do
            say "Output file is" output_file||".  You are not allowed to use"
            say "CONNECT.LOG, CONFIG.SYS, or AUTOEXEC.BAT as an output filename."
            call beep 1000,100
            call CLEANUP:							/* Error, so Exit	*/
         end
   end

/* Backup any output file of the same name if it exists, then erase it			*/
/* SysFile Delete won't accept wildcards, by the way, so damage we can do is limited	*/

        call stream output_file, "c", "query exists"
        if result <> "" then
            do
               "copy" output_file filespec("drive",output_file)||filespec("path",output_file)||"*.bak>NUL"
               call SysFileDelete output_file
           end
 
/* Now find all lines in connect.log that contain the key_phrase string	*/
/* A typical line generated in the connect.log after disconnect is:		*/
/*   "11/15 19:08:38 Disconnected after 00:06:20  0 errors  0 discards"	*/
/* which we will parse as follows:						*/
/*     date  word2       word3    word4 connect_time				*/  

call SysFileSearch key_phrase, log_file, "line."

RC = 0

DO i = 1 to line.0		/* the END for this "do" is in caps down below*/
   parse var line.i date word2 word3 word4 connect_time

   mm = substr(date, 1, 2)	/* Extract the month of a connection as a 2-dig number*/
   dd = substr(date, 4, 2)	/* ...and the day				*/
   hrs = substr(connect_time, 1, 2)	/* Extract the number of hours on-line*/
   mins = substr(connect_time, 4, 2)	/*... and mins				*/
   secs = substr(connect_time, 7, 2)	/*...and seconds			*/
   TimeOn = (60*hrs + mins + (1/60)*secs)	/* Calculate time_on for that connection*/

IF old_d = 0 then
   do						/* for very first connection line*/
      old_m = mm
      old_d = dd
      signons_each_day = 1			/* reset to 1	*/
      signons_each_month = 1
      DailyTimeOn = TimeOn
      MonthlyTimeOn = TimeOn
   end

ELSE IF old_m = mm & old_d = dd & Month <> 0 then
   do				/* continue to accumulate times if same month and day*/
      signons_each_day = signons_each_day + 1
      signons_each_month = signons_each_month + 1
      DailyTimeOn = DailyTimeOn + TimeOn
      MonthlyTimeOn = MonthlyTimeOn + TimeOn
   end

ELSE IF old_m = mm & old_d <> dd then		/* new day of same month	*/
   do
      dcounter = dcounter + 1
      dayline.dcounter = old_d month.old_m "("||signons_each_day||"X)" format(DailyTimeOn, 4, 2) "mins"

    old_d = dd
      signons_each_day = 1				/* Start counting over again	*/
      signons_each_month = signons_each_month + 1
      DailyTimeOn = TimeOn
      MonthlyTimeOn = MonthlyTimeOn + TimeOn
   end

ELSE IF old_m <> mm & old_m <> 0 then
   do				/* for any new month, which by definition is also a new day	*/
      dcounter = dcounter + 1
      dayline.dcounter = old_d month.old_m "("||signons_each_day||"X)" format(DailyTimeOn, 4, 2) "mins"

      mcounter = mcounter + 1
      monthline.mcounter = month.old_m "("||format(signons_each_month, 3)||"X)" format(MonthlyTimeOn, 5, 2) "mins"

      old_m = mm
      old_d = dd
      signons_each_day = 1
      signons_each_month = 1
      DailyTimeOn = TimeOn
      MonthlyTimeOn = TimeOn
   end

/* end of all these IF"s and ELSE IF"s						*/
 
END	/* of searching for key_phrase in all possible lines in the connect.log	*/

/* Now,since last day and last month is done:					*/

         dcounter = dcounter + 1
         dayline.dcounter = old_d month.old_m "("||signons_each_day||"X)" format(DailyTimeOn, 4, 2) "mins"

         mcounter = mcounter + 1
         monthline.mcounter = month.old_m "("||format(signons_each_month,3)||"X)" format(MonthlyTimeOn, 5, 2) "mins"

/* -------------------------------------------------------------------------------------------	*/
/* Now output everything to console and to file		*/

/* Tell us all	*/
   do
      intro = "Analysis of" log_file    "("||Date() "@" Time()||")"
      say intro
      call lineout output_file, intro
      say crlf||DAILY
      call lineout output_file, crlf||DAILY
      do j = 1 to dcounter
         say dayline.j
         call lineout output_file, dayline.j
      end

      say crlf||MONTHLY
      call lineout output_file, crlf||MONTHLY
      do j = 1 to mcounter
         say monthline.j
         call lineout output_file, monthline.j
   end
   finished = crlf||"End of analysis of" log_file
   say finished
   call lineout output_file, finished

/* -------------------------------------------------------------------------------------------	*/

/*	Exit.  Also terminate VREXX if we are using it*/

CLEANUP:
   if RC <> 0 then say log_file "is not a valid connection logfile."n
   if Use_VRexx = "YES" then call VExit

   exit