/* -----------------------------------------------------------------------

         Title: EXEC

        Author: Ralf Hauser

          Date: 14-04-93 / 14-04-93

        Manually generated by Ralf Hauser (co), 7400 Tbingen
        e-mail: affie@frege.sns.neuphilologie.uni-tuebingen.de

   Description: Execute a series of commands on a set of specified files

      Language: REXX

  Requirements: OS/2 Version 2.x or Version 1.3 (not tested for V1.3)

        This program is declared as FREEWARE!!!

        This program may be copied and distributed to anybody without
        any restrictions!!!

--------------------------------------------------------------------------

        Read this instead of a separate documentation file:

           EXEC allows you to execute a series of commands on a specified
           set of files.
           Each file and each command may be queried whether it is to be
           processed or not.
           The filespec may contain wildcards and files in subdirectories.
           Commands may be given as command line arguments or within a
           file.
           Several switches control the program's behaviour.

           The general syntax is:

              EXEC [-switches] [attributes] filespec commandlist

           The following switches are available:

              ?     display a help screen

              !     do not confirm each file. The default is to confirm
                    each file!

              a     set attributes for search. These attributes must be
                    specified as the next argument.
                    (For a complete discussion of these flags refer to
                    the OS/2 REXX manual under function 'SysFileTree'.
                    No time to explain this here. If you want to use it,
                    read this section!)

              c     confirm each command to be executed. Default is to
                    execute all commands without confirmation.

              f     execute commands in specified file. Instead of giving a
                    'commandlist' a filename must be specified for a file
                    containing all commands on a line-per-line basis.
                    Multiple commands on a line may be spearated by a
                    semicolon.

              l     display errorlevels of each command after execution.

              q     quiet mode: do not display filenames and commands as
                    they are executed. The switch is ignored if any queries
                    are made.

              s     recursively process subdirectories. Execute commands on
                    all files matching the 'filespec' in the current directory
                    and all directories below.

              v     verbose mode: a bit more information.

           The 'filespec' may contain wildcards (?, *) drives and paths.

           The 'commandlist' may contain multiple commands separated by
           semicolons. Each command may contain variables which are expanded
           at runtime.

           The following variable are available:

              $F    expands to the complete filename
              $N    expands to the filename without path/drive
              $D    expands to the drive of the filename
              $E    expands to the (DOS style) filename extension.
                    (The last string in the filename beginning with a period.)
                    (The period is part of the extension.)
              $B    base filename without extension
              $C    comment - the rest of this comand line is ignored

           Examples:

               Delete specific files of a specified directory "C:\TMP"
                and all its subdirectories:

                      EXEC  -s  C:\tmp\*  del $f

                This executes the command "del $f" on all files in "C:\tmp"
                and its subdirectories after a query (!).

               Delete specific files of a specified directory "C:\TMP"
                and all its subdirectories after they have been viewed:

                      EXEC  -cs  C:\tmp\*  type $f;del $f

                This executes the command "type $f" on all files in "C:\tmp"
                and its subdirectories and - after a query (!) - deletes
                the corresponding file.

               Copy all "*.DAT" files of a specified directory "C:\DATA"
                to a new directory "D:\NEW" and precede all files by
                their filename. Rename files to "*.TXT".
                The commands to do that are kept in file "D:\commands".

                      EXEC  -f! C:\data\*.DAT D:\commands

                The contents of "D:\commands" is:

                      $C create header for each file
                      echo "******" > D:\NEW\$b.TXT
                      echo $n > D:\NEW\$b.TXT
                      echo "******" > D:\NEW\$b.TXT
                      type $f > D:\NEW\$b.TXT

                Note the term "$b.TXT" which results in a new filename
                'basefilename + new extension'.

--------------------------------------------------------------------------

        If you consider this program as being useful give it to your
        friends or any other OS/2 users.

                                         "OS/2 - Walking and chewing gum."

--------------------------------------------------------------------------
History:
14-04-92   co Created.
-------------------------------------------------------------------------- */

'@ECHO OFF'                       /* do not display any SHELL commands */
global. = ""                      /* init */

/* ----------------------------------------------------------------------- */
/*      Main                                                               */
/* ----------------------------------------------------------------------- */

Main :
        CALL main_init            /* initialize global data structures */

        /*
         *    handle arguments
         */

        PARSE ARG switches filespec commands

        IF ARG() = 0 THEN
           CALL main_help

        /* header */
        Say " "
        CALL main_msg "   V" || global.version
        Say " "

        /* look whether we have command line options (switches) */
        IF Substr(switches, 1, 1) <> "-" & Substr(switches, 1, 1) <> "/" THEN DO
           /* no, so shift arguments */
           PARSE ARG filespec commands
           END
        ELSE DO /* handle switches */
           IF Pos("?", switches) > 0 THEN
              CALL main_help
           IF Pos("!", switches) > 0 THEN
              global.query_file = 0
           IF Pos("a", switches) > 0 THEN
              PARSE ARG switches filespec global.attributes commands
           global.query_exec= Pos("c", switches)
           global.comfile   = Pos("f", switches)
           global.errcodes  = Pos("l", switches)
           global.quiet     = Pos("q", switches)
           global.subdirs   = Pos("s", switches)
           global.verbose   = Pos("v", switches)
           END

        /* consistency check */
        IF global.query_exec <> 0 THEN
           global.quiet = 0
        IF global.query_file <> 0 THEN
           global.verbose = 1

        /* check correct arguments */
        IF filespec = "" | commands = "" THEN
           CALL main_help

        /*
         *    convert specified commands to list
         */

        CALL main_convert_commands commands

        /*
         *    create a list of files
         */

        CALL main_filelist filespec

        /*
         *    process commands on filelist
         */

        num_of_execs = main_exec()

        /*
         *    Finished!
         */

        SAY ""
        CALL main_msg global.files.0 "File(s) handled."
        CALL main_msg num_of_execs "File(s) processed. Program terminated successfully"
        /* CALL beep 1600, 200 */
        /* CALL beep 2000, 200 */
        /* CALL beep 2400, 200 */
EXIT

/* end: main */

/* ----------------------------------------------------------------------- */
/*      main_init                                                          */
/* ----------------------------------------------------------------------- */

main_init : PROCEDURE EXPOSE global.
/*
 *      initializes all global data
 */
        /* check whether RxFuncs are loaded, if not, load them */
        IF RxFuncQuery('SysLoadFuncs') THEN DO
           /* load the load-function */
           CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
           /* load the Sys* utilities */
           CALL SysLoadFuncs
           END

        /* set default values */
        global.title         = "EXEC"
        global.version       = "1.00"
        global.attributes    = "*-**-"      /* archives or not - who cares */
                                            /* no directories */
                                            /* hiden or not - who cares */
                                            /* read-only or not - who cares */
                                            /* no system files */
        global.query_file    = 1
        global.query_exec    = 0
        global.subdirs       = 0
        global.comfile       = 0
        global.errcodes      = 0
        global.verbose       = 0
        global.quiet         = 0
        global.no_colors     = 0

        global.files.        = ""
        global.files.0       = 0
        global.filename_offset = 38

        global.commands.     = ""
        global.commands.0    = 0

        RETURN
/* main_init */

/* ----------------------------------------------------------------------- */
/*      main_error                                                         */
/* ----------------------------------------------------------------------- */

main_msg : PROCEDURE EXPOSE global.
PARSE ARG msg

        Say global.title || ": " || msg
        RETURN
/* end: main_msg */

/* ----------------------------------------------------------------------- */
/*      main_error                                                         */
/* ----------------------------------------------------------------------- */

main_error : PROCEDURE EXPOSE global.
PARSE ARG msg, msg1, msg2

        Say " "
        CALL main_msg "An error occured:"
        CALL Beep 500, 200
        CALL Beep 900, 200
        CALL Beep 500, 200
        Say " "
        Say "   Error: " || msg
        IF msg1 <> "" THEN
           Say "          " || msg1
        IF msg2 <> "" THEN
           Say "          " || msg2
        EXIT
/* end: main_error */

/* ----------------------------------------------------------------------- */
/*      main_help                                                          */
/* ----------------------------------------------------------------------- */

main_help : PROCEDURE EXPOSE global.
/*
 *      Print a help screen
 */
        Say " Usage: " || global.title || " [{/|-}switches]  [attributes] filespec  command"
        Say " "
        Say "     Possible switches are:"
        Say " "
        Say "         ?     this help"
        Say "         !     do not confirm each file (default is to confirm)"
        Say "         a     set attributes for search (Flags: ADHRS, *+-)"
        Say "         c     confirm each command to be executed"
        Say "         f     execute commands in spec. file"
        Say "         l     display errorlevels"
        Say "         q     quiet mode"
        Say "         s     recursively process subdirectories"
        Say "         v     verbose mode"
        Say " "
        Say "     The following variables may be used within commands:"
        Say " "
        Say "         $F    complete filename"
        Say "         $N    filename without path"
        Say "         $B    (base) filename without extension"
        Say "         $D    drive of filename"
        Say "         $E    filename extension (with dot)"
        Say "         $C    comment - rest of line is ignored"

        EXIT
/* end: main_help */

main_convert_commands : PROCEDURE EXPOSE global.
/*
 *      convert specified commands to list
 *      a list of command may contain commands separated by commas
 */
PARSE ARG cmds

        IF global.comfile <> 0 THEN DO
           /* we have a filename for a file containing a list of commands */
           filename = cmds
           IF (Stream(filename, "C", "OPEN READ") <> "READY:") THEN
              CALL main_error "Could not open '" || filename || "' for reading"

           /* read commandfile */
           linenum  = 0
           DO UNTIL lines(filename) = 0
              buffer = Linein(filename)
              /* process each line being read */
              CALL main_convert_command_line buffer
           END
           /* close file - no longer needed */
           CALL Stream filename, "C", "CLOSE"
           END
        ELSE
           /* collect all commands */
           CALL main_convert_command_line cmds
        RETURN
/* end: main_convert_commands */

main_convert_command_line : PROCEDURE EXPOSE global.
/*
 *      convert spec. list of commands to a global list of separate commands
 *      a list of command may contain commands separated by commas
 */
PARSE ARG cmds

        num_of_cmds = global.commands.0 + 1           /* commands so far */
        DO FOREVER
           idx = Pos(";", cmds)
           IF idx = 0 THEN DO
              global.commands.num_of_cmds = cmds
              LEAVE                                   /* break loop */
              END
           ELSE DO
              global.commands.num_of_cmds = Left(cmds, idx - 1)
              num_of_cmds = num_of_cmds + 1
              END
           cmds = Substr(cmds, idx + 1)
           END /* end-of-do-forever */

        global.commands.0 = num_of_cmds
        RETURN
/* end: main_convert_command_line */

main_filelist : PROCEDURE EXPOSE global.
/*
 *      create a filelist
 */
PARSE ARG filespec

        IF global.subdirs <> 0 THEN
           searchcode = "FS"                          /* files and subdirs */
        ELSE
           searchcode = "F"                           /* files only */

        CALL SysFileTree filespec, "global.files", searchcode, global.attributes

        IF global.files.0 = 0 THEN
           CALL main_msg "No files found for filespec '" || filespec || "' (" || global.attributes ")"

        RETURN
/* end: main_filelist */

main_exec : PROCEDURE EXPOSE global.
/*
 *      execute the specified commands on filelist
 */
        num_of_execs = 0

        /* process each file */
        DO i=1 to global.files.0
           filename = Translate(Substr(global.files.i, global.filename_offset))
           handled  = 0

           IF global.verbose <> 0 THEN
              SAY "file:" filename "   " Left(global.files.i, global.filename_offset - 1)

           /* extract filename extension */
           extension       = ""
           filename_nopath = ""
           filename_nopath = Filespec("N", filename)
           basename        = filename_nopath
           extension_pos   = Lastpos(".", filename_nopath)
           IF extension_pos > 0 THEN DO
              extension = Substr(filename_nopath, extension_pos)
              basename  = Left(filename_nopath, extension_pos - 1)
              END

           file_is_to_be_handled = 1                  /* assume: yes */
           IF global.query_file <> 0 THEN
              file_is_to_be_handled = query("file")

           IF file_is_to_be_handled <> 0 THEN DO
              /* process each command */
              DO j=1 to global.commands.0
                 cmd = Translate(global.commands.j)
                 /* replace variables used within command */
                 idx = Pos("$C", cmd)
                 IF idx > 0 THEN
                    cmd = Left(cmd, idx - 1)
                 cmd = replace(cmd, filename,                "$F")
                 cmd = replace(cmd, extension,               "$E")
                 cmd = replace(cmd, basename,                "$B")
                 cmd = replace(cmd, filename_nopath,         "$N")
                 cmd = replace(cmd, Filespec("D", filename), "$D")
                 cmd = replace(cmd, Filespec("P", filename), "$P")
                 /* is cmd still valid? */
                 IF cmd <> "" THEN DO
                    IF global.quiet = 0 THEN
                       SAY "exec:" cmd

                    exec_is_to_be_done = 1
                    IF global.query_exec <> 0 THEN
                       exec_is_to_be_done = query("command")

                    IF exec_is_to_be_done <> 0 THEN DO
                       handled = 1
                       /* execute command */
                       CMD

                       IF global.errcodes <> 0 THEN
                          SAY " Errorcode: " rc

                       END /* e-o-if exec */
                    END /* e-o-if cmd <> "" */
                 END /* e-o-do commands */
              END /* e-o-if query */

           IF handled = 1 THEN
              num_of_execs = num_of_execs + 1
           IF global.verbose <> 0 THEN
              SAY ""
        END /* e-o-do files */

        RETURN num_of_execs
/* end: main_exec */

replace : PROCEDURE
/*
 *      replace within the specified string the source pattern by the target pattern
 */
PARSE ARG string, target, source

        idx = Pos(source, string)
        IF idx > 0 THEN DO
           string = Delstr(string, idx, Length(source))
           string = Insert(target, string, idx - 1)
           END

        RETURN string
/* end: replace */

query : PROCEDURE EXPOSE global.
/*
 *      Query whether item is to be handled or not
 */
PARSE ARG item

        Say "confirm" item "with <enter>; ignore with <space>; abort with <esc>"
        DO FOREVER
           c = C2d(SysGetKey("NOECHO"))
           SELECT
             WHEN c = 13 THEN /* ENTER */
                  RETURN 1

             WHEN c = 32 THEN /* SPACE */
                  RETURN 0

             WHEN c = 27 THEN DO /* ESC */
                  CALL main_msg "Program aborted by user"
                  EXIT
                  END

             OTHERWISE
                  CALL Beep 100, 50
             END /* e-o-select */
           END /* e-o-do-forever */
/* end: query */

/* <EOF> */

