// ----------- screen.cpp
//
// modified for OS/2 operation - jw21sep93

#include <string.h>
#include "desktop.h"


Screen::Screen()
    {
    // Get current display configuration

    mi.cb = sizeof(mi);
    VioGetMode(&mi, 0);
    width  = mi.col;
    height = mi.row;
    }


// --------- scroll the screen d: 1 = up, 0 = dn

void Screen::Scroll(Rect &rc, int d, int fg, int bg)
    {
    char    cell[2];

    cell[0] = SPACECHAR;
    cell[1] = clr(fg,bg);

    desktop.mouse().Hide();

    if (d == 1 )
        {
        VioScrollUp((USHORT)rc.Top(), 
                    (USHORT)rc.Left(), 
                    (USHORT)rc.Bottom(), 
                    (USHORT)rc.Right(), 
                    1, 
                    (PBYTE16)&cell, 
                    0);
        }
    else
        {
        VioScrollDn((USHORT)rc.Top(), 
                    (USHORT)rc.Left(), 
                    (USHORT)rc.Bottom(), 
                    (USHORT)rc.Right(), 
                    1, 
                    (PBYTE16)&cell, 
                    0);
        }
    desktop.mouse().Show();
    }


// -------- read a character of video memory

unsigned int Screen::GetVideoChar(int x, int y)
    {
    USHORT c;
    USHORT cb = 2;

    desktop.mouse().Hide();
    VioReadCellStr((char *) &c, &cb, (USHORT)y, (USHORT)x, 0);
    desktop.mouse().Show();
    return (unsigned int) c;
    }


// -------- write a character of video memory
void Screen::PutVideoChar(int x, int y, unsigned int c)
    {
    if (x >= 0 && x < width && y >= 0 && y < height)    
        {
        desktop.mouse().Hide();
        VioWrtCellStr((char *) &c, 2, (USHORT)y, (USHORT)x, 0);
        desktop.mouse().Show();
        }
    }

// --------- Write a string to video memory

void Screen::WriteVideoString(const char *s, int x, int y, int fg, int bg)
    {
    if (x >= 0 && x < width && y >= 0 && y < height)
        {
        int   len = strlen(s);
        char *ln  = new char[len*2];
        char *cp1 = ln;

        unsigned char col = clr(fg,bg);

        while (*s)    
            {
            *cp1++ = (*s & 0xFF);
            *cp1++ = col;
            s++;
            }
        if (x + len >= width)
            {
            len = width - x;
            }
        desktop.mouse().Hide();
        VioWrtCellStr(ln, (USHORT)(len*2), (USHORT)y, (USHORT)x, 0);
        desktop.mouse().Show();
        delete [] ln;
        }
    }


// -- read a rectangle of video memory into a save buffer
void Screen::GetBuffer(Rect &rc, char *bf)
    {
    if ((rc.Left() < width) && (rc.Top() < height))
        {
        int ht = rc.Bottom()-rc.Top()+1;
        int row = rc.Top();
        int cb =  (rc.Right()-rc.Left()+1) * 2;
    
        desktop.mouse().Hide();
        while (ht--)    
            {
            VioReadCellStr(bf, 
                           (USHORT *)&cb, 
                           (USHORT)row, 
                           (USHORT)rc.Left(), 
                           0);

            bf = (char *)bf + cb;
            row++;
            }
        desktop.mouse().Show();
        }
    }

// -- write a rectangle of video memory from a save buffer
void Screen::PutBuffer(Rect &rc, char *bf)
    {
    if ((rc.Left() < width) && (rc.Top() < height))
        {
    	int ht  = rc.Bottom()-rc.Top()+1;
    	int cb  = (rc.Right()-rc.Left()+1) * 2;
    	int row = rc.Top();
    	
    	desktop.mouse().Hide();
    	while (ht--)    
    	    {
    	    VioWrtCellStr(bf, 
                          (USHORT)cb, 
                          (USHORT)row, 
                          (USHORT)rc.Left(), 
                          0);
    	    bf += cb;
    	    row++;
    	    }
    	desktop.mouse().Show();
        }
    }

