/**************************************************************
 *           D type file listing for OS/2                     *
 *                                                            *
 *Copyright 1993 C.E.Gaumer Software                          *
 *                                                            *
 *Type D/? for help                                           *
 *                                                            *
 *If you make any useful modifications to this program        *
 *  please send a copy of the modified program to me          *
 *  I would be most interested in seeing your mods            *
 *  address is on the help screen                             *
 *                                                            *
 *                                                            *
 *                                                            *
 *                                                            *
 *                                                            *
 *                                                            *
 *                                                            *
 *                                                            *
 *                                                            *
 *defswitch can be set for default switches for example       *
 *defswitch='/h' will show hidden files by default            *
 **************************************************************/

defswitch=''
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
attribs='**-**'
switch=''
argument=STRIP(arg(1))                                /*remove lead/trail */

if length(argument)>0 then do                         /*if arg supplied   */
   if POS('/',argument)>0 then do                     /*if switch supplied*/
      switch=SUBSTR(argument,POS('/',argument))       /*parse switch(es)  */

      argument=SUBSTR(argument,1,(POS('/',argument)-1))
                                                      /*remove switch(es) */
      fspec=STRIP(argument)                           /*remove lead/trail */
   end /* do */
   else fspec=argument                                /*if no switches    */
   if POS('?',switch)>0 then call help                /*does he want help?*/
   if length(argument)=0 then fspec='*.*'             /*if no filespec    */
   PARSE UPPER VAR switch switch                      /*upper case switch */

   fspec=STRIP(fspec,,' ')                            /*remove lead/trail */
   fspec=STRIP(fspec,,'"')                            /*remove quotes     */

   if(LASTPOS(':',fspec)=LENGTH(fspec))|(LASTPOS('\',fspec)=LENGTH(fspec)) then
      fspec=fspec||'*.*'
   else do
      call SysFileTree fspec,junk,'D'                 /*check if directory*/
      if(LASTPOS('*',fspec)=0 & LASTPOS('?',fspec)=0 & junk.0=1) then
      fspec=fspec||'\*.*'                             /*append if dir and */
   end
end                                                   /* no wildcards     */
else fspec='*.*'                                      /* if all else fails*/
if LENGTH(switch)=0 then PARSE UPPER VAR defswitch switch
if POS('H',switch)>0 then attribs='*****'

rc=SysFileTree(fspec,'file','F',attribs)              /* get filenames    */
filelen=12                                            /* minimum length   */
do i=1 to file.0
   temp.i=SUBSTR(file.i,LASTPOS('\',file.i)+1)
   if length(temp.i) > filelen then                   /* find max file    */
   filelen = length(temp.i)                           /*  name length     */
end /* do */
temp=SUBSTR(fspec,1,LASTPOS('\',fspec))               /* path only        */
if LENGTH(temp)=0 then temp=SUBSTR(fspec,1,LASTPOS(':',fspec))
temp=temp||'*.*'                                      /* all directories  */
if POS('D',switch)=0 then temp=fspec                  /*just matched dirs */
call SysFileTree temp ,'dfile','D'                    /* get directories  */
do i=1 to dfile.0                                     /*sift thru them    */
   temp.i=SUBSTR(dfile.i,LASTPOS('\',dfile.i)+1)
   if length(temp.i) > filelen then                   /* find max file    */
   filelen = length(temp.i)                           /*  name length     */
end /* do */
do i=1 to file.0
   size.i=SUBSTR(file.i,18,11)                        /* parse out size   */
   file.i=SUBSTR(file.i,LASTPOS('\',file.i)+1,filelen,' ') /* and name    */
end /* do */                                          /*  of files        */

do i=1 to dfile.0
   dsize.i='     <DIR> '                              /* make size <dir>  */
   dfile.i=SUBSTR(dfile.i,LASTPOS('\',dfile.i)+1,filelen,' ')
   if POS('S',switch)>0 then do                       /* we want subs     */
      temp=fspec
      if LASTPOS('\',temp)=0 then                     /*no '\' in fspec   */
         temp=INSERT(STRIP(dfile.i)||'\',temp,LASTPOS(':',temp))
      else
         temp=INSERT(STRIP(dfile.i)||'\',temp,LASTPOS('\',temp))
      rc=SysFileTree(temp,'subfile','FS')             /* get subdir files */
      dsize.i=0
      if subfile.0>0 then                             /* files exist      */
      do n=1 to subfile.0
         filesize= (SUBSTR(subfile.n,18,11))          /* get file size    */

         dsize.i=dsize.i+filesize                     /* add to total     */
      end                                             /*  for this dir    */
      dsize2.i=dsize.i                                /*save size for sort*/
      do n=LENGTH(dsize.i) to 8                       /*pad the one we'll */
         dsize.i=INSERT(' ',dsize.i,0)                /* use to print     */
      end
      dsize.i=INSERT('<',dsize.i,0)                   /* put the angle    */
      dsize.i=dsize.i||'>'                            /*brackets in place */
   end
end /* do */

call sort                                             /*call the sort func*/


line=2                                                /* init line count  */
list.1=''                                            /*build top line    */
do i=1 to filelen+12
   list.1=list.1||''
end

do while length(list.1) < (79-(filelen+11)) then
   list.1=list.1||''
   do i=1 to filelen+12
     list.1=list.1||''
   end
end

list.1=list.1||''
line=2
if dfile.0>0 then                                     /* if dirs  exist   */
do
   list.line=''                                      /* left  border     */
   do i=1 to dfile.0
      if length(list.line)+filelen+12 > 80 then       /* is this line     */
      do                                              /*           full ? */
        line=line+1                                   /* next line        */
        list.line=''                                 /* left  border     */
      end
      list.line=list.line||' '||dfile.i||dsize.i||'' /*put dfile,size,sep*/
   end
   i=line
   do while length(list.i) < (79-(filelen+11))        /*fill separators   */
      do n=1 to filelen+12                            /* when no more     */
         list.i=list.i||' '                           /*  dirs  left      */
      end
      list.i=list.i||''
   end
line=line+1
end
if file.0>0 then
do
   list.line=''                                       /* left  border     */
   do i=1 to file.0
      if length(list.line)+filelen+12 > 80             /* is this line     */
         then do                                       /*           full ? */
            line=line+1                                /* next line        */
            list.line=''                              /* left  border     */
         end
      list.line=list.line||' '||file.i||size.i||''    /*put file,size,sep */
   end

   i=line
   do while length(list.i) < (79-(filelen+11))         /*fill separators   */
      do n=1 to filelen+12                             /* when no more     */
        list.i=list.i||' '                             /*  files left      */
      end
   list.i=list.i||''
   end

line=line+1                                            /* increment line   */
end                                                    /*end of if files   */
list.line=''                                       /* start bottom     */
list.line=list.line||'[ dir '||fspec||' ]'             /* with filespec    */
next= (filelen+12)                                     /* where does next  */
do while next<length(list.line)                        /* 'T' character go?*/
   next=next+filelen+13
end
x= length(list.line)
do i=x to next                                        /* fill to there    */
   list.line=list.line||''
end
do while length(list.line) < (79-(filelen+11)) then   /* build rest of    */
   list.line=list.line||''                           /*  bottom border   */
   do i=1 to filelen+12
     list.line=list.line||''
   end
end
list.line=list.line||''                              /*finish bottom bor */
line=line+1
list.line=' '||dfile.0|| '~dir '
list.line=list.line||file.0|| '~fil '



totsize=0
do i=1 to file.0
   totsize=totsize+size.i                             /*add file sizes    */
end
   if POS('S',switch)>0 then                          /*if subs selected  */
do i=1 to dfile.0
   totsize=totsize+dsize2.i                           /*add dir sizes     */
end



drive=LEFT(fspec,2)                                   /*split 1st 2 chars */
if LASTPOS(':',drive)\=2 then do                  /*not valid drive spec? */
   direct=DIRECTORY()                                 /*then use current  */
   drive=LEFT(direct,2)                               /*split 1st 2 chars */
end

info=SysDriveInfo(drive)                              /*get drive info    */
freespace=WORD(info,2)
totspace=WORD(info,3)                                 /*parse drive info  */
usedspace=totspace-freespace
filesbar=0
if usedspace>0 then
   filesbar=TRUNC(totsize/totspace*80)               /* calc bar graph   */
usedbar=TRUNC((usedspace/totspace*80)-filesbar)       /* sizes            */


totsize= REVERSE(totsize)
n=(LENGTH(totsize)-1)/3
commaspace=3
do i=1 to n
   totsize= INSERT(',',totsize,commaspace)            /*build commas into */
   commaspace=commaspace+4                            /*numbers for disp  */
end
totsize= REVERSE(totsize)
list.line=list.line||totsize||'byt() '

usedspace= REVERSE(usedspace)
n=(LENGTH(usedspace)-1)/3
commaspace=3
do i=1 to n
   usedspace= INSERT(',',usedspace,commaspace)
   commaspace=commaspace+4
end
usedspace= REVERSE(usedspace)

freespace= REVERSE(freespace)
n=(LENGTH(freespace)-1)/3
commaspace=3
do i=1 to n
   freespace= INSERT(',',freespace,commaspace)
   commaspace=commaspace+4
end
freespace= REVERSE(freespace)
                                                    /*build last text line*/
list.line=list.line||usedspace||'byt~used() '||freespace||'byt~free(_)'
temp=SPACE(list.line,(TRUNC((79-LENGTH(list.line))/4)))/*let REXX space it*/
list.line=' '
do i=1 to LENGTH(temp)/*then replace the '~' we used to make words w/spaces*/
  if(SUBSTR(temp,i,1))='~' then list.line=list.line||' '
  else list.line=list.line||SUBSTR(temp,i,1)
end

line=line+1
list.line=''
if filesbar>0 then
   do i=1 to filesbar
      list.line=list.line||''
   end                                      /* build bargraph  */
if usedbar>0 then
   do i=1 to usedbar
      list.line=list.line||''
   end
if LENGTH(list.line)<79 then
   do i=LENGTH(list.line) to 79
      list.line=list.line||'_'
   end


/* All done building printable list so let's print it */

parse value SysTextScreenSize() with vrows col        /*how big is screen?*/
list.0=line
do i=1 to list.0
   if i//(vrows-2)=0&POS('N',switch)=0 then           /* if screen is full*/
                                                      /* and pause not off*/
   call wait                                          /* call'MORE'routine*/
   say list.i                                         /* print line       */
end
call SysDropFuncs                                     /*  cleanup         */
EXIT                                                  /* and go home!!    */


/********************WAIT FUNCTION FOR "MORE..." PROMPT*******************/
wait:
parse value SysCurPos() with row col                  /*where is cursor?  */
row=row-1                                             /*we will scroll 1  */
say More...                                           /* with this...     */
call SysGetKey(NOECHO)                                /* get a key        */
call SysCurPos row,col                                /* put cursor back  */
return                                                /* go back          */

/******************SORT FUNCTION ***************************************/
sort:
sort.0=file.0
do i=1 to file.0
   if POS('C',switch)=0 then PARSE UPPER VAR file.i sort.i
   else sort.i=file.i
end


do until done=1
   done=1
   do i=1 to (file.0-1)
      n=i+1
      if sort.i>sort.n then do
         temp=file.i
         stemp=size.i
         sstemp=sort.i
         file.i=file.n
         size.i=size.n
         sort.i=sort.n
         file.n=temp
         size.n=stemp
         sort.n=sstemp
         done=0
      end
   end
end

/*  Now sort directory names */

sort.0=dfile.0
do i=1 to dfile.0
   if POS('C',switch)=0 then PARSE UPPER VAR dfile.i sort.i
   else sort.i=dfile.i
end


do until done=1
   done=1
   do i=1 to (dfile.0-1)
      n=i+1
      if sort.i>sort.n then do
         temp=dfile.i
         stemp=dsize.i
         sstemp=sort.i
         dfile.i=dfile.n
         dsize.i=dsize.n
         sort.i=sort.n
         dfile.n=temp
         dsize.n=stemp
         sort.n=sstemp
         done=0
      end
   end
end
return


/*************************HELP FUNCTION*********************************/
help:
say 'D.CMD REXX Directory Display and Sort for OS/2'
say '(c)Copyright 1993'
say''
say 'C.E.Gaumer Software'
say 'P.O. Box 383'
say 'Laurys Station, PA 18059'
say ''
say 'Useage is D [filespec] [/]|[/s /c /n /h /d]'
say 'Filespec is any valid file specification with or without wildcards,'
say ' a drive spec and/or path which may be absolute or relative to'
say ' the current directory'
say ''
say '/  means ignore user set default switches'
say '/s means calculate the size of matching files in all subdirectories'
say '/c means sort case sensitive (lower case after uppercase)'
say '/h means show hidden files (hidden directories always shown)'
say '/n means no pause (good when redirecting output)'
say '/d means show all directories (matching file spec or not)'
say '/? means display this screen'
call SysDropFuncs                                     /*  cleanup         */
EXIT                                                  /* and go home!!    */
