/**************************************************************************
 *
 *  COMMOS2.H
 *
 *  This file provides the headers for the IOPL and basic serial services
 *  provided by this library.
 *_________________________________________________________________________
 *
 *  Copyright (c) 1992 by ASH Software, Inc.
 *
 *  Update History
 *
 *    11/28/1992 - Module created
 *
 **************************************************************************/

#if !defined(COMMOS2__H)
  #define COMMOS2__H

  //
  // Basic definitions
  //

  #define TIMEOUT_INDEFINITE          -1L

  #define PARITY_NONE                  0
  #define PARITY_ODD                   1
  #define PARITY_EVEN                  2
  #define PARITY_MARK                  3
  #define PARITY_SPACE                 4

  #define STOPBITS_1                   0
  #define STOPBITS_1_POINT_5           1
  #define STOPBITS_2                   2

  #define TRANSMIT_BREAK               0x01
  #define TRANSMIT_NO_BREAK            0x00

  //
  // Comm Mode definitions
  //

  #define COMM_MODE_NOTSTARTED                     0ul
  #define COMM_MODE_OPEN                           1ul
  #define COMM_MODE_WRITE                          2ul
  #define COMM_MODE_READ                           3ul
  #define COMM_MODE_READTIMEOUT                    4ul
  #define COMM_MODE_READUNTILBYTE                  5ul
  #define COMM_MODE_SETBAUD                        6ul
  #define COMM_MODE_SETLINECNTRL                   7ul
  #define COMM_MODE_CLEARTXBUFFER                  8ul
  #define COMM_MODE_CLEARRXBUFFER                  9ul
  #define COMM_MODE_QUERYRXCOUNT                  10ul
  #define COMM_MODE_QUERYRXBUFSIZE                11ul
  #define COMM_MODE_QUERYTXCOUNT                  12ul
  #define COMM_MODE_QUERYTXBUFSIZE                13ul

  //
  // Comm Error Codes
  //

  #define COMM_ERROR_NOERROR                       0ul
  #define COMM_ERROR_SYSINITFAILED                 1ul
  #define COMM_ERROR_INVALIDMAXPORTS               2ul
  #define COMM_ERROR_ALREADYINITIALIZED            3ul
  #define COMM_ERROR_MAXPORTSEXCEEDED              4ul
  #define COMM_ERROR_OPENFAILED                    5ul
  #define COMM_ERROR_PORTNOTFOUND                  6ul
  #define COMM_ERROR_WRITEFAILED                   7ul
  #define COMM_ERROR_READFAILED                    8ul
  #define COMM_ERROR_IOCTLFAILED                   9ul
  #define COMM_ERROR_TIMEOUTEXCEEDED              10ul
  #define COMM_ERROR_BAUDFAILED                   11ul
  #define COMM_ERROR_LINECNTRLFAILED              12ul
  #define COMM_ERROR_CLEARBUFFERFAILED            13ul
  #define COMM_ERROR_SEMAPHOREFAILED              14ul

  //
  // This section is used with 16-bit applications (OS/2 1.x).
  //

  #if defined(INCL_COMMOS2_16BIT)
    #define CommStartSystem       COMMSTART16
    #define CommStopSystem        COMMSTOP16
    #define CommGetLastError      COMMERROR16
    #define CommOpen              COMMOPEN16
    #define CommInit              COMMINIT16
    #define CommClear             COMMCLEAR16
    #define CommClearTxBuffer     COMMTXBUF16
    #define CommClearRxBuffer     COMMRXBUF16
    #define CommClose             COMMCLOSE16
    #define CommClear             COMMCLEAR16
    #define CommWrite             COMMWRITE16
    #define CommRead              COMMREAD16
    #define CommReadTimeOut       COMMREADTIMEOUT16
    #define CommReadUntilByte     COMMREADUNTILBYTE16
    #define CommQueryRxCount      COMMQRXCOUNT16
    #define CommQueryRxBufSize    COMMQRXBUFSIZE16
    #define CommQueryTxCount      COMMQTXCOUNT16
    #define CommQueryTxBufSize    COMMQTXBUFSIZE16

    //
    // IOPL 16-bit interface function prototypes which may be called by
    // 16-bit applications
    //

    VOID PortOutByte(USHORT usPortAddress,BYTE bParam);
    VOID PortOutWord(USHORT usPortAddress,USHORT usParam);
    USHORT PortInpByte(USHORT usPortAddress);
    USHORT PortInpWord(USHORT usPortAddress);

    //
    // 16-bit IOPL Assembler prototypes which can be called directly
    // by 16-bit applications.
    //

    extern int  far pascal ioplinp (unsigned int portaddress);
    extern int  far pascal ioplinpw(unsigned int portaddress);
    extern void far pascal ioplout (unsigned int portaddress,
      unsigned char outputbyte);
    extern void far pascal ioploutw(unsigned int portaddress,
      unsigned int outputword);

  #endif

  //
  // This section is used with 32-bit applications (OS/2 2.x).
  //

  #if defined(INCL_COMMOS2_32BIT)
    #define CommStartSystem       COMMSTART32
    #define CommStopSystem        COMMSTOP32
    #define CommGetLastError      COMMERROR32
    #define CommOpen              COMMOPEN32
    #define CommInit              COMMINIT32
    #define CommClear             COMMCLEAR32
    #define CommClearTxBuffer     COMMTXBUF32
    #define CommClearRxBuffer     COMMRXBUF32
    #define CommClose             COMMCLOSE32
    #define CommWrite             COMMWRITE32
    #define CommRead              COMMREAD32
    #define CommReadTimeOut       COMMREADTIMEOUT32
    #define CommReadUntilByte     COMMREADUNTILBYTE32
    #define CommQueryRxCount      COMMQRXCOUNT32
    #define CommQueryRxBufSize    COMMQRXBUFSIZE32
    #define CommQueryTxCount      COMMQTXCOUNT32
    #define CommQueryTxBufSize    COMMQTXBUFSIZE32

    //
    // IOPL 16-bit interface function prototypes to be called by
    // 32-bit applications
    //

    VOID APIENTRY16 PortOutByte(USHORT usPortAddress,BYTE bParam);
    VOID APIENTRY16 PortOutWord(USHORT usPortAddress,USHORT usParam);
    APIRET16 APIENTRY16 PortInpByte(USHORT usPortAddress);
    APIRET16 APIENTRY16 PortInpWord(USHORT usPortAddress);

  #endif

  //
  // This section includes support for basic serial port access from
  // an OS/2 application.
  //

  unsigned long CommStartSystem(int iCommPorts);
  unsigned long CommStopSystem(void);
  unsigned long CommGetLastError(HFILE hCommPort,
           unsigned long *ulCommError,unsigned long *ulDosError,
           unsigned long *ulCommMode);
  unsigned long CommOpen(int iCommPort,HFILE *phCommPort);
  unsigned long CommInit(HFILE hCommPort,unsigned short usBaudRate,
           unsigned short usParity,unsigned short usDataBits,
           unsigned short usStopBits,unsigned short usTxBreak);
  unsigned long CommClear(HFILE hCommPort);
  unsigned long CommClearTxBuffer(HFILE hCommPort);
  unsigned long CommClearRxBuffer(HFILE hCommPort);
  unsigned long CommClose(HFILE hCommPort);
  unsigned long CommWrite(HFILE hCommPort,unsigned char *pucDataArea,
           unsigned short usDataAreaSize,unsigned long *pulWritten);
  unsigned long CommRead(HFILE hCommPort,unsigned char *pucDataArea,
           unsigned short usDataAreaSize,unsigned long *pulRead);
  unsigned long CommReadTimeOut(HFILE hCommPort,
           unsigned char *pucDataArea,unsigned short usDataAreaSize,
           unsigned long *pulRead,long lTimeOutmSec);
  unsigned long CommReadUntilByte(HFILE hCommPort,
           unsigned char *pucDataArea,unsigned short usDataAreaSize,
           unsigned long *pulRead,unsigned char ucWaitByte,
           long lTimeOutmSec);
  unsigned long CommQueryRxCount(HFILE hCommPort,unsigned long *ulCount);
  unsigned long CommQueryRxBufSize(HFILE hCommPort,unsigned long *ulSize);
  unsigned long CommQueryTxCount(HFILE hCommPort,unsigned long *ulCount);
  unsigned long CommQueryTxBufSize(HFILE hCommPort,unsigned long *ulSize);

#endif
