/**************************************************************************
 *
 *  COMM.H
 *
 *  This file contains the header file needed to compile COMM16.C and
 *  COMM32.C.  This file should not be included in source code which
 *  wishes to use the COMMOS2 library.
 *_________________________________________________________________________
 *
 *  Copyright (c) 1992 by ASH Software, Inc.
 *
 *  Update History
 *
 *    12/ 6/1992 - Module created
 *
 **************************************************************************/

#if !defined(COMM__H)
  #define COMM__H

  #define INCL_DOS
  #define INCL_ERRORS
  #define INCL_DOSDEVIOCTL
  #define INCL_DOSDEVICES
  
  #include <os2.h>
  #include <stdio.h>
  #include <stdlib.h>
  
  #include "COMMOS2.H"

  #define COMM_QUERY_RXCOUNT             1
  #define COMM_QUERY_RXBUFFER            2
  #define COMM_QUERY_TXCOUNT             3
  #define COMM_QUERY_TXBUFFER            4

  #if defined(INCL_COMMOS2_16BIT)
    static DOSFSRSEM hCommSem;
    #define CommGetErrorStruct    COMMERRSTRUCT16
    #define TimerValue            TIMERVALUE16
    #define TimerDifference       TIMERDIFFERENCE16
    #define CommQueryQueue        COMMQUERYQUEUE16
  #endif

  #if defined(INCL_COMMOS2_32BIT)
    static HMTX hCommSem;
    #define CommGetErrorStruct    COMMERRSTRUCT32
    #define TimerValue            TIMERVALUE32
    #define TimerDifference       TIMERDIFFERENCE32
    #define CommQueryQueue        COMMQUERYQUEUE32
  #endif

  //
  // Define the Comm library error structure and declare an external
  // pointer to an array of these structures.  The static global pointer 
  // will be allocated during processing of CommStartSystem and freed
  // during processing of CommStopSystem.
  //
  
  typedef struct
  {
  unsigned long ulCommErrorCode; // Last Comm error code
  unsigned long ulDosErrorCode;  // Last Dos error code
  unsigned long ulCommMode;      // Last Comm mode
  HFILE         hCommPort;       // Handle to Comm port
  int           fPortOpened;     // An attempt to open the port was made
  int           fPortOpen;       // Comm port is actually open
  } COMM_ERROR_CODE;
  typedef COMM_ERROR_CODE *PCOMM_ERROR_CODE;
  
  static PCOMM_ERROR_CODE
    pCommOS2ErrorCode;

  static int
    iMaxNumberCommPorts = 0;

  //
  // Declare static functions
  //

  static PCOMM_ERROR_CODE CommGetErrorStruct(HFILE hCommPort);
  static unsigned long TimerValue(void);
  static unsigned long TimerDifference(unsigned long ulBaseTimerValue);
  static unsigned long CommQueryQueue(HFILE hCommPort,short sMode,
    unsigned long *ulValue);

#endif
