;
;  PORTIOPL
;
;  This procedure provide io priviledge routines for reading from
;  or writting to a port.
;
;  This procedure was compiled with MASM 6.0 using the default flags.
;
;  Copyright (c) 1992 by ASH Software, Inc.
;

.286c
memL equ 1                              ; Use large memory module
?DF=1                                   ; Do not define default groups
?PLM=1                                  ; Use Pascal calling convention
?WIN=0                                  ; Not using Windows

include cmacros.inc

;
;  Create a segment which will be given IOPL priviledge
;

createSeg _portiopl, portiopl, byte, public, CODE
IOPLGROUP GROUP _portiopl

sBegin  portiopl
assumes cs,_portiopl

;
;  This procedure provides IOPL access to read a single byte from
;  a data port.
;

cProc   ioplinp,<FAR,PUBLIC>,<es,si>
        parmW     portaddr

cBegin
        mov       dx,portaddr
        in        al,dx
        mov       ah,0
cEnd

;
;  This procedure provides IOPL access to write a single byte to
;  a data port.
;

cProc   ioplout,<FAR,PUBLIC>,<es,si>
        parmW     portaddr
        parmB     outbyte

cBegin
        mov       al,outbyte
        mov       dx,portaddr
        out       dx,al
cEnd

;
;  This procedure provides IOPL access to read a single word from
;  a data port.
;

cProc   ioplinpw,<FAR,PUBLIC>,<es,si>
        parmW     portaddr

cBegin
        mov       dx,portaddr
        in        ax,dx
cEnd

;
;  This procedure provides IOPL access to write a single word to
;  a data port.
;

cProc   ioploutw,<FAR,PUBLIC>,<es,si>
        parmW     portaddr
        parmW     outword

cBegin
        mov       ax,outword
        mov       dx,portaddr
        out       dx,al
cEnd

sEnd    portiopl
end

