/**************************************************************************
 *
 *  TESTCOMM.CPP
 *
 *  This file contains a VERY simple C++ test case for the COMMOS2 library.
 *  Program assumes that a modem is connected to port 2 and is capable of
 *  9600 baud transmission speed.  The program sends ATZ<CR><LF> to the
 *  port and displays the text returned which is usually the ATZ string
 *  and an OK string.
 *
 *  This file was compiled with the IBM C/C++ beta compiler using the
 *  following flags:
 *
 *      /Fd /Tdp /G3m+s-d-e+ /O /Re /C /W3gen+ppc+enu+par+
 *_________________________________________________________________________
 *
 *  Copyright (c) 1992 by ASH Software, Inc.
 *
 *  Update History
 *
 *    12/17/1992 - Module created
 *
 **************************************************************************/

#include <os2.h>
#include "commos2.hpp"
#include <stdio.h>

#define CR   0x0D
#define LF   0x0A

int main()
{
SHORT
  sKeepReading;

ULONG
  ulByte,
  ulRC;

HFILE
  hComm2;

UCHAR
  CharString[81];

CommPort
  COM2;

printf("\nProgram Starting");

if ((ulRC=COM2.Open(2)) == COMM_ERROR_NOERROR)
  {

  // Comm port is open

  printf("\nOpen Successful");
  if ((ulRC=COM2.Initialize()) == COMM_ERROR_NOERROR)
    {

    // Comm port has been initialized to the default of 9600,n,8,1

    printf("\nInitialize Successful");

    if ((ulRC=COM2.ClearBuffers()) != COMM_ERROR_NOERROR)
      printf("\nClear Failed");

    CharString[0]='A';
    CharString[1]='T';
    CharString[2]='Z';
    CharString[3]=CR;
    CharString[4]=LF;

    // Write ATZ<CR><LF> to the modem

    if ((ulRC=COM2.Write(CharString,5,&ulByte)) != COMM_ERROR_NOERROR)
      printf("\nWrite Failed");

    // Read the port until no more characters are returned

    sKeepReading=TRUE;
    do
      {

      // Read until 81 characters are received or the <LF> is read

      if ((ulRC=COM2.ReadUntilByte(CharString,81,&ulByte,LF,2000))
           != COMM_ERROR_NOERROR)
        {
        if (ulRC == COMM_ERROR_TIMEOUTEXCEEDED)
          printf("\nReadUntilByte Timed Out");
        else
          printf("\nReadUntilByte Failed");
        sKeepReading=FALSE;
        }
    
      // Print the data returned from the port

      if (ulByte > 0)
        {
        CharString[ulByte]='\0';
        printf("\nReceived :%s",CharString);
        }
      else
        sKeepReading=FALSE;
      } while (sKeepReading);
    }
  else
    printf("\nInitialize Failed");
  COM2.Close();
  }
else
  printf("\nOpen Failed");

printf("\nProgram Terminating\n");
return 0;
}

