/**************************************************************************
 *
 *  TESTCOMM.C
 *
 *  This file contains a VERY simple test case for the COMMOS2 library.
 *  Program assumes that a modem is connected to port 2 and is capable of
 *  9600 baud transmission speed.  The program sends ATZ<CR><LF> to the
 *  port and displays the text returned which is usually the ATZ string
 *  and an OK string.
 *_________________________________________________________________________
 *
 *  Copyright (c) 1992 by ASH Software, Inc.
 *
 *  Update History
 *
 *    12/17/1992 - Module created
 *
 **************************************************************************/

#define INCL_COMMOS2_32BIT

#include <os2.h>
#include "commos2.h"
#include <stdio.h>

#define CR   0x0D
#define LF   0x0A

int main()
{
SHORT
  sKeepReading;

ULONG
  ulByte,
  ulRC;

HFILE
  hComm2;

CHAR
  CharString[81];

if ((ulRC=CommStartSystem(4)) == COMM_ERROR_NOERROR)
  {

  // Comm System has been initialized

  printf("\nCommStartSystem Successful");
  if ((ulRC=CommOpen(2,&hComm2)) == COMM_ERROR_NOERROR)
    {

    // Comm port is open

    printf("\nCommOpen Successful");
    if ((ulRC=CommInit(hComm2,9600,PARITY_NONE,8,STOPBITS_1,
          TRANSMIT_NO_BREAK)) == COMM_ERROR_NOERROR)
      {

      // Comm port has been initialized to 9600,n,8,1

      printf("\nCommInit Successful");

      if ((ulRC=CommClear(hComm2)) != COMM_ERROR_NOERROR)
        printf("\nCommClear Failed");

      CharString[0]='A';
      CharString[1]='T';
      CharString[2]='Z';
      CharString[3]=CR;
      CharString[4]=LF;

      // Write ATZ<CR><LF> to the modem

      if ((ulRC=CommWrite(hComm2,CharString,5,&ulByte)) != COMM_ERROR_NOERROR)
        printf("\nCommWrite Failed");

      // Read the port until no more characters are returned

      sKeepReading=TRUE;
      do
        {

        // Read until 81 characters are received or the <LF> is read

        if ((ulRC=CommReadUntilByte(hComm2,CharString,81,&ulByte,LF,2000))
             != COMM_ERROR_NOERROR)
          {
          if (ulRC == COMM_ERROR_TIMEOUTEXCEEDED)
            printf("\nCommReadUntilByte Timed Out");
          else
            printf("\nCommReadUntilByte Failed");
          sKeepReading=FALSE;
          }
      
        // Print the data returned from the port

        if (ulByte > 0)
          {
          CharString[ulByte]='\0';
          printf("\nReceived :%s",CharString);
          }
        else
          sKeepReading=FALSE;
        } while (sKeepReading);
      }
    else
      printf("\nCommInit Failed");
    CommClose(hComm2);
    }
  else
    printf("\nCommOpen Failed");
  CommStopSystem();
  }  
else
  printf("\nCommStartSystem Failed");

printf("\nProgram Terminating\n");
return 0;
}

